/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.crops;

import buildcraft.api.crops.ICropHandler;
import buildcraft.core.lib.utils.BlockUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class CropHandlerPlantable
implements ICropHandler {
    @Override
    public boolean isSeed(ItemStack stack) {
        Block block;
        if (stack.func_77973_b() instanceof IPlantable) {
            return true;
        }
        return stack.func_77973_b() instanceof ItemBlock && (block = ((ItemBlock)stack.func_77973_b()).field_150939_a) instanceof IPlantable && block != Blocks.field_150436_aH;
    }

    @Override
    public boolean canSustainPlant(World world, ItemStack seed, int x, int y, int z) {
        IPlantable plantable;
        if (seed.func_77973_b() instanceof IPlantable) {
            return world.func_147439_a(x, y, z).canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)seed.func_77973_b()) && world.func_147437_c(x, y + 1, z);
        }
        Block block = world.func_147439_a(x, y, z);
        return block.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, plantable = (IPlantable)((ItemBlock)seed.func_77973_b()).field_150939_a) && block != ((ItemBlock)seed.func_77973_b()).field_150939_a && world.func_147437_c(x, y + 1, z);
    }

    @Override
    public boolean plantCrop(World world, EntityPlayer player, ItemStack seed, int x, int y, int z) {
        return BlockUtils.useItemOnBlock(world, player, seed, x, y, z, ForgeDirection.UP);
    }

    @Override
    public boolean isMature(IBlockAccess blockAccess, Block block, int meta, int x, int y, int z) {
        if (block == null) {
            return false;
        }
        if (block instanceof BlockTallGrass || block instanceof BlockMelon || block instanceof BlockMushroom || block instanceof BlockDoublePlant || block == Blocks.field_150423_aK) {
            return true;
        }
        if (block instanceof BlockCrops) {
            return meta == 7;
        }
        if (block instanceof BlockNetherWart) {
            return meta == 3;
        }
        return block instanceof IPlantable && y > 0 && blockAccess.func_147439_a(x, y - 1, z) == block;
    }

    @Override
    public boolean harvestCrop(World world, int x, int y, int z, List<ItemStack> drops) {
        if (!world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (BlockUtils.breakBlock((WorldServer)world, x, y, z, drops)) {
                world.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
                return true;
            }
        }
        return false;
    }
}

