/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.BuildCraftCore;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.Position;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.lib.utils.BitSetUtils;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.BitSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import org.apache.logging.log4j.Level;

public abstract class BptBuilderBase
implements IAreaProvider {
    public BlueprintBase blueprint;
    public BptContext context;
    protected BitSet usedLocations;
    protected boolean done;
    protected int x;
    protected int y;
    protected int z;
    protected boolean initialized = false;
    private long nextBuildDate = 0L;

    public BptBuilderBase(BlueprintBase bluePrint, World world, int x, int y, int z) {
        this.blueprint = bluePrint;
        this.x = x;
        this.y = y;
        this.z = z;
        this.usedLocations = new BitSet(bluePrint.sizeX * bluePrint.sizeY * bluePrint.sizeZ);
        this.done = false;
        Box box = new Box();
        box.initialize(this);
        this.context = bluePrint.getContext(world, box);
    }

    protected boolean isLocationUsed(int i, int j, int k) {
        int xCoord = i - this.x + this.blueprint.anchorX;
        int yCoord = j - this.y + this.blueprint.anchorY;
        int zCoord = k - this.z + this.blueprint.anchorZ;
        return this.usedLocations.get((zCoord * this.blueprint.sizeY + yCoord) * this.blueprint.sizeX + xCoord);
    }

    protected void markLocationUsed(int i, int j, int k) {
        int xCoord = i - this.x + this.blueprint.anchorX;
        int yCoord = j - this.y + this.blueprint.anchorY;
        int zCoord = k - this.z + this.blueprint.anchorZ;
        this.usedLocations.set((zCoord * this.blueprint.sizeY + yCoord) * this.blueprint.sizeX + xCoord, true);
    }

    public void initialize() {
        if (!this.initialized) {
            this.internalInit();
            this.initialized = true;
        }
    }

    protected abstract void internalInit();

    protected abstract BuildingSlot reserveNextBlock(World var1);

    protected abstract BuildingSlot getNextBlock(World var1, TileAbstractBuilder var2);

    public boolean buildNextSlot(World world, TileAbstractBuilder builder, double x, double y, double z) {
        this.initialize();
        if (world.func_82737_E() < this.nextBuildDate) {
            return false;
        }
        BuildingSlot slot = this.getNextBlock(world, builder);
        if (this.buildSlot(world, builder, slot, x + 0.5, y + 0.5, z + 0.5)) {
            this.nextBuildDate = world.func_82737_E() + (long)slot.buildTime();
            return true;
        }
        return false;
    }

    public boolean buildSlot(World world, IBuildingItemsProvider builder, BuildingSlot slot, double x, double y, double z) {
        this.initialize();
        if (slot != null) {
            slot.built = true;
            BuildingItem i = new BuildingItem();
            i.origin = new Position(x, y, z);
            i.destination = slot.getDestination();
            i.slotToBuild = slot;
            i.context = this.getContext();
            i.setStacksToDisplay(slot.getStacksToDisplay());
            builder.addAndLaunchBuildingItem(i);
            return true;
        }
        return false;
    }

    public BuildingSlot reserveNextSlot(World world) {
        this.initialize();
        return this.reserveNextBlock(world);
    }

    @Override
    public int xMin() {
        return this.x - this.blueprint.anchorX;
    }

    @Override
    public int yMin() {
        return this.y - this.blueprint.anchorY;
    }

    @Override
    public int zMin() {
        return this.z - this.blueprint.anchorZ;
    }

    @Override
    public int xMax() {
        return this.x + this.blueprint.sizeX - this.blueprint.anchorX - 1;
    }

    @Override
    public int yMax() {
        return this.y + this.blueprint.sizeY - this.blueprint.anchorY - 1;
    }

    @Override
    public int zMax() {
        return this.z + this.blueprint.sizeZ - this.blueprint.anchorZ - 1;
    }

    @Override
    public void removeFromWorld() {
    }

    public AxisAlignedBB getBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.xMin(), (double)this.yMin(), (double)this.zMin(), (double)this.xMax(), (double)this.yMax(), (double)this.zMax());
    }

    public void postProcessing(World world) {
    }

    public BptContext getContext() {
        return this.context;
    }

    public boolean isDone(IBuildingItemsProvider builder) {
        return this.done && builder.getBuilders().size() == 0;
    }

    private int getBlockBreakEnergy(BuildingSlotBlock slot) {
        return BlockUtils.computeBlockBreakEnergy(this.context.world(), slot.x, slot.y, slot.z);
    }

    protected final boolean canDestroy(TileAbstractBuilder builder, IBuilderContext context, BuildingSlotBlock slot) {
        return builder.energyAvailable() >= this.getBlockBreakEnergy(slot);
    }

    public void consumeEnergyToDestroy(TileAbstractBuilder builder, BuildingSlotBlock slot) {
        builder.consumeEnergy(this.getBlockBreakEnergy(slot));
    }

    public void createDestroyItems(BuildingSlotBlock slot) {
        int hardness = (int)Math.ceil((double)this.getBlockBreakEnergy(slot) / 160.0);
        for (int i = 0; i < hardness; ++i) {
            slot.addStackConsumed(new ItemStack((Block)BuildCraftCore.buildToolBlock));
        }
    }

    public void useRequirements(IInventory inv, BuildingSlot slot) {
    }

    public void saveBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        nbt.func_74773_a("usedLocationList", BitSetUtils.toByteArray(this.usedLocations));
        NBTTagList buildingList = new NBTTagList();
        for (BuildingItem item : builder.getBuilders()) {
            NBTTagCompound sub = new NBTTagCompound();
            item.writeToNBT(sub);
            buildingList.func_74742_a((NBTBase)sub);
        }
        nbt.func_74782_a("buildersInAction", (NBTBase)buildingList);
    }

    public void loadBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        BlockIndex o;
        NBTTagCompound cpt;
        if (nbt.func_74764_b("usedLocationList")) {
            this.usedLocations = BitSetUtils.fromByteArray(nbt.func_74770_j("usedLocationList"));
        }
        NBTTagList buildingList = nbt.func_150295_c("buildersInAction", 10);
        for (int i = 0; i < buildingList.func_74745_c(); ++i) {
            BuildingItem item = new BuildingItem();
            try {
                item.readFromNBT(buildingList.func_150305_b(i));
                item.context = this.getContext();
                builder.getBuilders().add(item);
                continue;
            }
            catch (MappingNotFoundException e) {
                BCLog.logger.log(Level.WARN, "can't load building item", (Throwable)e);
            }
        }
        if (nbt.func_74764_b("clearList")) {
            NBTTagList clearList = nbt.func_150295_c("clearList", 10);
            for (int i = 0; i < clearList.func_74745_c(); ++i) {
                cpt = clearList.func_150305_b(i);
                o = new BlockIndex(cpt);
                this.markLocationUsed(o.x, o.y, o.z);
            }
        }
        if (nbt.func_74764_b("builtList")) {
            NBTTagList builtList = nbt.func_150295_c("builtList", 10);
            for (int i = 0; i < builtList.func_74745_c(); ++i) {
                cpt = builtList.func_150305_b(i);
                o = new BlockIndex(cpt);
                this.markLocationUsed(o.x, o.y, o.z);
            }
        }
    }

    protected boolean isBlockBreakCanceled(World world, int x, int y, int z) {
        if (!world.func_147437_c(x, y, z)) {
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(x, y, z, world, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z), (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)world).get());
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            return breakEvent.isCanceled();
        }
        return false;
    }

    protected boolean isBlockPlaceCanceled(World world, int x, int y, int z, SchematicBlockBase schematic) {
        Block block = schematic instanceof SchematicBlock ? ((SchematicBlock)schematic).block : Blocks.field_150348_b;
        int meta = schematic instanceof SchematicBlock ? ((SchematicBlock)schematic).meta : 0;
        BlockEvent.PlaceEvent placeEvent = new BlockEvent.PlaceEvent(new BlockSnapshot(world, x, y, z, block, meta), Blocks.field_150350_a, (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)world, x, y, z).get());
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        return placeEvent.isCanceled();
    }
}

