/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.mystcraft.v2;

import com.xcompwiz.mystcraft.api.APIInstanceProvider;
import com.xcompwiz.mystcraft.api.exception.APIUndefined;
import com.xcompwiz.mystcraft.api.exception.APIVersionRemoved;
import com.xcompwiz.mystcraft.api.exception.APIVersionUndefined;
import com.xcompwiz.mystcraft.api.hook.LinkPropertyAPI;
import com.xcompwiz.mystcraft.api.hook.LinkingAPI;
import com.xcompwiz.mystcraft.api.hook.PageAPI;
import com.xcompwiz.mystcraft.api.hook.SymbolAPI;
import openmods.Log;

public class MystcraftAccess {
    static LinkingAPI linkingApi;
    static LinkPropertyAPI linkPropertiesApi;
    static PageAPI pageApi;
    public static SymbolAPI symbolApi;

    public static <T> T getApi(APIInstanceProvider provider, String api) {
        try {
            return (T)provider.getAPIInstance(api);
        }
        catch (APIUndefined e) {
            Log.warn((Throwable)e, (String)"Mystraft API %s is not provided. Some functionality may be disabled.", (Object[])new Object[0]);
        }
        catch (APIVersionUndefined e) {
            Log.warn((Throwable)e, (String)"Mystraft API %s version is unavalable. Some functionality may be disabled.", (Object[])new Object[0]);
        }
        catch (APIVersionRemoved e) {
            Log.warn((Throwable)e, (String)"Mystraft API %s version is unsupported. Some functionality may be disabled.", (Object[])new Object[0]);
        }
        catch (Exception e) {
            Log.warn((Throwable)e, (String)"Unknown exception why trying to get Mystcraft API %s", (Object[])new Object[]{api});
        }
        return null;
    }

    public static void init(APIInstanceProvider provider) {
        linkingApi = (LinkingAPI)MystcraftAccess.getApi(provider, "linking-1");
        linkPropertiesApi = (LinkPropertyAPI)MystcraftAccess.getApi(provider, "linkingprop-1");
        pageApi = (PageAPI)MystcraftAccess.getApi(provider, "page-1");
        symbolApi = (SymbolAPI)MystcraftAccess.getApi(provider, "symbol-1");
    }
}

