/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.recipes;

import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.aobd.lib.CompatType;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobd.recipes.RecipesModule;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class ModulesHandler {
    private static final Map<CompatType, RecipesModule> modules = new HashMap<CompatType, RecipesModule>();

    public static void createModules() {
        try {
            for (CompatType compat : CompatType.values()) {
                if (!compat.isEnabled()) continue;
                modules.put(compat, compat.getModule());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void init() {
        ModulesHandler.smeltingRecipes();
        if (modules.isEmpty()) {
            return;
        }
        for (RecipesModule module : modules.values()) {
            module.init();
        }
    }

    public static void postInit() {
        if (modules.isEmpty()) {
            return;
        }
        for (RecipesModule module : modules.values()) {
            module.postInit();
        }
        RecipesModule.clearCache();
    }

    public static boolean isOreBlacklisted(CompatType type, String ore) {
        return modules.get((Object)type).blacklist().contains(ore.toLowerCase());
    }

    private static void smeltingRecipes() {
        for (Ore ore : Ore.ores) {
            if (!ore.isEnabled()) continue;
            ModulesHandler.registerSmelting(ore.name());
        }
    }

    private static void registerSmelting(String name) {
        try {
            GameRegistry.addSmelting((ItemStack)RecipesModule.getOreStack("dust" + name), (ItemStack)RecipesModule.getOreStack("ingot" + name), (float)0.2f);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

