/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.events;

import com.mia.craftstudio.minecraft.client.CSClientModelWrapperVBO;
import com.mia.props.DecoModelMetadata;
import com.mia.props.Props;
import com.mia.props.client.container.GuiDecobench;
import com.mia.props.common.ItemProps;
import com.mia.props.common.entities.TileDecobench;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.oredict.OreDictionary;

public enum ClientEventHandler {
    INSTANCE;

    private int playerOrientation;
    private boolean canPlace;
    private CSClientModelWrapperVBO model = null;
    private int tx;
    private int ty;
    private int tz;
    private int tick = 0;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        block10: {
            if (event.itemStack.func_77973_b().equals(Props.itemProps) && event.itemStack.func_77942_o() && event.itemStack.func_77978_p().func_74764_b("savedProp")) {
                event.toolTip.add(EnumChatFormatting.RESET + "" + EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"text.props.tooltip.saved_item"));
            }
            if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiDecobench)) break block10;
            if (((GuiDecobench)Minecraft.func_71410_x().field_71462_r).isMouseOverButtonScrollArea()) {
                if (GuiScreen.func_146272_n()) {
                    int[] resources = TileDecobench.resourcesProvidedByStack(event.itemStack);
                    for (int i = 0; i < resources.length; ++i) {
                        if (resources[i] == 0) continue;
                        event.toolTip.add(EnumChatFormatting.RESET + "" + EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)("text.props.tooltip.resource_cost." + i)) + EnumChatFormatting.YELLOW + " " + resources[i]);
                    }
                } else {
                    event.toolTip.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"text.props.gui.info"));
                }
            } else {
                for (ItemStack allowedStack : Props.allowableResourceItems) {
                    if (!OreDictionary.itemMatches((ItemStack)allowedStack, (ItemStack)event.itemStack, (boolean)false)) continue;
                    if (GuiScreen.func_146272_n()) {
                        int[] resources = TileDecobench.resourcesProvidedByStack(event.itemStack);
                        for (int i = 0; i < resources.length; ++i) {
                            if (resources[i] == 0) continue;
                            event.toolTip.add(EnumChatFormatting.RESET + "" + EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)("text.props.tooltip.resources_provided." + i)) + EnumChatFormatting.YELLOW + " " + resources[i]);
                        }
                    } else {
                        event.toolTip.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"text.props.gui.info"));
                    }
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.tick++ % 4 == 0) {
            this.model = null;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            if (currentItem == null) {
                return;
            }
            if (!(currentItem.func_77973_b() instanceof ItemProps)) {
                return;
            }
            MovingObjectPosition target = Minecraft.func_71410_x().field_71476_x;
            if (target == null) {
                return;
            }
            if (target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return;
            }
            int meta = currentItem.func_77960_j();
            DecoModelMetadata data = Props.modelData.get(meta);
            this.playerOrientation = 0;
            if (!data.limitRotation) {
                this.playerOrientation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            } else {
                int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                this.playerOrientation = direction * 4;
            }
            ForgeDirection fg = ForgeDirection.VALID_DIRECTIONS[target.field_72310_e];
            this.tx = target.field_72311_b + fg.offsetX;
            this.ty = target.field_72312_c + fg.offsetY;
            this.tz = target.field_72309_d + fg.offsetZ;
            this.canPlace = ItemProps.canPlace(data.wrapper, player.field_70170_p, this.tx, this.ty, this.tz, (EntityPlayer)player, this.playerOrientation);
            this.model = (CSClientModelWrapperVBO)Props.modelData.get((Object)Integer.valueOf((int)meta)).wrapper;
        }
    }

    @SubscribeEvent
    public void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        if (this.model != null) {
            this.model.renderPlacement(event.player, event.partialTicks, this.canPlace, this.tx, this.ty, this.tz, this.playerOrientation);
        }
    }
}

