/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.client.container.guilib;

import com.mia.props.client.container.guilib.GuiElement;
import com.mia.props.client.container.guilib.IExposedGui;
import com.mia.props.client.container.guilib.IGuiRenderable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;

public class GuiTextBox
extends GuiElement
implements IGuiRenderable {
    public boolean isSelected = false;
    protected int cursorPosition = 0;
    public String text = "";
    private final String emptyText;
    private final int emptyColor;
    private int color;

    public GuiTextBox(IExposedGui<? extends Gui> parent, int x, int y, int width, int height, String defaultText, int defaultColor, int color) {
        super(parent, x, y, width, height);
        this.emptyText = defaultText;
        this.emptyColor = defaultColor;
        this.color = color;
    }

    public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
        Keyboard.enableRepeatEvents((boolean)false);
        this.isSelected = false;
        if (this.mouseOver(mouseX, mouseY)) {
            this.isSelected = true;
            Keyboard.enableRepeatEvents((boolean)true);
            if (mouseButton == 1 && this.text.length() > 0) {
                this.clear();
            }
            return true;
        }
        return false;
    }

    public boolean canAddChar(char c) {
        return this.parent.getFontRenderer().func_78256_a(this.text + "w" + c) <= this.width_element;
    }

    public boolean keyPressed(int key, char keyChar) {
        if (this.isSelected) {
            if (key == 14) {
                if (this.text.length() > 0 && this.cursorPosition > 0) {
                    if (GuiScreen.func_146271_m()) {
                        this.text = this.text.substring(this.cursorPosition);
                        this.cursorPosition = 0;
                    } else {
                        String part1 = this.text.substring(0, this.cursorPosition);
                        String part2 = this.text.substring(this.cursorPosition);
                        this.text = part1.substring(0, part1.length() - 1) + part2;
                        --this.cursorPosition;
                    }
                }
            } else if (key == 211) {
                if (this.text.length() > 0 && this.cursorPosition < this.text.length()) {
                    if (GuiScreen.func_146271_m()) {
                        this.text = this.text.substring(0, this.cursorPosition);
                    } else {
                        String part1 = this.text.substring(0, this.cursorPosition);
                        String part2 = this.text.substring(this.cursorPosition + 1);
                        this.text = part1 + part2;
                    }
                }
            } else if (key == 1 || key == 28 || key == 15) {
                this.isSelected = false;
            } else if (key == 203) {
                if (this.cursorPosition > 0) {
                    --this.cursorPosition;
                }
            } else if (key == 205) {
                if (this.cursorPosition < this.text.length()) {
                    ++this.cursorPosition;
                }
            } else if (key == 199) {
                this.cursorPosition = 0;
            } else if (key == 207) {
                this.cursorPosition = this.text.length();
            } else if (ChatAllowedCharacters.func_71566_a((char)keyChar) && this.canAddChar(keyChar)) {
                String part1 = this.text.substring(0, this.cursorPosition);
                String part2 = this.text.substring(this.cursorPosition);
                this.text = part1 + keyChar + part2;
                ++this.cursorPosition;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.text = "";
        this.cursorPosition = 0;
    }

    public String getText() {
        if (this.text == null) {
            this.text = "";
        }
        return this.text;
    }

    @Override
    public void render(int mouseX, int mouseY) {
        String s;
        String string = s = "".equals(this.getText()) ? this.emptyText : this.getText();
        if (this.isSelected && Minecraft.func_71386_F() % 1000L > 500L) {
            String part1 = this.text.substring(0, this.cursorPosition);
            String part2 = this.text.substring(this.cursorPosition);
            s = part1 + '|' + part2;
        }
        if (s.length() > 0) {
            if ("".equals(this.getText())) {
                this.parent.getFontRenderer().func_78276_b(s, this.posX() + 1, this.posY() + 1, this.emptyColor);
            } else {
                this.parent.getFontRenderer().func_78261_a(s, this.posX() + 1, this.posY() + 1, this.color);
            }
        }
    }
}

