/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.gui.BeefGuiControlBase;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class BeefGuiInsertionProgressBar
extends BeefGuiControlBase
implements IBeefTooltipControl {
    public static final int controlWidth = 20;
    public static final int controlHeight = 64;
    protected ResourceLocation controlResource;
    private double backgroundLeftU = 0.0;
    private double backgroundRightU = 0.5;
    private double rodLeftU = 0.51;
    private double rodRightU = 1.0;
    protected float barAbsoluteMaxHeight;
    protected float insertion = 0.0f;
    protected String[] tooltip = new String[]{EnumChatFormatting.AQUA + "Control Rod", "", "Insertion: XX%"};

    public BeefGuiInsertionProgressBar(BeefGuiBase container, int x, int y) {
        super(container, x, y, 20, 64);
        this.controlResource = new ResourceLocation("bigreactors:textures/gui/" + this.getBackgroundTexture());
        this.barAbsoluteMaxHeight = this.height - 1;
    }

    public void setInsertion(float insertion) {
        this.insertion = Math.min(1.0f, Math.max(0.0f, insertion));
    }

    protected String getBackgroundTexture() {
        return "controls/ControlRod.png";
    }

    @Override
    public void drawBackground(TextureManager renderEngine, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderEngine.func_110577_a(this.controlResource);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)this.absoluteX, (double)(this.absoluteY + this.height), 0.0, this.backgroundLeftU, 1.0);
        tessellator.func_78374_a((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height), 0.0, this.backgroundRightU, 1.0);
        tessellator.func_78374_a((double)(this.absoluteX + this.width), (double)this.absoluteY, 0.0, this.backgroundRightU, 0.0);
        tessellator.func_78374_a((double)this.absoluteX, (double)this.absoluteY, 0.0, this.backgroundLeftU, 0.0);
        tessellator.func_78381_a();
        if (this.insertion > 0.0f) {
            int barHeight = Math.max(1, (int)Math.floor(this.insertion * this.barAbsoluteMaxHeight));
            int rodMaxY = this.absoluteY + barHeight;
            float rodTopV = 1.0f - this.insertion;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)this.absoluteX, (double)rodMaxY, 2.0, this.rodLeftU, 1.0);
            tessellator.func_78374_a((double)(this.absoluteX + this.width), (double)rodMaxY, 2.0, this.rodRightU, 1.0);
            tessellator.func_78374_a((double)(this.absoluteX + this.width), (double)this.absoluteY, 2.0, this.rodRightU, (double)rodTopV);
            tessellator.func_78374_a((double)this.absoluteX, (double)this.absoluteY, 2.0, this.rodLeftU, (double)rodTopV);
            tessellator.func_78381_a();
        }
    }

    @Override
    public void drawForeground(TextureManager renderEngine, int mouseX, int mouseY) {
    }

    @Override
    public String[] getTooltip() {
        this.tooltip[2] = String.format("Insertion: %.0f%%", Float.valueOf(this.insertion * 100.0f));
        return this.tooltip;
    }
}

