/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.block;

import cofh.api.tileentity.IReconfigurableFacing;
import cofh.core.block.BlockCoFHBase;
import cofh.core.util.CoreUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.common.BRLoader;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.interfaces.IBeefReconfigurableSides;
import erogenousbeef.bigreactors.common.interfaces.IWrenchable;
import erogenousbeef.bigreactors.common.tileentity.TileEntityCyaniteReprocessor;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityBeefBase;
import erogenousbeef.bigreactors.utils.StaticUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockBRDevice
extends BlockCoFHBase {
    public static final int META_CYANITE_REPROCESSOR = 0;
    public static final String[] _subBlocks = new String[]{"cyaniteReprocessor"};
    private IIcon[] _icons = new IIcon[_subBlocks.length];
    private IIcon[] _activeIcons = new IIcon[_subBlocks.length];
    public static final int SIDE_FRONT = ForgeDirection.NORTH.ordinal();

    public BlockBRDevice(Material material) {
        super(material);
        this.func_149672_a(field_149777_j);
        this.func_149711_c(1.0f);
        this.func_149663_c("blockBRDevice");
        this.func_149658_d("bigreactors:blockBRDevice");
        this.func_149647_a(BigReactors.TAB);
    }

    private IIcon safeGetIcon(IIcon[] list, int idx, int x, int y, int z) {
        if (idx < 0 || idx >= list.length) {
            BRLog.warning("Invalid metadata (%d) for block at %d, %d, %d!", idx, x, y, z);
            return this.field_149761_L;
        }
        return list[idx];
    }

    public IIcon getIconFromTileEntity(TileEntity te, int metadata, int side) {
        if (metadata < 0) {
            return this.field_149761_L;
        }
        int front = -1;
        if (te instanceof IReconfigurableFacing) {
            IReconfigurableFacing teFacing = (IReconfigurableFacing)te;
            front = teFacing.getFacing();
        }
        if (side == front) {
            TileEntityBeefBase beefTe;
            if (te instanceof TileEntityBeefBase && (beefTe = (TileEntityBeefBase)te).isActive()) {
                return this.safeGetIcon(this._activeIcons, metadata, te.field_145851_c, te.field_145848_d, te.field_145849_e);
            }
            return this.safeGetIcon(this._icons, metadata, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
        if (te instanceof IBeefReconfigurableSides) {
            IBeefReconfigurableSides teSides = (IBeefReconfigurableSides)te;
            return teSides.getIconForSide(side);
        }
        return this.field_149761_L;
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        int metadata = blockAccess.func_72805_g(x, y, z);
        return this.getIconFromTileEntity(te, metadata, side);
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == 4) {
            return this._icons[metadata];
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("bigreactors:" + this.func_149739_a());
        for (int i = 0; i < _subBlocks.length; ++i) {
            this._icons[i] = par1IconRegister.func_94245_a("bigreactors:" + this.func_149739_a() + "." + _subBlocks[i]);
            this._activeIcons[i] = par1IconRegister.func_94245_a("bigreactors:" + this.func_149739_a() + "." + _subBlocks[i] + ".active");
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileEntityCyaniteReprocessor();
            }
        }
        throw new IllegalArgumentException("Unknown metadata for tile entity");
    }

    public ItemStack getCyaniteReprocessorItemStack() {
        return new ItemStack((Block)this, 1, 0);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getCyaniteReprocessorItemStack());
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return false;
        }
        if (entityPlayer.func_70093_af()) {
            if (StaticUtils.Inventory.isPlayerHoldingWrench(entityPlayer)) {
                this.dismantleBlock(entityPlayer, null, world, x, y, z, false, world.field_72995_K);
                return true;
            }
            return false;
        }
        if (te instanceof IWrenchable && StaticUtils.Inventory.isPlayerHoldingWrench(entityPlayer)) {
            return ((IWrenchable)te).onWrench(entityPlayer, side);
        }
        if (te instanceof IFluidHandler) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)entityPlayer.field_71071_by.func_70448_g())) {
                FluidTankInfo[] infoz;
                IFluidHandler fluidHandler = (IFluidHandler)te;
                for (FluidTankInfo info : infoz = fluidHandler.getTankInfo(ForgeDirection.UNKNOWN)) {
                    if (!StaticUtils.Fluids.fillContainerFromTank(world, fluidHandler, entityPlayer, info.fluid)) continue;
                    return true;
                }
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)entityPlayer.field_71071_by.func_70448_g()) && StaticUtils.Fluids.fillTankWithContainer(world, (IFluidHandler)te, entityPlayer)) {
                return true;
            }
        }
        if (te instanceof TileEntityBeefBase) {
            if (!world.field_72995_K) {
                entityPlayer.openGui((Object)BRLoader.instance, 0, world, x, y, z);
            }
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, NBTTagCompound blockTag, World world, int x, int y, int z, boolean returnDrops, boolean simulate) {
        TileEntity te;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int metadata = world.func_72805_g(x, y, z);
        stacks.add(new ItemStack(this.func_149650_a(metadata, world.field_73012_v, 0), 1, this.func_149692_a(metadata)));
        if (returnDrops && !simulate && (te = world.func_147438_o(x, y, z)) instanceof IInventory) {
            IInventory invTe = (IInventory)te;
            for (int i = 0; i < invTe.func_70302_i_(); ++i) {
                ItemStack stack = invTe.func_70301_a(i);
                if (stack == null) continue;
                stacks.add(stack);
                invTe.func_70299_a(i, null);
            }
        }
        if (!simulate) {
            world.func_147468_f(x, y, z);
            if (!returnDrops) {
                for (ItemStack stack : stacks) {
                    CoreUtils.dropItemStackIntoWorldWithVelocity((ItemStack)stack, (World)world, (double)x, (double)y, (double)z);
                }
            }
        }
        return stacks;
    }

    public boolean initialize() {
        return false;
    }

    public boolean postInit() {
        return false;
    }
}

