/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.wires;

import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.common.Loader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import unwrittenfun.minecraft.immersiveintegration.blocks.IIBlocks;
import unwrittenfun.minecraft.immersiveintegration.compat.CCCompat;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileRedstoneWireConnector;

public class RedstoneWireNetwork {
    public byte[] channelValues = new byte[16];
    public List<WeakReference<TileRedstoneWireConnector>> connectors = new ArrayList<WeakReference<TileRedstoneWireConnector>>();

    public RedstoneWireNetwork add(TileRedstoneWireConnector connector) {
        this.connectors.add(new WeakReference<TileRedstoneWireConnector>(connector));
        return this;
    }

    public void mergeNetwork(RedstoneWireNetwork wireNetwork) {
        TileRedstoneWireConnector connector;
        for (WeakReference<TileRedstoneWireConnector> connectorRef : wireNetwork.connectors) {
            connector = (TileRedstoneWireConnector)connectorRef.get();
            if (connector == null) continue;
            connector.wireNetwork = this.add(connector);
        }
        for (WeakReference<TileRedstoneWireConnector> connectorRef : wireNetwork.connectors) {
            connector = (TileRedstoneWireConnector)connectorRef.get();
            if (connector == null) continue;
            this.notifyOfChange(connector.func_145831_w(), connector.field_145851_c, connector.field_145848_d, connector.field_145849_e);
        }
    }

    public void removeFromNetwork(TileRedstoneWireConnector removedConnector) {
        TileRedstoneWireConnector connector;
        ChunkCoordinates removedCC = Utils.toCC((Object)removedConnector);
        for (WeakReference<TileRedstoneWireConnector> connectorRef : this.connectors) {
            connector = (TileRedstoneWireConnector)connectorRef.get();
            if (connector == null) continue;
            connector.wireNetwork = new RedstoneWireNetwork().add(connector);
        }
        for (WeakReference<TileRedstoneWireConnector> connectorRef : this.connectors) {
            connector = (TileRedstoneWireConnector)connectorRef.get();
            if (connector == null) continue;
            ChunkCoordinates conCC = Utils.toCC((Object)connector);
            Set connections = ImmersiveNetHandler.INSTANCE.getConnections(connector.func_145831_w(), conCC);
            if (connections != null) {
                for (ImmersiveNetHandler.Connection connection : connections) {
                    TileEntity tileEntity;
                    ChunkCoordinates node = connection.start;
                    if (node.equals((Object)conCC)) {
                        node = connection.end;
                    }
                    if (node.equals((Object)removedCC) || !((tileEntity = connector.func_145831_w().func_147438_o(node.field_71574_a, node.field_71572_b, node.field_71573_c)) instanceof TileRedstoneWireConnector)) continue;
                    TileRedstoneWireConnector wireConnector = (TileRedstoneWireConnector)tileEntity;
                    if (connector.wireNetwork == wireConnector.wireNetwork) continue;
                    connector.wireNetwork.mergeNetwork(wireConnector.wireNetwork);
                }
            }
            if (connector.func_145837_r()) continue;
            this.notifyOfChange(connector.func_145831_w(), connector.field_145851_c, connector.field_145848_d, connector.field_145849_e);
        }
    }

    public void updateValues() {
        TileRedstoneWireConnector connector;
        byte[] oldValues = this.channelValues;
        this.channelValues = new byte[16];
        for (WeakReference<TileRedstoneWireConnector> connectorRef : this.connectors) {
            connector = (TileRedstoneWireConnector)connectorRef.get();
            if (connector == null || !connector.isInput()) continue;
            if (ProjectRedAPI.transmissionAPI != null) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    byte[] values = ProjectRedAPI.transmissionAPI.getBundledInput(connector.func_145831_w(), connector.field_145851_c, connector.field_145848_d, connector.field_145849_e, direction.getOpposite().ordinal());
                    if (values == null) continue;
                    for (int i = 0; i < values.length; ++i) {
                        this.channelValues[i] = (byte)Math.max((float)(values[i] & 0xFF) / 16.0f, (float)this.channelValues[i]);
                    }
                }
            }
            if (Loader.isModLoaded((String)"ComputerCraft")) {
                CCCompat.updateRedstoneValues(this, connector);
            }
            this.channelValues[connector.redstoneChannel] = (byte)Math.max(connector.func_145831_w().func_94572_D(connector.field_145851_c, connector.field_145848_d, connector.field_145849_e), this.channelValues[connector.redstoneChannel]);
        }
        if (!Arrays.equals(oldValues, this.channelValues)) {
            for (WeakReference<TileRedstoneWireConnector> connectorRef : this.connectors) {
                connector = (TileRedstoneWireConnector)connectorRef.get();
                if (connector == null) continue;
                this.notifyOfChange(connector.func_145831_w(), connector.field_145851_c, connector.field_145848_d, connector.field_145849_e);
            }
        }
    }

    public int getPowerOutput(int redstoneChannel) {
        return this.channelValues[redstoneChannel];
    }

    public void notifyOfChange(World world, int x, int y, int z) {
        world.func_147459_d(x, y, z, IIBlocks.redstoneWireConnector);
        ForgeDirection strongDirection = ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z));
        world.func_147459_d(x + strongDirection.offsetX, y + strongDirection.offsetY, z + strongDirection.offsetZ, IIBlocks.redstoneWireConnector);
    }

    public byte[] getByteValues() {
        byte[] values = new byte[16];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (byte)(this.channelValues[i] * 16);
        }
        return values;
    }
}

