/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.items;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.IWireCoil;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorLV;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import unwrittenfun.minecraft.immersiveintegration.ImmersiveIntegration;
import unwrittenfun.minecraft.immersiveintegration.tiles.IWireConnector;

public class ItemCoil
extends Item
implements IWireCoil {
    public String[] coilKeys;
    public WireType[] wireTypes;
    protected IIcon[] icons;
    protected String key;

    public ItemCoil(String key, String[] coilKeys, WireType ... wireTypes) {
        this.key = key;
        this.coilKeys = coilKeys;
        this.wireTypes = wireTypes;
        this.func_111206_d(key);
        this.func_77655_b(key);
        this.func_77627_a(true);
        this.func_77637_a(ImmersiveIntegration.iiCreativeTab);
    }

    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[this.coilKeys.length];
        for (int i = 0; i < this.coilKeys.length; ++i) {
            this.icons[i] = register.func_94245_a(this.key + this.coilKeys[i]);
        }
    }

    public IIcon func_77617_a(int meta) {
        meta = Math.min(meta, this.icons.length - 1);
        return this.icons[meta];
    }

    public String func_77667_c(ItemStack stack) {
        int meta = Math.min(stack.func_77960_j(), this.coilKeys.length - 1);
        return this.func_77658_a() + this.coilKeys[meta];
    }

    public void func_150895_a(Item item, CreativeTabs tab, List items) {
        for (int i = 0; i < this.coilKeys.length; ++i) {
            items.add(new ItemStack(item, 1, i));
        }
    }

    public WireType getWireType(ItemStack stack) {
        int meta = Math.min(stack.func_77960_j(), this.wireTypes.length - 1);
        return this.wireTypes[meta];
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        int[] link;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("linkingPos") && (link = stack.func_77978_p().func_74759_k("linkingPos")) != null && link.length > 3) {
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_147438_o(x, y, z) instanceof IImmersiveConnectable && ((IImmersiveConnectable)world.func_147438_o(x, y, z)).canConnect()) {
            TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
            if (!((IImmersiveConnectable)world.func_147438_o(x, y, z)).canConnectCable(this.getWireType(stack), target) || world.func_147438_o(x, y, z) instanceof TileEntityConnectorLV) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.wrongCable", new Object[0]));
                return false;
            }
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"linkingPos")) {
                ItemNBTHelper.setIntArray((ItemStack)stack, (String)"linkingPos", (int[])new int[]{world.field_73011_w.field_76574_g, x, y, z});
                target.writeToNBT(stack.func_77978_p());
            } else {
                WireType type = this.getWireType(stack);
                int[] pos = ItemNBTHelper.getIntArray((ItemStack)stack, (String)"linkingPos");
                int distance = (int)Math.ceil(Math.sqrt((pos[1] - x) * (pos[1] - x) + (pos[2] - y) * (pos[2] - y) + (pos[3] - z) * (pos[3] - z)));
                if (pos[0] != world.field_73011_w.field_76574_g) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.wrongDimension", new Object[0]));
                } else if (pos[1] == x && pos[2] == y && pos[3] == z) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.sameConnection", new Object[0]));
                } else if (distance > type.getMaxLength()) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.tooFar", new Object[0]));
                } else if (!(world.func_147438_o(x, y, z) instanceof IImmersiveConnectable) || !(world.func_147438_o(pos[1], pos[2], pos[3]) instanceof IImmersiveConnectable)) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.invalidPoint", new Object[0]));
                } else {
                    Set connections;
                    IImmersiveConnectable nodeHere = (IImmersiveConnectable)world.func_147438_o(x, y, z);
                    IImmersiveConnectable nodeLink = (IImmersiveConnectable)world.func_147438_o(pos[1], pos[2], pos[3]);
                    boolean connectionExists = false;
                    if (nodeHere != null && nodeLink != null && (connections = ImmersiveNetHandler.INSTANCE.getConnections(world, Utils.toCC((Object)nodeHere))) != null) {
                        for (ImmersiveNetHandler.Connection con : connections) {
                            if (!con.end.equals((Object)Utils.toCC((Object)nodeLink))) continue;
                            connectionExists = true;
                        }
                    }
                    if (connectionExists) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.connectionExists", new Object[0]));
                    } else {
                        Vec3 rtOff1;
                        Vec3 rtOff0 = nodeHere.getRaytraceOffset(nodeLink).func_72441_c((double)x, (double)y, (double)z);
                        boolean canSee = Utils.canBlocksSeeOther((World)world, (ChunkCoordinates)new ChunkCoordinates(x, y, z), (ChunkCoordinates)new ChunkCoordinates(pos[1], pos[2], pos[3]), (Vec3)rtOff0, (Vec3)(rtOff1 = nodeLink.getRaytraceOffset(nodeHere).func_72441_c((double)pos[1], (double)pos[2], (double)pos[3])));
                        if (canSee) {
                            TargetingInfo targetLink = TargetingInfo.readFromNBT((NBTTagCompound)stack.func_77978_p());
                            ImmersiveNetHandler.INSTANCE.addConnection(world, Utils.toCC((Object)nodeHere), Utils.toCC((Object)nodeLink), distance, type);
                            nodeHere.connectCable(type, target);
                            nodeLink.connectCable(type, targetLink);
                            IESaveData.setDirty((int)world.field_73011_w.field_76574_g);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                            ((TileEntity)nodeHere).func_70296_d();
                            world.func_147471_g(x, y, z);
                            ((TileEntity)nodeLink).func_70296_d();
                            world.func_147471_g(pos[1], pos[2], pos[3]);
                            TileEntity tileEntity = world.func_147438_o(x, y, z);
                            if (tileEntity instanceof IWireConnector) {
                                ((IWireConnector)tileEntity).connectTo(pos[1], pos[2], pos[3]);
                            }
                        } else {
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.cantSee", new Object[0]));
                        }
                    }
                }
                ItemNBTHelper.remove((ItemStack)stack, (String)"linkingPos");
                ItemNBTHelper.remove((ItemStack)stack, (String)"side");
                ItemNBTHelper.remove((ItemStack)stack, (String)"hitX");
                ItemNBTHelper.remove((ItemStack)stack, (String)"hitY");
                ItemNBTHelper.remove((ItemStack)stack, (String)"hitZ");
            }
            return true;
        }
        return false;
    }
}

