/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.compat;

import cpw.mods.fml.common.Loader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import unwrittenfun.minecraft.immersiveintegration.ImmersiveIntegration;
import unwrittenfun.minecraft.immersiveintegration.compat.CCCompat;
import unwrittenfun.minecraft.immersiveintegration.compat.FMPCompat;
import unwrittenfun.minecraft.immersiveintegration.compat.WailaCompat;

public abstract class CompatModule {
    private static HashSet<CompatModule> modules = new HashSet();

    public static void eventPreInit() {
        for (CompatModule module : modules) {
            if (!Loader.isModLoaded((String)module.getModId())) continue;
            module.preInit();
        }
    }

    public static void eventInit() {
        for (CompatModule module : modules) {
            if (!Loader.isModLoaded((String)module.getModId())) continue;
            module.init();
        }
    }

    public static void eventPostInit() {
        for (CompatModule module : modules) {
            if (!Loader.isModLoaded((String)module.getModId())) continue;
            module.postInit();
        }
    }

    public static void register(Class<? extends CompatModule> compatClass) {
        try {
            modules.add(compatClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            ImmersiveIntegration.log.error("Something went wrong loading a compat module.");
            e.printStackTrace();
        }
    }

    public abstract String getModId();

    public void preInit() {
    }

    public void init() {
    }

    public void postInit() {
    }

    static {
        CompatModule.register(CCCompat.class);
        CompatModule.register(WailaCompat.class);
        CompatModule.register(FMPCompat.class);
    }
}

