/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import cofh.core.render.hitbox.CustomHitBox;
import cofh.core.render.hitbox.ICustomHitBox;
import cofh.lib.util.position.BlockPosition;
import cofh.repack.codechicken.lib.raytracer.IndexedCuboid6;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicPoint;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.IRedNetConnection;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.IRedNetDecorative;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.IRedNetNoConnection;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;
import powercrystals.minefactoryreloaded.block.transport.BlockRedNetCable;
import powercrystals.minefactoryreloaded.core.IGridController;
import powercrystals.minefactoryreloaded.core.INode;
import powercrystals.minefactoryreloaded.core.ITraceable;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.item.tool.ItemRedNetMeter;
import powercrystals.minefactoryreloaded.net.Packets;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.tile.base.TileEntityBase;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneNetwork;

public class TileEntityRedNetCable
extends TileEntityBase
implements INode,
ITraceable,
ICustomHitBox {
    private static boolean isClient = FMLCommonHandler.instance().getSide() == Side.CLIENT;
    protected int[] _sideColors = new int[6];
    protected byte[] _cableMode = new byte[]{1, 1, 1, 1, 1, 1, 0};
    protected RedNetConnectionType[] _connectionState = new RedNetConnectionType[]{RedNetConnectionType.None, RedNetConnectionType.None, RedNetConnectionType.None, RedNetConnectionType.None, RedNetConnectionType.None, RedNetConnectionType.None};
    protected IRedNetLogicPoint[] _sideUpgrade = new IRedNetLogicPoint[]{null, null, null, null, null, null};
    RedstoneNetwork _network;
    @SideOnly(value=Side.CLIENT)
    private long[] __lastUpdates;
    @SideOnly(value=Side.CLIENT)
    private byte __updatePos;
    @SideOnly(value=Side.CLIENT)
    private boolean __useTESR;
    boolean isRSNode = false;
    private boolean dirty;
    private boolean readFromNBT;
    private static THashSet<Block> _connectionBlackList;

    public TileEntityRedNetCable() {
        if (_connectionBlackList == null) {
            THashSet tHashSet = new THashSet(256);
            for (String string : MFRConfig.redNetConnectionBlacklist.getStringList()) {
                if (!StringUtils.func_151246_b((String)string)) {
                    tHashSet.add((Object)Block.func_149684_b((String)string));
                    continue;
                }
                System.out.println("Empty or invalid rednet blacklist entry found. Not adding to rednet blacklist.");
            }
            List<Integer> list = Arrays.asList(23, 25, 27, 28, 29, 33, 46, 50, 55, 64, 69, 70, 71, 72, 75, 76, 77, 93, 94, 96, 107, 123, 124, 131, 137, 143, 147, 148, 149, 150, 151, 152, 154, 157, 158);
            int n = 176;
            while (n-- > 0) {
                if (list.contains(n)) continue;
                tHashSet.add((Object)Block.func_149729_e((int)n));
            }
            _connectionBlackList = tHashSet;
        }
        if (isClient) {
            this.__lastUpdates = new long[10];
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        RedstoneNetwork.HANDLER.addConduitForTick(this);
    }

    @Override
    public void func_145843_s() {
        if (this._network != null) {
            this.removeFromGrid();
        }
        super.func_145843_s();
    }

    private void removeFromGrid() {
        this._network.removeConduit(this);
        this.markForRegen();
        this._network = null;
    }

    private void markForRegen() {
        int n = 0;
        int n2 = 6;
        while (n2-- > 0) {
            if (!this._connectionState[n2].isAllSubnets) continue;
            ++n;
        }
        if (n > 1) {
            this._network.regenerate();
        }
    }

    @Override
    public final boolean isNotValid() {
        return this.field_145846_f;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void onNeighborBlockChange() {
        RedstoneNetwork.HANDLER.addConduitForUpdate(this);
    }

    @Override
    public void onMatchedNeighborBlockChange() {
        RedstoneNetwork.HANDLER.addConduitForUpdate(this);
    }

    @Override
    public void cofh_validate() {
        super.cofh_validate();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this._network == null) {
            this.incorporateTiles();
            if (this._network == null) {
                this.setNetwork(new RedstoneNetwork(this));
            }
        }
        this.readFromNBT = true;
        RedstoneNetwork.HANDLER.addConduitForUpdate(this);
        this.func_70296_d();
        Packets.sendToAllPlayersWatching(this);
    }

    private void incorporateTiles() {
        if (this._network == null) {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                TileEntityRedNetCable tileEntityRedNetCable;
                if (this.readFromNBT && (this._cableMode[forgeDirection.ordinal()] & 1) == 0 || !BlockPosition.blockExists((TileEntity)this, (ForgeDirection)forgeDirection) || (tileEntityRedNetCable = (TileEntityRedNetCable)BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)forgeDirection, TileEntityRedNetCable.class)) == null) continue;
                boolean bl = tileEntityRedNetCable.canInterface(this, forgeDirection.getOpposite());
                if (bl && tileEntityRedNetCable._network != null) {
                    tileEntityRedNetCable._network.addConduit(this);
                }
                if (bl) continue;
                int n = forgeDirection.ordinal();
                this._cableMode[n] = (byte)(this._cableMode[n] & 0xFFFFFFFE);
            }
        }
    }

    public void setNetwork(RedstoneNetwork redstoneNetwork) {
        this._network = redstoneNetwork;
    }

    public RedstoneNetwork getNetwork() {
        return this._network;
    }

    @Override
    public void updateInternalTypes(IGridController iGridController) {
        if (iGridController != RedstoneNetwork.HANDLER) {
            return;
        }
        boolean bl = this.isRSNode;
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        this.dirty = false;
        for (ForgeDirection forgeDirection : forgeDirectionArray) {
            this.updateNearbyNode(forgeDirection);
        }
        this.isRSNode = false;
        int n = this._connectionState.length;
        while (n-- > 0) {
            ForgeDirection forgeDirection = forgeDirectionArray[n];
            int n2 = this.field_145851_c + forgeDirection.offsetX;
            int n3 = this.field_145848_d + forgeDirection.offsetY;
            int n4 = this.field_145849_e + forgeDirection.offsetZ;
            if (!this.field_145850_b.func_72899_e(n2, n3, n4) || this.field_145850_b.func_147439_a(n2, n3, n4).equals(MFRThings.rednetCableBlock)) continue;
            this.isRSNode |= this._connectionState[n].isConnected;
        }
        if (bl != this.isRSNode) {
            this._network.addConduit(this);
        }
        this.markChunkDirty();
        if (this.dirty) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void updateNearbyNode(ForgeDirection forgeDirection) {
        this.updateNearbyNode(this.getSideColor(forgeDirection), forgeDirection);
    }

    public void updateNearbyNode(int n, ForgeDirection forgeDirection) {
        BlockPosition blockPosition = new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e, forgeDirection);
        blockPosition.step(forgeDirection);
        this.updateNearbyNode(blockPosition, n);
    }

    private void updateNearbyNode(BlockPosition blockPosition, int n) {
        if (this._network == null) {
            return;
        }
        RedNetConnectionType redNetConnectionType = this.getConnectionState(blockPosition.orientation);
        if (!redNetConnectionType.isDecorative & redNetConnectionType.isConnected && !this.field_145850_b.func_147437_c(blockPosition.x, blockPosition.y, blockPosition.z)) {
            if (redNetConnectionType.isAllSubnets) {
                this._network.addOrUpdateNode(blockPosition);
            } else {
                this._network.addOrUpdateNode(blockPosition, n, redNetConnectionType.isPlate);
            }
        } else {
            this._network.removeNode(blockPosition);
        }
    }

    public int getWeakPower(ForgeDirection forgeDirection) {
        if (this._network == null) {
            return 0;
        }
        RedNetConnectionType redNetConnectionType = this._connectionState[forgeDirection.ordinal()];
        if (!redNetConnectionType.isConnected | !redNetConnectionType.isSingleSubnet) {
            return 0;
        }
        BlockPosition blockPosition = new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e, forgeDirection);
        blockPosition.step(forgeDirection);
        int n = this.getSideColor(forgeDirection);
        RedstoneNetwork.log("Asked for weak power at %s", blockPosition);
        if (this._network.isPowerProvider(n, blockPosition)) {
            RedstoneNetwork.log("\t- power provider for network %s, power 0", this._network.hashCode());
            return 0;
        }
        int n2 = Math.min(Math.max(this._network.getPowerLevelOutput(n), 0), 15);
        RedstoneNetwork.log("\t- got %s from network %s:%s", n2, this._network.hashCode(), n);
        return n2;
    }

    public int getStrongPower(ForgeDirection forgeDirection) {
        if (this._network == null) {
            return 0;
        }
        RedNetConnectionType redNetConnectionType = this._connectionState[forgeDirection.ordinal()];
        if (!redNetConnectionType.isConnected | !redNetConnectionType.isSingleSubnet) {
            return 0;
        }
        BlockPosition blockPosition = new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e, forgeDirection);
        blockPosition.step(forgeDirection);
        int n = this.getSideColor(blockPosition.orientation);
        RedstoneNetwork.log("Asked for strong power at %s", blockPosition);
        if (this._network.isPowerProvider(n, blockPosition)) {
            RedstoneNetwork.log("\t- power provider for network %s, power 0", this._network.hashCode());
            return 0;
        }
        boolean bl = blockPosition.getBlock(this.field_145850_b).shouldCheckWeakPower((IBlockAccess)this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirection.getOpposite().ordinal());
        if (bl && this._network.isWeakNode(blockPosition)) {
            RedstoneNetwork.log("\t- weak node for network %s, power 0", this._network.hashCode());
        } else if (redNetConnectionType.isCable) {
            int n2 = Math.min(Math.max(this._network.getPowerLevelOutput(n), 0), 15);
            RedstoneNetwork.log("\t- got %s from network %s:%s", n2, this._network.hashCode(), n);
            return n2;
        }
        return 0;
    }

    @Override
    public boolean onPartHit(EntityPlayer entityPlayer, int n, int n2) {
        this.markChunkDirty();
        return false;
    }

    @Override
    public void addTraceableCuboids(List<IndexedCuboid6> list, boolean bl, boolean bl2) {
        Vector3 vector3 = new Vector3((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        IndexedCuboid6 indexedCuboid6 = new IndexedCuboid6((Object)0, BlockRedNetCable.subSelection[0]);
        list.add(indexedCuboid6);
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        int n = forgeDirectionArray.length;
        while (n-- > 0) {
            int n2;
            RedNetConnectionType redNetConnectionType = this.getConnectionState(forgeDirectionArray[n], true);
            int n3 = n2 = 2 + n;
            if (redNetConnectionType.isConnected) {
                if (redNetConnectionType.isPlate) {
                    n2 += 6;
                } else if (redNetConnectionType.isCable && redNetConnectionType.isAllSubnets) {
                    n3 = 20 + n;
                    list.add((IndexedCuboid6)new IndexedCuboid6((Object)(bl2 ? n3 + 18 : 1), BlockRedNetCable.subSelection[n3]).add(vector3));
                    continue;
                }
                n3 = 20 + n;
                list.add((IndexedCuboid6)new IndexedCuboid6((Object)1, BlockRedNetCable.subSelection[n3]).add(vector3));
                list.add((IndexedCuboid6)new IndexedCuboid6((Object)n2, BlockRedNetCable.subSelection[n2]).add(vector3));
                n2 = n3 - 6;
                if (!redNetConnectionType.isSingleSubnet) continue;
                list.add((IndexedCuboid6)new IndexedCuboid6((Object)n2, BlockRedNetCable.subSelection[n2]).add(vector3));
                continue;
            }
            if (!(bl & bl2 & this._cableMode[6] != 1)) continue;
            redNetConnectionType = this.getConnectionState(forgeDirectionArray[n], false);
            if (!redNetConnectionType.isConnected) continue;
            if (redNetConnectionType.isAllSubnets & redNetConnectionType.isCable) {
                n3 += 18;
                n2 += 36;
            }
            list.add((IndexedCuboid6)new IndexedCuboid6((Object)n2, BlockRedNetCable.subSelection[n3]).add(vector3));
        }
        indexedCuboid6.add(vector3);
    }

    public boolean shouldRenderCustomHitBox(int n, EntityPlayer entityPlayer) {
        return n < 2;
    }

    public CustomHitBox getCustomHitBox(int n, EntityPlayer entityPlayer) {
        int n2;
        ArrayList<IndexedCuboid6> arrayList = new ArrayList<IndexedCuboid6>(7);
        this.addTraceableCuboids(arrayList, true, MFRUtil.isHoldingUsableTool(entityPlayer, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        IndexedCuboid6 indexedCuboid6 = (IndexedCuboid6)arrayList.get(0);
        indexedCuboid6.expand(0.003);
        Vector3 vector3 = indexedCuboid6.min;
        Vector3 vector32 = indexedCuboid6.max.sub(vector3);
        CustomHitBox customHitBox = new CustomHitBox(vector32.x, vector32.y, vector32.z, vector3.x, vector3.y, vector3.z);
        int n3 = arrayList.size();
        block8: for (n2 = 1; n2 < n3; ++n2) {
            indexedCuboid6 = (IndexedCuboid6)arrayList.get(n2);
            indexedCuboid6.sub(vector3);
            int n4 = (Integer)indexedCuboid6.data;
            if (this.shouldRenderCustomHitBox(n4, entityPlayer)) {
                if (indexedCuboid6.min.y < 0.0) {
                    customHitBox.sideLength[0] = Math.max(customHitBox.sideLength[0], -indexedCuboid6.min.y);
                }
                if (indexedCuboid6.min.z < 0.0) {
                    customHitBox.sideLength[2] = Math.max(customHitBox.sideLength[2], -indexedCuboid6.min.z);
                }
                if (indexedCuboid6.min.x < 0.0) {
                    customHitBox.sideLength[4] = Math.max(customHitBox.sideLength[4], -indexedCuboid6.min.x);
                }
                indexedCuboid6.sub(vector32);
                if (indexedCuboid6.max.y > 0.0) {
                    customHitBox.sideLength[1] = Math.max(customHitBox.sideLength[1], indexedCuboid6.max.y);
                }
                if (indexedCuboid6.max.z > 0.0) {
                    customHitBox.sideLength[3] = Math.max(customHitBox.sideLength[3], indexedCuboid6.max.z);
                }
                if (!(indexedCuboid6.max.x > 0.0)) continue;
                customHitBox.sideLength[5] = Math.max(customHitBox.sideLength[5], indexedCuboid6.max.x);
                continue;
            }
            switch (BlockRedNetCable._subSideMappings[n4]) {
                default: {
                    continue block8;
                }
                case 0: 
                case 7: {
                    if (!(indexedCuboid6.min.y < 0.0)) continue block8;
                    customHitBox.sideLength[0] = Math.min(customHitBox.sideLength[0], -indexedCuboid6.max.y);
                    continue block8;
                }
                case 1: 
                case 8: {
                    indexedCuboid6.sub(vector32);
                    if (!(indexedCuboid6.max.y > 0.0)) continue block8;
                    customHitBox.sideLength[1] = Math.min(customHitBox.sideLength[1], indexedCuboid6.min.y);
                    continue block8;
                }
                case 2: 
                case 9: {
                    if (!(indexedCuboid6.min.z < 0.0)) continue block8;
                    customHitBox.sideLength[2] = Math.min(customHitBox.sideLength[2], -indexedCuboid6.max.z);
                    continue block8;
                }
                case 3: 
                case 10: {
                    indexedCuboid6.sub(vector32);
                    if (!(indexedCuboid6.max.z > 0.0)) continue block8;
                    customHitBox.sideLength[3] = Math.min(customHitBox.sideLength[3], indexedCuboid6.min.z);
                    continue block8;
                }
                case 4: 
                case 11: {
                    if (!(indexedCuboid6.min.x < 0.0)) continue block8;
                    customHitBox.sideLength[4] = Math.min(customHitBox.sideLength[4], -indexedCuboid6.max.x);
                    continue block8;
                }
                case 5: 
                case 12: {
                    indexedCuboid6.sub(vector32);
                    if (!(indexedCuboid6.max.x > 0.0)) continue block8;
                    customHitBox.sideLength[5] = Math.min(customHitBox.sideLength[5], indexedCuboid6.min.x);
                }
            }
        }
        n2 = customHitBox.sideLength.length;
        while (n2-- > 0) {
            customHitBox.drawSide[n2] = customHitBox.sideLength[n2] > 0.0;
        }
        return customHitBox;
    }

    public boolean canInterface(TileEntityRedNetCable tileEntityRedNetCable, ForgeDirection forgeDirection) {
        if ((this._cableMode[forgeDirection.ordinal()] & 1) == 0) {
            return false;
        }
        return (tileEntityRedNetCable._cableMode[forgeDirection.getOpposite().ordinal()] & 1) != 0;
    }

    public String getRedNetInfo(ForgeDirection forgeDirection, EntityPlayer entityPlayer) {
        String string;
        if (forgeDirection != ForgeDirection.UNKNOWN) {
            string = "Side " + forgeDirection + " is " + ItemRedNetMeter._colorNames[this.getSideColor(forgeDirection)];
        } else {
            string = "Sides are: ";
            for (ForgeDirection forgeDirection2 : ForgeDirection.VALID_DIRECTIONS) {
                string = string + forgeDirection2 + ": " + ItemRedNetMeter._colorNames[this.getSideColor(forgeDirection2)] + "; ";
            }
        }
        return string;
    }

    @Override
    public void getTileInfo(List<IChatComponent> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean bl) {
        if (bl) {
            if (this._network != null) {
                list.add(this.text("Grid:" + this._network));
                list.add(this.text("Conduits: " + this._network.getConduitCount() + ", Nodes: " + this._network.getNodeCount()));
                String string = "[";
                for (int i = 0; i < 15; ++i) {
                    string = string + this._network.getPowerLevelOutput(i) + ",";
                }
                string = string + this._network.getPowerLevelOutput(15) + "]";
                list.add(this.text("Outputs: " + string));
            } else {
                list.add(this.text("Null Grid"));
            }
            list.add(this.text("ConnectionState: " + Arrays.toString((Object[])this._connectionState)));
            list.add(this.text("SideMode: " + Arrays.toString(this._cableMode)));
            list.add(this.text("Colors: " + Arrays.toString(this._sideColors)));
            list.add(this.text("Upgrades: " + Arrays.toString(this._sideUpgrade)));
            list.add(this.text("Node: " + this.isRSNode));
            return;
        }
        list.add(this.text(this.getRedNetInfo(forgeDirection, entityPlayer)));
    }

    public int getSideColorValue(ForgeDirection forgeDirection) {
        return MFRUtil.COLORS[this.getSideColor(forgeDirection) & 0xF] << 8 | 0xFF;
    }

    public boolean toggleSide(int n) {
        boolean bl = (this._cableMode[n] & 1) == 1;
        boolean bl2 = false;
        if (n != 6 && this._connectionState[n].isAllSubnets) {
            this.removeFromGrid();
            bl2 = true;
            RedstoneNetwork.HANDLER.addConduitForUpdate(this);
        }
        int n2 = n;
        this._cableMode[n2] = (byte)(this._cableMode[n2] ^ 1);
        if (bl2) {
            this.incorporateTiles();
            if (this._network == null) {
                this.setNetwork(new RedstoneNetwork(this));
            }
        }
        this.updateNearbyNode(ForgeDirection.getOrientation((int)n));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        MFRUtil.notifyNearbyBlocks(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        return bl;
    }

    public byte getMode(int n) {
        if (n == 6) {
            return this._cableMode[n];
        }
        return (byte)(this._cableMode[n] >> 1);
    }

    public void setMode(int n, byte by) {
        boolean bl;
        if (n != 6) {
            bl = by != this._cableMode[n] >> 1;
            this._cableMode[n] = (byte)(this._cableMode[n] & 1 | by << 1);
            this.updateNearbyNode(ForgeDirection.getOrientation((int)n));
        } else {
            bl = by != this._cableMode[n];
            this._cableMode[n] = by;
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                this.updateNearbyNode(forgeDirection);
            }
        }
        if (bl) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public RedNetConnectionType getCachedConnectionState(ForgeDirection forgeDirection) {
        return this._connectionState[forgeDirection.ordinal()];
    }

    public RedNetConnectionType getConnectionState(ForgeDirection forgeDirection) {
        RedNetConnectionType redNetConnectionType = this.getConnectionState(forgeDirection, true);
        this.dirty |= this._connectionState[forgeDirection.ordinal()] != redNetConnectionType;
        this._connectionState[forgeDirection.ordinal()] = redNetConnectionType;
        return redNetConnectionType;
    }

    protected RedNetConnectionType getConnectionState(ForgeDirection forgeDirection, boolean bl) {
        RedNetConnectionType redNetConnectionType;
        int n;
        int n2;
        int n3;
        int n4 = this._cableMode[forgeDirection.ordinal()];
        if (bl & (n4 & 1) == 0) {
            return RedNetConnectionType.None;
        }
        n4 >>>= 1;
        if (!bl) {
            n4 = 1;
        }
        if (this._cableMode[6] == 1) {
            n4 = 3;
        }
        if (!this.field_145850_b.func_72899_e(n3 = this.field_145851_c + forgeDirection.offsetX, n2 = this.field_145848_d + forgeDirection.offsetY, n = this.field_145849_e + forgeDirection.offsetZ)) {
            return RedNetConnectionType.None;
        }
        Block block = this.field_145850_b.func_147439_a(n3, n2, n);
        boolean bl2 = false;
        if (block == MFRThings.rednetCableBlock) {
            if (!bl || ((TileEntityRedNetCable)this.field_145850_b.func_147438_o(n3, n2, n)).canInterface(this, forgeDirection.getOpposite())) {
                return RedNetConnectionType.CableAll;
            }
            return RedNetConnectionType.None;
        }
        if (n4 == 3) {
            return RedNetConnectionType.None;
        }
        int n5 = -1;
        if (block instanceof IRedNetConnection) {
            redNetConnectionType = ((IRedNetConnection)block).getConnectionType(this.field_145850_b, n3, n2, n, forgeDirection.getOpposite());
            if (n4 == 0 && redNetConnectionType.isConnectionForced) {
                return RedNetConnectionType.None;
            }
            if (!redNetConnectionType.isDecorative) {
                return redNetConnectionType;
            }
            bl2 = true;
            n5 = redNetConnectionType.flags;
        } else if (block instanceof IRedNetNoConnection || block.isAir((IBlockAccess)this.field_145850_b, n3, n2, n)) {
            return RedNetConnectionType.None;
        }
        redNetConnectionType = n4 == 2 ? (block.isSideSolid((IBlockAccess)this.field_145850_b, n3, n2, n, forgeDirection.getOpposite()) ? RedNetConnectionType.ForcedCableSingle : RedNetConnectionType.ForcedPlateSingle) : (n4 == 1 ? RedNetConnectionType.ForcedPlateSingle : (!bl2 && (_connectionBlackList.contains((Object)block) || block instanceof IRedNetDecorative) ? RedNetConnectionType.None : (block.isSideSolid((IBlockAccess)this.field_145850_b, n3, n2, n, forgeDirection.getOpposite()) ? RedNetConnectionType.CableSingle : RedNetConnectionType.PlateSingle)));
        if (n5 > 0) {
            short s = redNetConnectionType.flags;
            s = (short)(s & 0xFFFFFFE7);
            s = (short)(s | n5);
            redNetConnectionType = RedNetConnectionType.fromFlags(s);
        }
        return redNetConnectionType;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74783_a("sideSubnets", this._sideColors);
        nBTTagCompound.func_74774_a("v", (byte)5);
        nBTTagCompound.func_74773_a("cableMode", this._cableMode);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._sideColors = nBTTagCompound.func_74759_k("sideSubnets");
        if (this._sideColors.length < 6) {
            this._sideColors = new int[6];
        }
        byte by = nBTTagCompound.func_74771_c("mode");
        this._cableMode = nBTTagCompound.func_74770_j("cableMode");
        if (this._cableMode.length < 6) {
            this._cableMode = new byte[]{0, 0, 0, 0, 0, 0, 0};
        }
        switch (nBTTagCompound.func_74771_c("v")) {
            case 0: {
                if (by == 2) {
                    by = 3;
                }
            }
            case 1: {
                this._cableMode = new byte[]{by, by, by, by, by, by, by};
            }
            case 2: {
                this._cableMode[6] = (byte)(this._cableMode[6] == 3 ? 1 : 0);
            }
            case 3: {
                int n = 6;
                while (n-- > 0) {
                    this._cableMode[n] = (byte)(this._cableMode[n] << 1 | 1);
                }
            }
            case 4: {
                this._cableMode[6] = (byte)(this._cableMode[6] > 0 ? 1 : 0);
                break;
            }
        }
        this.readFromNBT = true;
    }

    public void setSideColor(ForgeDirection forgeDirection, int n) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return;
        }
        this._sideColors[forgeDirection.ordinal()] = n;
        this.updateNearbyNode(forgeDirection);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getSideColor(ForgeDirection forgeDirection) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return 0;
        }
        return this._sideColors[forgeDirection.ordinal()];
    }

    public boolean isSolidOnSide(int n) {
        if (this._cableMode[6] == 1) {
            return false;
        }
        byte by = this._cableMode[n];
        int n2 = by >> 1;
        return (by & 1) == 1 & n2 != 3 & n2 != 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderInPass(int n) {
        return n == 0 ? this.__useTESR : false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onRender() {
        int n;
        long[] lArray = this.__lastUpdates;
        int n2 = n = lArray.length;
        byte by = this.__updatePos;
        lArray[by] = this.field_145850_b.func_82737_E();
        this.__updatePos = (byte)((by + 1) % n2);
        long l = 0L;
        while (n-- > 1) {
            l += lArray[(n + by + 1) % n2] - lArray[(n + by) % n2];
        }
        this.__useTESR = l <= (long)(30 * n2);
        return this.__useTESR;
    }

    public Packet func_145844_m() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74783_a("colors", this._sideColors);
        nBTTagCompound.func_74768_a("mode[0]", this._cableMode[0] & 0xFF | (this._cableMode[1] & 0xFF) << 8 | (this._cableMode[2] & 0xFF) << 16 | (this._cableMode[3] & 0xFF) << 24);
        nBTTagCompound.func_74768_a("mode[1]", this._cableMode[4] & 0xFF | (this._cableMode[5] & 0xFF) << 8 | (this._cableMode[6] & 0xFF) << 16);
        nBTTagCompound.func_74768_a("state[0]", this._connectionState[0].ordinal() | this._connectionState[1].ordinal() << 4 | this._connectionState[2].ordinal() << 8 | this._connectionState[3].ordinal() << 12 | this._connectionState[4].ordinal() << 16 | this._connectionState[5].ordinal() << 20);
        S35PacketUpdateTileEntity s35PacketUpdateTileEntity = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nBTTagCompound);
        return s35PacketUpdateTileEntity;
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity s35PacketUpdateTileEntity) {
        NBTTagCompound nBTTagCompound = s35PacketUpdateTileEntity.func_148857_g();
        switch (s35PacketUpdateTileEntity.func_148853_f()) {
            case 0: {
                this._sideColors = nBTTagCompound.func_74759_k("colors");
                int n = nBTTagCompound.func_74762_e("mode[0]");
                this._cableMode[0] = (byte)(n >> 0 & 0xFF);
                this._cableMode[1] = (byte)(n >> 8 & 0xFF);
                this._cableMode[2] = (byte)(n >> 16 & 0xFF);
                this._cableMode[3] = (byte)(n >> 24 & 0xFF);
                n = nBTTagCompound.func_74762_e("mode[1]");
                this._cableMode[4] = (byte)(n >> 0 & 0xFF);
                this._cableMode[5] = (byte)(n >> 8 & 0xFF);
                this._cableMode[6] = (byte)(n >> 16 & 0xFF);
                n = nBTTagCompound.func_74762_e("state[0]");
                this._connectionState[0] = RedNetConnectionType.values()[n >> 0 & 0xF];
                this._connectionState[1] = RedNetConnectionType.values()[n >> 4 & 0xF];
                this._connectionState[2] = RedNetConnectionType.values()[n >> 8 & 0xF];
                this._connectionState[3] = RedNetConnectionType.values()[n >> 12 & 0xF];
                this._connectionState[4] = RedNetConnectionType.values()[n >> 16 & 0xF];
                this._connectionState[5] = RedNetConnectionType.values()[n >> 20 & 0xF];
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void firstTick(IGridController iGridController) {
    }
}

