/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.FluidHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityWeather
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    protected int _canSeeSky = 0;
    protected boolean _canWeather = false;
    protected boolean _willSnow = false;
    protected boolean _openSky = false;
    protected BiomeGenBase _biome = null;

    public TileEntityWeather() {
        super(Machine.WeatherCollector);
        this.setManageSolids(true);
        this._tanks[0].setLock(FluidRegistry.WATER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    @Override
    public int getWorkMax() {
        return 50;
    }

    @Override
    public int getIdleTicksMax() {
        return 600;
    }

    @Override
    public boolean activateMachine() {
        if (this.field_145850_b.func_72912_H().func_76059_o()) {
            BiomeGenBase biomeGenBase = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
            if (!this._canWeather || this._biome != biomeGenBase) {
                this._biome = biomeGenBase;
                if (!biomeGenBase.func_76738_d() && !biomeGenBase.func_76746_c()) {
                    this._canWeather = false;
                    this.setIdleTicks(this.getIdleTicksMax());
                    return false;
                }
                this._canWeather = true;
                boolean bl = this._willSnow = biomeGenBase.func_150564_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) < 0.15f;
            }
            if (!this.canSeeSky()) {
                this.setIdleTicks(this.getIdleTicksMax());
                return false;
            }
            if (!this.incrementWorkDone()) {
                return false;
            }
            if (this.getWorkDone() >= this.getWorkMax()) {
                if (!this._willSnow) {
                    if (this._tanks[0].getSpace() >= 1000 && this._tanks[0].fill(FluidHelper.WATER, true) > 0) {
                        this.setWorkDone(0);
                        this.setIdleTicks(3);
                        return true;
                    }
                    this.setWorkDone(this.getWorkMax());
                    this.setIdleTicks(10);
                    return false;
                }
                this.doDrop(new ItemStack(Items.field_151126_ay, 3));
                this.setWorkDone(0);
                this.setIdleTicks(1);
            }
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.DOWN;
    }

    private boolean canSeeSky() {
        if (--this._canSeeSky > 0) {
            return this._openSky;
        }
        this._canSeeSky = 70;
        int n = BlockHelper.getHighestY((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145849_e);
        this._openSky = true;
        for (int i = this.field_145848_d + 1; i < n; ++i) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, i, this.field_145849_e);
            if (block.func_149668_a(this.field_145850_b, this.field_145851_c, i, this.field_145849_e) == null) continue;
            this._openSky = false;
            break;
        }
        return this._openSky;
    }

    public int func_70302_i_() {
        return 0;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public boolean allowBucketDrain(ItemStack itemStack) {
        return true;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }
}

