/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import cofh.core.util.fluid.FluidTankAdv;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiLiquidGenerator;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryGenerator;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryGenerator;

public abstract class TileEntityLiquidGenerator
extends TileEntityFactoryGenerator
implements ITankContainerBucketable {
    private int _liquidConsumedPerTick;
    private int _powerProducedPerConsumption;

    public TileEntityLiquidGenerator(Machine machine, int n, int n2) {
        this(machine, n, machine.getActivationEnergy() * n2, n2);
    }

    public TileEntityLiquidGenerator(Machine machine, int n, int n2, int n3) {
        super(machine, n3);
        this._powerProducedPerConsumption = n2;
        this._liquidConsumedPerTick = n;
    }

    @Override
    protected boolean consumeFuel() {
        FluidStack fluidStack = this.drain(ForgeDirection.UNKNOWN, this._liquidConsumedPerTick, false);
        if (fluidStack == null || fluidStack.amount != this._liquidConsumedPerTick) {
            return false;
        }
        this.drain(ForgeDirection.UNKNOWN, this._liquidConsumedPerTick, true);
        return true;
    }

    @Override
    protected boolean hasFuel() {
        return this._tanks[0].getFluidAmount() != 0;
    }

    @Override
    protected boolean canConsumeFuel(int n) {
        return n >= this._powerProducedPerConsumption;
    }

    @Override
    protected int produceEnergy() {
        return this._powerProducedPerConsumption;
    }

    protected abstract boolean isFluidFuel(FluidStack var1);

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    protected String getFluidName(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return null;
        }
        String string = fluidStack.getFluid().getName();
        if (string == null) {
            return null;
        }
        return string.trim().toLowerCase(Locale.US);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiLiquidGenerator((ContainerFactoryInventory)this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryGenerator getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryGenerator(this, inventoryPlayer);
    }

    @Override
    public String getGuiBackground() {
        return "fluidgenerator";
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null && this.isFluidFuel(fluidStack)) {
            for (FluidTankAdv fluidTankAdv : this.getTanks()) {
                if (fluidTankAdv.getFluidAmount() != 0 && !fluidStack.isFluidEqual(fluidTankAdv.getFluid())) continue;
                return fluidTankAdv.fill(fluidStack, bl);
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

