/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.forestry;

import cofh.asm.relauncher.Strippable;
import cofh.asm.relauncher.Substitutable;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.ReplacementBlock;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableTreeLeaves;
import powercrystals.minefactoryreloaded.modhelpers.EmptyReplacement;

public class ForestryLeaf
extends HarvestableTreeLeaves
implements IFactoryFruit,
IFactoryFertilizable {
    private ITreeRoot root = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
    private ReplacementBlock repl = EmptyReplacement.INSTANCE;
    protected Item _item;

    public ForestryLeaf(Block block) {
        super(block);
        this._item = Item.func_150898_a((Block)block);
    }

    @Override
    public boolean canBePicked(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof IFruitBearer) {
            IFruitBearer iFruitBearer = (IFruitBearer)tileEntity;
            return iFruitBearer.getRipeness() >= 0.99f;
        }
        return false;
    }

    @Override
    public boolean canFertilize(World world, int n, int n2, int n3, FertilizerType fertilizerType) {
        return !this.canBePicked(world, n, n2, n3);
    }

    @Override
    public boolean fertilize(World world, Random random, int n, int n2, int n3, FertilizerType fertilizerType) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof IFruitBearer) {
            IFruitBearer iFruitBearer = (IFruitBearer)tileEntity;
            iFruitBearer.addRipeness(1.0f);
            return true;
        }
        return false;
    }

    @Override
    public ReplacementBlock getReplacementBlock(World world, int n, int n2, int n3) {
        return this.repl;
    }

    @Override
    public void prePick(World world, int n, int n2, int n3) {
    }

    @Override
    public List<ItemStack> getDrops(World world, Random random, Map<String, Boolean> map, int n, int n2, int n3) {
        ITree iTree = this.getTree(world, n, n2, n3);
        if (iTree == null) {
            return null;
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        float f = 1.0f;
        if (map.get("silkTouch") == Boolean.TRUE) {
            ItemStack itemStack = new ItemStack(this._item);
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            iTree.writeToNBT(nBTTagCompound);
            itemStack.func_77982_d(nBTTagCompound);
            arrayList.add(itemStack);
        } else {
            boolean bl = iTree.getMate() != null;
            for (ITree iTree2 : ForestryLeaf.getSaplings(iTree, world, n, n2, n3, f)) {
                if (iTree2 == null) continue;
                if ((bl && !iTree2.isGeneticEqual((IIndividual)iTree) || random.nextInt(32) == 0) && random.nextBoolean()) {
                    arrayList.add(this.root.getMemberStack((IIndividual)iTree2, EnumGermlingType.POLLEN.ordinal()));
                }
                arrayList.add(this.root.getMemberStack((IIndividual)iTree2, EnumGermlingType.SAPLING.ordinal()));
            }
            this.getFruits(world, n, n2, n3, iTree, arrayList);
        }
        return arrayList;
    }

    @Substitutable(value={"mod:Forestry@[4.0,)"}, method="getSaplingsOld")
    private static ITree[] getSaplings(ITree iTree, World world, int n, int n2, int n3, float f) {
        return iTree.getSaplings(world, null, n, n2, n3, f);
    }

    @Strippable(value={""})
    private static ITree[] getSaplingsOld(ITree iTree, World world, int n, int n2, int n3, float f) {
        return iTree.getSaplings(world, n, n2, n3, f);
    }

    @Override
    public List<ItemStack> getDrops(World world, Random random, int n, int n2, int n3) {
        ITree iTree = this.getTree(world, n, n2, n3);
        if (iTree == null) {
            return null;
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        this.getFruits(world, n, n2, n3, iTree, arrayList);
        return arrayList;
    }

    private ITree getTree(World world, int n, int n2, int n3) {
        IIndividual iIndividual;
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof IPollinatable && (iIndividual = ((IPollinatable)tileEntity).getPollen()) instanceof ITree) {
            return (ITree)iIndividual;
        }
        return null;
    }

    private void getFruits(World world, int n, int n2, int n3, ITree iTree, ArrayList<ItemStack> arrayList) {
        IFruitBearer iFruitBearer;
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof IFruitBearer && (iFruitBearer = (IFruitBearer)tileEntity).hasFruit()) {
            arrayList.addAll(iFruitBearer.pickFruit(null));
        }
    }

    @Override
    public void postPick(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof IFruitBearer) {
            IFruitBearer iFruitBearer = (IFruitBearer)tileEntity;
            iFruitBearer.addRipeness(-iFruitBearer.getRipeness());
        }
    }
}

