/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import joptsimple.internal.Strings;
import openmods.utils.CachedFactory;
import openperipheral.adapter.IMethodDescription;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.IMethodMap;
import openperipheral.adapter.types.TypeHelper;
import openperipheral.api.adapter.Doc;
import openperipheral.api.adapter.IScriptType;

public class DocUtils {
    public static final String ARGS = "args";
    public static final String RETURN_TYPES = "returnTypes";
    public static final String DESCRIPTION = "description";
    public static final String SOURCE = "source";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final CachedFactory<Class<?>, String> DOC_TEXT_CACHE = new CachedFactory<Class<?>, String>(){

        protected String create(Class<?> key) {
            Doc doc = key.getAnnotation(Doc.class);
            return doc != null ? Joiner.on((char)'\n').join((Object[])doc.value()) : "";
        }
    };

    public static Map<String, Object> describe(IMethodDescription desc) {
        HashMap result = Maps.newHashMap();
        result.put(DESCRIPTION, desc.description());
        result.put(SOURCE, desc.source());
        result.put(RETURN_TYPES, desc.returnTypes().describe());
        ArrayList args = Lists.newArrayList();
        for (IMethodDescription.IArgumentDescription arg : desc.arguments()) {
            args.add(DocUtils.describeArgument(arg));
        }
        result.put(ARGS, args);
        return result;
    }

    private static Map<String, Object> describeArgument(IMethodDescription.IArgumentDescription arg) {
        HashMap result = Maps.newHashMap();
        result.put(TYPE, arg.type());
        result.put(NAME, arg.name());
        result.put(DESCRIPTION, arg.description());
        if (arg.nullable()) {
            result.put("nullable", true);
        }
        if (arg.optional()) {
            result.put("optional", true);
        }
        if (arg.variadic()) {
            result.put("vararg", true);
        }
        return result;
    }

    public static String doc(IMethodDescription desc) {
        return "function" + DocUtils.createDocString(desc);
    }

    public static String doc(String name, IMethodDescription desc) {
        return "function " + name + DocUtils.createDocString(desc);
    }

    private static String createDocString(IMethodDescription desc) {
        String argsAndResult;
        ArrayList args = Lists.newArrayList();
        for (IMethodDescription.IArgumentDescription arg : desc.arguments()) {
            args.add(arg.name() + ":" + DocUtils.decorate(arg.type().describe(), arg));
        }
        IScriptType returnTypes = desc.returnTypes();
        String argsJoined = Joiner.on((char)',').join((Iterable)args);
        if (TypeHelper.isVoid(returnTypes)) {
            argsAndResult = String.format("(%s)", argsJoined);
        } else {
            String ret = returnTypes.describe();
            argsAndResult = String.format("(%s):%s", argsJoined, ret);
        }
        return !Strings.isNullOrEmpty((String)desc.description()) ? argsAndResult + " -- " + desc.description() : argsAndResult;
    }

    private static String decorate(String id, IMethodDescription.IArgumentDescription arg) {
        if (arg.optional()) {
            return id + "?";
        }
        if (arg.variadic()) {
            return id + "...";
        }
        return id;
    }

    public static String signature(IMethodDescription desc) {
        ArrayList tmp = Lists.newArrayList();
        for (IMethodDescription.IArgumentDescription arg : desc.arguments()) {
            tmp.add(DocUtils.decorate(arg.name(), arg));
        }
        return "(" + Joiner.on((String)",").join((Iterable)tmp) + ")";
    }

    public static void listMethods(final StringBuilder builder, IMethodMap methods) {
        methods.visitMethods(new IMethodMap.IMethodVisitor(){

            @Override
            public void visit(String name, IMethodExecutor executor) {
                String methodDoc = DocUtils.doc(name, executor.description());
                builder.append(methodDoc);
                builder.append('\n');
            }
        });
    }

    public static String createPeripheralHelpText(Class<? extends Object> cls, String type, IMethodMap methods) {
        StringBuilder builder = new StringBuilder();
        builder.append("----OpenPeripheral doc----\n");
        builder.append("Peripheral type: ");
        builder.append(type);
        builder.append("\n\n");
        String docText = (String)DOC_TEXT_CACHE.getOrCreate(cls);
        if (!Strings.isNullOrEmpty((String)docText)) {
            builder.append(docText);
            builder.append("\n\n");
        }
        builder.append("---Methods---\n");
        DocUtils.listMethods(builder, methods);
        return builder.toString();
    }
}

