/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.cc.wrappers;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import java.util.Arrays;
import openmods.Log;
import openperipheral.adapter.AdapterLogicException;
import openperipheral.adapter.IMethodCall;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.IndexedMethodMap;
import openperipheral.api.adapter.GenerationFailedException;
import openperipheral.interfaces.cc.ModuleComputerCraft;
import openperipheral.interfaces.cc.SynchronousExecutor;
import org.apache.logging.log4j.Level;

public class LuaObjectWrapper {
    public static ILuaObject wrap(Object target) {
        Preconditions.checkNotNull((Object)target, (Object)"Can't wrap null");
        try {
            IndexedMethodMap methods = ModuleComputerCraft.OBJECT_METHODS_FACTORY.getAdaptedClass(target.getClass());
            return methods.isEmpty() ? null : new WrappedLuaObject(methods, target);
        }
        catch (Throwable t) {
            throw new GenerationFailedException(String.format("%s (%s)", target, target.getClass()), t);
        }
    }

    private static class WrappedLuaObject
    implements ILuaObject {
        private final IndexedMethodMap methods;
        private final Object target;

        private WrappedLuaObject(IndexedMethodMap methods, Object target) {
            this.methods = methods;
            this.target = target;
        }

        public String[] getMethodNames() {
            return this.methods.getMethodNames();
        }

        private Object[] call(int methodIndex, IMethodExecutor executor, ILuaContext context, Object[] arguments) throws LuaException, InterruptedException {
            try {
                IMethodCall call = executor.startCall(this.target);
                return ModuleComputerCraft.ENV.addObjectArgs(call, context).call(arguments);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (LuaException e) {
                throw e;
            }
            catch (Throwable e) {
                String methodName = this.methods.getMethodName(methodIndex);
                Log.log((Level)Level.DEBUG, (Throwable)e, (String)"Internal error during method %s(%d) execution on object %s, args: %s", (Object[])new Object[]{methodName, methodIndex, this.target.getClass(), Arrays.toString(arguments)});
                throw new LuaException(AdapterLogicException.getMessageForThrowable(e));
            }
        }

        public Object[] callMethod(final ILuaContext context, final int index, final Object[] arguments) throws LuaException, InterruptedException {
            final IMethodExecutor method = this.methods.getMethod(index);
            Preconditions.checkNotNull((Object)method, (String)"Invalid method index: %d", (Object[])new Object[]{index});
            if (method.isAsynchronous()) {
                return this.call(index, method, context, arguments);
            }
            Object[] result = SynchronousExecutor.executeInMainThread(context, new SynchronousExecutor.Task(){

                @Override
                public Object[] execute() throws LuaException, InterruptedException {
                    return WrappedLuaObject.this.call(index, method, context, arguments);
                }
            });
            return result;
        }
    }
}

