/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import openperipheral.adapter.types.IRange;

public class EnumeratedRange<T>
implements IRange {
    public final Set<T> values;

    public EnumeratedRange(Collection<T> values) {
        this.values = ImmutableSet.copyOf(values);
    }

    @Override
    public String describe() {
        ArrayList returns = Lists.newArrayList();
        for (T r : this.values) {
            returns.add(r.toString());
        }
        return "{" + Joiner.on((char)',').join((Iterable)returns) + "}";
    }

    public static <T> EnumeratedRange<T> create(Collection<T> values) {
        return new EnumeratedRange<T>(values);
    }

    public static <T> EnumeratedRange<T> create(T ... values) {
        return new EnumeratedRange<T>(Arrays.asList(values));
    }
}

