/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import openperipheral.adapter.method.Argument;
import openperipheral.adapter.method.NullableArgument;
import openperipheral.adapter.method.NullableVarArgument;
import openperipheral.adapter.method.OptionalArgument;
import openperipheral.adapter.method.VarArgument;
import openperipheral.adapter.types.TypeHelper;
import openperipheral.api.adapter.IScriptType;
import openperipheral.api.adapter.method.ArgType;

public class ArgumentBuilder {
    private boolean isVararg;
    private boolean isNullable;
    private boolean isOptional;

    public void setVararg(boolean isVararg) {
        this.isVararg = isVararg;
    }

    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public Argument build(String name, String description, ArgType luaType, TypeToken<?> javaType, int javaArgIndex) {
        IScriptType wrappedType = TypeHelper.interpretArgType(luaType, javaType.getType());
        if (this.isVararg) {
            if (this.isNullable) {
                return new NullableVarArgument(name, description, wrappedType, javaType, javaArgIndex);
            }
            return new VarArgument(name, description, wrappedType, javaType, javaArgIndex);
        }
        if (this.isOptional) {
            Preconditions.checkState((!this.isNullable ? 1 : 0) != 0, (String)"Conflicting annotations on argument '%s'", (Object[])new Object[]{name});
            return new OptionalArgument(name, description, wrappedType, javaType, javaArgIndex);
        }
        if (this.isNullable) {
            return new NullableArgument(name, description, wrappedType, javaType, javaArgIndex);
        }
        return new Argument(name, description, wrappedType, javaType, javaArgIndex);
    }
}

