/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class Slider
extends AbstractWidget<Slider> {
    private boolean dragging = false;
    private int dx;
    private int dy;
    private boolean horizontal = false;
    private int minimumKnobSize = 4;
    private Scrollable scrollable;

    public Slider(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public Scrollable getScrollable() {
        return this.scrollable;
    }

    public Slider setScrollable(Scrollable scrollable) {
        this.scrollable = scrollable;
        return this;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public boolean isVertical() {
        return !this.horizontal;
    }

    public Slider setMinimumKnobSize(int m) {
        this.minimumKnobSize = m;
        return this;
    }

    public Slider setHorizontal() {
        this.horizontal = true;
        return this;
    }

    public Slider setVertical() {
        this.horizontal = false;
        return this;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        super.draw(window, x, y);
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        RenderHelper.drawThickBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, 1, StyleConfig.colorSliderTopLeft, StyleConfig.colorSliderBottomRight, StyleConfig.colorSliderFiller);
        int divider = this.scrollable.getMaximum() - this.scrollable.getCountSelected();
        if (this.horizontal) {
            int size = this.calculateKnobSize(divider, this.bounds.width);
            int first = this.calculateKnobOffset(divider, size, this.bounds.width);
            if (this.dragging) {
                RenderHelper.drawBeveledBox(xx + 1 + first, yy + 2, xx + 1 + first + size - 1, yy + this.bounds.height - 4, StyleConfig.colorSliderKnobDraggingTopLeft, StyleConfig.colorSliderKnobDraggingBottomRight, StyleConfig.colorSliderKnobDraggingFiller);
            } else if (this.isHovering()) {
                RenderHelper.drawBeveledBox(xx + 1 + first, yy + 2, xx + 1 + first + size - 1, yy + this.bounds.height - 4, StyleConfig.colorSliderKnobHoveringTopLeft, StyleConfig.colorSliderKnobHoveringBottomRight, StyleConfig.colorSliderKnobHoveringFiller);
            } else {
                RenderHelper.drawBeveledBox(xx + 1 + first, yy + 2, xx + 1 + first + size - 1, yy + this.bounds.height - 4, StyleConfig.colorSliderKnobTopLeft, StyleConfig.colorSliderKnobBottomRight, StyleConfig.colorSliderKnobFiller);
            }
            if (size >= 8) {
                RenderHelper.drawVerticalLine(xx + 1 + first + size / 2 - 1, yy + 3, yy + this.bounds.height - 6, StyleConfig.colorSliderKnobMarkerLine);
                if (size >= 10) {
                    RenderHelper.drawVerticalLine(xx + 1 + first + size / 2 - 2 - 1, yy + 3, yy + this.bounds.height - 6, StyleConfig.colorSliderKnobMarkerLine);
                    RenderHelper.drawVerticalLine(xx + 1 + first + size / 2 + 2 - 1, yy + 3, yy + this.bounds.height - 6, StyleConfig.colorSliderKnobMarkerLine);
                }
            }
        } else {
            int size = this.calculateKnobSize(divider, this.bounds.height);
            int first = this.calculateKnobOffset(divider, size, this.bounds.height);
            if (this.dragging) {
                RenderHelper.drawBeveledBox(xx + 1, yy + 1 + first, xx + this.bounds.width - 2, yy + 1 + first + size - 1, StyleConfig.colorSliderKnobDraggingTopLeft, StyleConfig.colorSliderKnobDraggingBottomRight, StyleConfig.colorSliderKnobDraggingFiller);
            } else if (this.isHovering()) {
                RenderHelper.drawBeveledBox(xx + 1, yy + 1 + first, xx + this.bounds.width - 2, yy + 1 + first + size - 1, StyleConfig.colorSliderKnobHoveringTopLeft, StyleConfig.colorSliderKnobHoveringBottomRight, StyleConfig.colorSliderKnobHoveringFiller);
            } else {
                RenderHelper.drawBeveledBox(xx + 1, yy + 1 + first, xx + this.bounds.width - 2, yy + 1 + first + size - 1, StyleConfig.colorSliderKnobTopLeft, StyleConfig.colorSliderKnobBottomRight, StyleConfig.colorSliderKnobFiller);
            }
            if (size >= 8) {
                RenderHelper.drawHorizontalLine(xx + 3, yy + 1 + first + size / 2 - 1, xx + this.bounds.width - 4, StyleConfig.colorSliderKnobMarkerLine);
                if (size >= 10) {
                    RenderHelper.drawHorizontalLine(xx + 3, yy + 1 + first + size / 2 - 2 - 1, xx + this.bounds.width - 4, StyleConfig.colorSliderKnobMarkerLine);
                    RenderHelper.drawHorizontalLine(xx + 3, yy + 1 + first + size / 2 + 2 - 1, xx + this.bounds.width - 4, StyleConfig.colorSliderKnobMarkerLine);
                }
            }
        }
    }

    private int calculateKnobOffset(int divider, int size, int boundsSize) {
        int first = divider <= 0 ? 0 : this.scrollable.getFirstSelected() * (boundsSize - 2 - size) / divider;
        return first;
    }

    private int calculateKnobSize(int divider, int boundsSize) {
        int size = divider <= 0 ? boundsSize - 2 : this.scrollable.getCountSelected() * (boundsSize - 2) / this.scrollable.getMaximum();
        if (size < this.minimumKnobSize) {
            size = this.minimumKnobSize;
        }
        return size;
    }

    private void updateScrollable(int x, int y) {
        int first;
        int divider = this.scrollable.getMaximum() - this.scrollable.getCountSelected();
        if (divider <= 0) {
            first = 0;
        } else if (this.horizontal) {
            int size = this.calculateKnobSize(divider, this.bounds.width);
            first = (x - this.bounds.x - this.dx) * divider / (this.bounds.width - 4 - size);
        } else {
            int size = this.calculateKnobSize(divider, this.bounds.height);
            first = (y - this.bounds.y - this.dy) * divider / (this.bounds.height - 4 - size);
        }
        if (first > divider) {
            first = divider;
        }
        if (first < 0) {
            first = 0;
        }
        this.scrollable.setFirstSelected(first);
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        super.mouseClick(window, x, y, button);
        this.dragging = true;
        int divider = this.scrollable.getMaximum() - this.scrollable.getCountSelected();
        if (this.horizontal) {
            int size = this.calculateKnobSize(divider, this.bounds.width);
            int first = this.calculateKnobOffset(divider, size, this.bounds.width);
            this.dx = x - this.bounds.x - first;
            this.dy = 0;
        } else {
            int size = this.calculateKnobSize(divider, this.bounds.height);
            int first = this.calculateKnobOffset(divider, size, this.bounds.height);
            this.dx = 0;
            this.dy = y - this.bounds.y - first;
        }
        return this;
    }

    @Override
    public void mouseRelease(int x, int y, int button) {
        super.mouseRelease(x, y, button);
        if (this.dragging) {
            this.updateScrollable(x, y);
            this.dragging = false;
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        super.mouseMove(x, y);
        if (this.dragging) {
            this.updateScrollable(x, y);
        }
    }
}

