/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.base;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import mcjty.lib.base.StyleConfig;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class GeneralConfig {
    public static final String CATEGORY_GENERAL = "general";
    public static int maxInfuse = 256;
    private static File modConfigDir;
    private static Configuration mainConfig;
    public static boolean manageOwnership;

    public static void init(Configuration cfg) {
        manageOwnership = cfg.get(CATEGORY_GENERAL, "manageOwnership", manageOwnership, "If true then blocks using mcjtylib will have ownership tagged on them (useful for the rftools security manager)").getBoolean();
        maxInfuse = cfg.get(CATEGORY_GENERAL, "maxInfuse", maxInfuse, "The maximum amount of dimensional shards that can be infused in a single machine").getInt();
    }

    public static void preInit(FMLPreInitializationEvent e) {
        modConfigDir = e.getModConfigurationDirectory();
        mainConfig = new Configuration(new File(modConfigDir.getPath(), "mcjtylib.cfg"));
        try {
            mainConfig.load();
            mainConfig.addCustomCategoryComment(CATEGORY_GENERAL, "General settings for all mods using mcjtylib");
            mainConfig.addCustomCategoryComment("style", "Style settings for all mods using mcjtylib");
            GeneralConfig.init(mainConfig);
            StyleConfig.init(mainConfig);
        }
        catch (Exception e1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e1, (String)"Problem loading config file: mcjtylib.cfg!", (Object[])new Object[0]);
        }
        finally {
            if (mainConfig.hasChanged()) {
                mainConfig.save();
            }
        }
    }

    static {
        manageOwnership = true;
    }
}

