/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib.util;

public enum OS {
    WINDOWS,
    LINUX,
    OSX,
    OTHER;

    public static final OS current;
    public static final boolean is64;

    private static OS get() {
        String s = System.getProperty("os.name");
        if (s == null || s.isEmpty()) {
            return OTHER;
        }
        if ((s = s.toLowerCase()).contains("win")) {
            return WINDOWS;
        }
        if (s.contains("mac")) {
            return OSX;
        }
        if (s.contains("linux") || s.contains("unix")) {
            return LINUX;
        }
        return OTHER;
    }

    static {
        current = OS.get();
        is64 = System.getProperty("sun.arch.data.model").equals("64");
    }
}

