/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib.github;

import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import latmod.lib.github.GitHubAPI;
import latmod.lib.github.GitHubBranch;
import latmod.lib.util.FinalIDObject;

public class GitHubRepo
extends FinalIDObject {
    public final String owner;
    public final String repo;
    private Map<String, GitHubBranch> branches;

    public GitHubRepo(String u, String r) {
        super(u + '/' + r);
        this.owner = u;
        this.repo = r;
    }

    public Map<String, GitHubBranch> getBranches() throws Exception {
        if (this.branches == null) {
            LinkedHashMap<String, GitHubBranch> map = new LinkedHashMap<String, GitHubBranch>();
            for (JsonElement e : GitHubAPI.getAPI("repos/" + this.getID() + "/branches").getAsJsonArray()) {
                GitHubBranch b = new GitHubBranch(this, e.getAsJsonObject());
                map.put(b.getID(), b);
            }
            this.branches = Collections.unmodifiableMap(map);
        }
        return this.branches;
    }
}

