/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.mod.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.api.FTBLibLang;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.gui.GuiLM;
import ftb.lib.api.gui.LMGuis;
import ftb.lib.api.gui.callback.FieldSelected;
import ftb.lib.api.gui.callback.IFieldCallback;
import ftb.lib.api.gui.widgets.ButtonSimpleLM;
import ftb.lib.api.gui.widgets.TextBoxLM;

@SideOnly(value=Side.CLIENT)
public class GuiSelectField
extends GuiLM {
    public final Object ID;
    public final LMGuis.FieldType type;
    public final String def;
    public final IFieldCallback callback;
    public final ButtonSimpleLM buttonCancel;
    public final ButtonSimpleLM buttonAccept;
    public final TextBoxLM textBox;

    public GuiSelectField(Object id, LMGuis.FieldType typ, String d, IFieldCallback c) {
        super(null, null);
        this.ID = id;
        this.type = typ;
        this.def = d;
        this.callback = c;
        this.mainPanel.width = 100;
        this.mainPanel.height = 40;
        int bsize = this.mainPanel.width / 2 - 4;
        this.buttonCancel = new ButtonSimpleLM(this, 2, this.mainPanel.height - 18, bsize, 16){

            @Override
            public void onButtonPressed(int b) {
                FTBLibClient.playClickSound();
                GuiSelectField.this.callback.onFieldSelected(new FieldSelected(GuiSelectField.this.ID, false, GuiSelectField.this.def, true));
            }
        };
        this.buttonCancel.title = FTBLibLang.button_cancel.format(new Object[0]);
        this.buttonAccept = new ButtonSimpleLM(this, this.mainPanel.width - bsize - 2, this.mainPanel.height - 18, bsize, 16){

            @Override
            public void onButtonPressed(int b) {
                FTBLibClient.playClickSound();
                if (GuiSelectField.this.textBox.isValid()) {
                    GuiSelectField.this.callback.onFieldSelected(new FieldSelected(GuiSelectField.this.ID, true, GuiSelectField.this.textBox.getText(), true));
                }
            }
        };
        this.buttonAccept.title = FTBLibLang.button_accept.format(new Object[0]);
        this.textBox = new TextBoxLM(this, 2, 2, this.mainPanel.width - 4, 18){

            @Override
            public boolean isValid() {
                return GuiSelectField.this.type.isValid(this.getText());
            }

            @Override
            public void returnPressed() {
                GuiSelectField.this.buttonAccept.onButtonPressed(0);
            }
        };
        this.textBox.setText(this.def);
        this.textBox.textRenderX = -1;
        this.textBox.textRenderY = 6;
        this.textBox.textColor = -1118482;
    }

    public GuiSelectField setCharLimit(int i) {
        this.textBox.charLimit = i;
        return this;
    }

    @Override
    public void addWidgets() {
        this.mainPanel.add(this.buttonCancel);
        this.mainPanel.add(this.buttonAccept);
        this.mainPanel.add(this.textBox);
    }

    @Override
    public void drawBackground() {
        int size = 8 + this.getFontRenderer().func_78256_a(this.textBox.getText());
        if (size > this.mainPanel.width) {
            int bsize;
            this.mainPanel.width = size;
            this.buttonAccept.width = this.buttonCancel.width = (bsize = size / 2 - 4);
            this.buttonAccept.posX = this.mainPanel.width - bsize - 2;
            this.textBox.width = this.mainPanel.width - 4;
            this.func_73866_w_();
        }
        GlStateManager.color(0.4f, 0.4f, 0.4f, 0.66f);
        GuiSelectField.drawBlankRect(this.mainPanel.posX, this.mainPanel.posY, this.field_73735_i, this.mainPanel.width, this.mainPanel.height);
        GlStateManager.color(0.2f, 0.2f, 0.2f, 1.0f);
        GuiSelectField.drawBlankRect(this.textBox.getAX(), this.textBox.getAY(), this.field_73735_i, this.textBox.width, this.textBox.height);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.buttonAccept.renderWidget();
        this.buttonCancel.renderWidget();
        this.textBox.renderWidget();
    }
}

