/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.common.registry.GameRegistry;
import ftb.lib.api.item.LMInvUtils;
import latmod.lib.LMStringUtils;
import net.minecraft.item.ItemStack;

public class ItemStackSerializer {
    private static String getParseRegex(String s) {
        if (s.indexOf(32) != -1) {
            return " ";
        }
        if (s.indexOf(59) != -1) {
            return ";";
        }
        if (s.indexOf(64) != -1) {
            return "@";
        }
        return " x ";
    }

    public static ItemStack parseItem(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        String[] s1 = s.split(ItemStackSerializer.getParseRegex(s));
        if (s1.length <= 0) {
            return null;
        }
        String itemID = s1[0];
        int dmg = 0;
        int size = 1;
        String nbt = null;
        if (s1.length > 1) {
            size = Integer.parseInt(s1[1]);
        }
        if (s1.length > 2) {
            int n = dmg = s1[2].charAt(0) == '*' ? Short.MAX_VALUE : Integer.parseInt(s1[2]);
        }
        if (s1.length > 3) {
            nbt = LMStringUtils.unsplitSpaceUntilEnd(3, s1);
        }
        ItemStack newStack = GameRegistry.makeItemStack((String)itemID, (int)dmg, (int)size, (String)nbt);
        newStack.field_77994_a = size;
        return newStack;
    }

    public static String toString(ItemStack is) {
        if (is == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(LMInvUtils.getRegName(is));
        sb.append(' ');
        sb.append(is.field_77994_a);
        sb.append(' ');
        sb.append(is.func_77960_j());
        return sb.toString();
    }

    public static JsonElement serialize(ItemStack is) {
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        return new JsonPrimitive(ItemStackSerializer.toString(is));
    }

    public static ItemStack deserialize(JsonElement e) {
        if (e == null) {
            return null;
        }
        if (e.isJsonPrimitive()) {
            return ItemStackSerializer.parseItem(e.getAsString());
        }
        return null;
    }
}

