/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonElement;
import ftb.lib.api.config.ConfigGroup;
import java.io.File;
import latmod.lib.ByteIOStream;
import latmod.lib.LMFileUtils;
import latmod.lib.LMJsonUtils;
import latmod.lib.LMStringUtils;

public class ConfigFile
extends ConfigGroup {
    private File file;
    private String displayName;

    public ConfigFile(String id) {
        super(id);
    }

    @Override
    public ConfigFile getConfigFile() {
        return this;
    }

    public void setFile(File f) {
        this.file = LMFileUtils.newFile(f);
    }

    public File getFile() {
        return this.file;
    }

    public void setDisplayName(String s) {
        this.displayName = s == null || s.isEmpty() ? null : s;
    }

    public String getDisplayName() {
        return this.displayName == null ? LMStringUtils.firstUppercase(this.getID()) : this.displayName;
    }

    public void load() {
        JsonElement e = LMJsonUtils.fromJson(this.file);
        if (e.isJsonObject()) {
            ConfigGroup g = new ConfigGroup(this.getID());
            g.func_152753_a((JsonElement)e.getAsJsonObject());
            this.loadFromGroup(g);
        }
    }

    public void save() {
        if (this.file != null) {
            LMJsonUtils.toJson(this.file, this.func_151003_a());
        }
    }

    @Override
    public void writeExtended(ByteIOStream io) {
        super.writeExtended(io);
        io.writeUTF(this.displayName);
    }

    @Override
    public void readExtended(ByteIOStream io) {
        super.readExtended(io);
        this.displayName = io.readUTF();
    }

    public void addGroup(String id, Class<?> c) {
        this.add(new ConfigGroup(id).addAll(c, null, false), false);
    }
}

