/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.client.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.AxisAlignedBB;

@SideOnly(value=Side.CLIENT)
public final class CubeRenderer {
    public static final CubeRenderer instance = new CubeRenderer();
    private Tessellator tessellator;
    protected static final float[] normalsX = new float[]{0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f};
    protected static final float[] normalsY = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    protected static final float[] normalsZ = new float[]{0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f};
    public boolean hasTexture = true;
    public boolean isInterpolated = false;
    protected int currentFace = -1;
    protected double minX;
    protected double minY;
    protected double minZ;
    protected double maxX;
    protected double maxY;
    protected double maxZ;
    protected double minU;
    protected double minV;
    protected double maxU;
    protected double maxV;

    public CubeRenderer() {
        this.setTessellator(Tessellator.field_78398_a);
    }

    public void setTessellator(Tessellator t) {
        if (t == null) {
            return;
        }
        this.tessellator = t;
    }

    public void setSize(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.minX = x0;
        this.minY = y0;
        this.minZ = z0;
        this.maxX = x1;
        this.maxY = y1;
        this.maxZ = z1;
    }

    public void setSize(AxisAlignedBB aabb) {
        this.setSize(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public void setUV(double u0, double v0, double u1, double v1) {
        this.minU = u0;
        this.minV = v0;
        this.maxU = u1;
        this.maxV = v1;
    }

    public void renderAll() {
        this.renderDown();
        this.renderUp();
        this.renderSouth();
        this.renderNorth();
        this.renderWest();
        this.renderEast();
    }

    public void renderFace(int f) {
        if (f == 0) {
            this.renderDown();
        } else if (f == 1) {
            this.renderUp();
        } else if (f == 2) {
            this.renderSouth();
        } else if (f == 3) {
            this.renderNorth();
        } else if (f == 4) {
            this.renderWest();
        } else if (f == 5) {
            this.renderEast();
        }
    }

    private void begin(int f) {
        this.currentFace = f;
        this.tessellator.func_78382_b();
        this.tessellator.func_78375_b(normalsX[f], normalsY[f], normalsZ[f]);
    }

    private void end() {
        this.tessellator.func_78381_a();
        this.currentFace = -1;
    }

    private void vertex(double x, double y, double z, double u, double v) {
        if (this.hasTexture) {
            this.tessellator.func_78374_a(x, y, z, u, v);
        } else {
            this.tessellator.func_78377_a(x, y, z);
        }
    }

    public void renderDown() {
        this.begin(0);
        this.vertex(this.minX, this.minY, this.minZ, this.minU, this.minV);
        this.vertex(this.maxX, this.minY, this.minZ, this.maxU, this.minV);
        this.vertex(this.maxX, this.minY, this.maxZ, this.maxU, this.maxV);
        this.vertex(this.minX, this.minY, this.maxZ, this.minU, this.maxV);
        this.end();
    }

    public void renderUp() {
        this.begin(1);
        this.vertex(this.minX, this.maxY, this.minZ, this.minU, this.minV);
        this.vertex(this.minX, this.maxY, this.maxZ, this.minU, this.maxV);
        this.vertex(this.maxX, this.maxY, this.maxZ, this.maxU, this.maxV);
        this.vertex(this.maxX, this.maxY, this.minZ, this.maxU, this.minV);
        this.end();
    }

    public void renderSouth() {
        this.begin(2);
        this.vertex(this.minX, this.minY, this.maxZ, this.minU, this.maxV);
        this.vertex(this.maxX, this.minY, this.maxZ, this.maxU, this.maxV);
        this.vertex(this.maxX, this.maxY, this.maxZ, this.maxU, this.minV);
        this.vertex(this.minX, this.maxY, this.maxZ, this.minU, this.minV);
        this.end();
    }

    public void renderNorth() {
        this.begin(3);
        this.vertex(this.minX, this.minY, this.minZ, this.maxU, this.maxV);
        this.vertex(this.minX, this.maxY, this.minZ, this.maxU, this.minV);
        this.vertex(this.maxX, this.maxY, this.minZ, this.minU, this.minV);
        this.vertex(this.maxX, this.minY, this.minZ, this.minU, this.maxV);
        this.end();
    }

    public void renderWest() {
        this.begin(4);
        this.vertex(this.minX, this.minY, this.minZ, this.minU, this.maxV);
        this.vertex(this.minX, this.minY, this.maxZ, this.maxU, this.maxV);
        this.vertex(this.minX, this.maxY, this.maxZ, this.maxU, this.minV);
        this.vertex(this.minX, this.maxY, this.minZ, this.minU, this.minV);
        this.end();
    }

    public void renderEast() {
        this.begin(5);
        this.vertex(this.maxX, this.minY, this.minZ, this.maxU, this.maxV);
        this.vertex(this.maxX, this.maxY, this.minZ, this.maxU, this.minV);
        this.vertex(this.maxX, this.maxY, this.maxZ, this.minU, this.minV);
        this.vertex(this.maxX, this.minY, this.maxZ, this.minU, this.maxV);
        this.end();
    }
}

