/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import ftb.lib.FTBLib;
import ftb.lib.PrivacyLevel;
import ftb.lib.api.friends.ILMPlayer;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class LMSecurity {
    private int ownerID;
    public PrivacyLevel level;

    public LMSecurity(Object o) {
        this.setOwner(o);
        this.level = PrivacyLevel.PUBLIC;
    }

    public int getOwnerID() {
        return this.ownerID;
    }

    public ILMPlayer getOwner() {
        return FTBLib.ftbu == null ? null : FTBLib.ftbu.getLMPlayer(this.ownerID);
    }

    public void setOwner(Object o) {
        ILMPlayer p;
        this.ownerID = 0;
        if (o != null && FTBLib.ftbu != null && (p = FTBLib.ftbu.getLMPlayer(o)) != null) {
            this.ownerID = p.getPlayerID();
        }
    }

    public void readFromNBT(NBTTagCompound tag, String s) {
        if (tag.func_74764_b(s)) {
            NBTTagCompound tag1 = tag.func_74775_l(s);
            this.ownerID = tag1.func_74762_e("Owner");
            this.level = PrivacyLevel.VALUES_3[tag1.func_74771_c("Level")];
        } else {
            this.ownerID = 0;
            this.level = PrivacyLevel.PUBLIC;
        }
    }

    public void writeToNBT(NBTTagCompound tag, String s) {
        if (this.ownerID > 0 || this.level != PrivacyLevel.PUBLIC) {
            NBTTagCompound tag1 = new NBTTagCompound();
            tag1.func_74768_a("Owner", this.ownerID);
            tag1.func_74774_a("Level", (byte)this.level.ID);
            tag.func_74782_a(s, (NBTBase)tag1);
        }
    }

    public boolean hasOwner() {
        return this.getOwner() != null;
    }

    public final boolean isOwner(EntityPlayer ep) {
        if (FTBLib.ftbu == null) {
            return true;
        }
        return this.isOwner(FTBLib.ftbu.getLMPlayer(ep));
    }

    public boolean isOwner(ILMPlayer player) {
        return this.hasOwner() && this.ownerID == player.getPlayerID();
    }

    public final boolean canInteract(EntityPlayer ep) {
        if (FTBLib.ftbu == null) {
            return true;
        }
        return this.canInteract(FTBLib.ftbu.getLMPlayer(ep));
    }

    public boolean canInteract(ILMPlayer playerLM) {
        if (FTBLib.ftbu == null) {
            return true;
        }
        if (this.level == PrivacyLevel.PUBLIC || this.getOwner() == null) {
            return true;
        }
        if (playerLM == null) {
            return false;
        }
        if (this.isOwner(playerLM)) {
            return true;
        }
        if (playerLM != null && playerLM.isOnline() && playerLM.allowInteractSecure()) {
            return true;
        }
        if (this.level == PrivacyLevel.PRIVATE) {
            return false;
        }
        ILMPlayer owner = this.getOwner();
        return this.level == PrivacyLevel.FRIENDS && owner.isFriend(playerLM);
    }

    public void printOwner(ICommandSender ep) {
        ep.func_145747_a((IChatComponent)new ChatComponentTranslation("ftbl.owner", new Object[]{this.hasOwner() ? this.getOwner().getProfile().getName() : "null"}));
    }
}

