/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.NetworkPowerManager;
import crazypants.enderio.power.IPowerInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PowerConduitNetwork
extends AbstractConduitNetwork<IPowerConduit, IPowerConduit> {
    NetworkPowerManager powerManager;
    private final Map<ReceptorKey, ReceptorEntry> powerReceptors = new HashMap<ReceptorKey, ReceptorEntry>();

    public PowerConduitNetwork() {
        super(IPowerConduit.class, IPowerConduit.class);
    }

    @Override
    public void init(IConduitBundle tile, Collection<IPowerConduit> connections, World world) {
        super.init(tile, connections, world);
        this.powerManager = new NetworkPowerManager(this, world);
        this.powerManager.receptorsChanged();
    }

    @Override
    public void destroyNetwork() {
        for (IPowerConduit con : this.conduits) {
            con.setActive(false);
        }
        if (this.powerManager != null) {
            this.powerManager.onNetworkDestroyed();
        }
        super.destroyNetwork();
    }

    public NetworkPowerManager getPowerManager() {
        return this.powerManager;
    }

    @Override
    public void addConduit(IPowerConduit con) {
        super.addConduit(con);
        Set<ForgeDirection> externalDirs = con.getExternalConnections();
        for (ForgeDirection dir : externalDirs) {
            IPowerInterface pr = con.getExternalPowerReceptor(dir);
            if (pr == null) continue;
            TileEntity te = con.getBundle().getEntity();
            this.powerReceptorAdded(con, dir, te.field_145851_c + dir.offsetX, te.field_145848_d + dir.offsetY, te.field_145849_e + dir.offsetZ, pr);
        }
        if (this.powerManager != null) {
            con.setActive(this.powerManager.isActive());
        }
    }

    public void powerReceptorAdded(IPowerConduit powerConduit, ForgeDirection direction, int x, int y, int z, IPowerInterface powerReceptor) {
        if (powerReceptor == null) {
            return;
        }
        BlockCoord location = new BlockCoord(x, y, z);
        ReceptorKey key = new ReceptorKey(location, direction);
        ReceptorEntry re = this.powerReceptors.get(key);
        if (re == null) {
            re = new ReceptorEntry(powerReceptor, location, powerConduit, direction);
            this.powerReceptors.put(key, re);
        }
        if (this.powerManager != null) {
            this.powerManager.receptorsChanged();
        }
    }

    public void powerReceptorRemoved(int x, int y, int z) {
        BlockCoord bc = new BlockCoord(x, y, z);
        ArrayList<ReceptorKey> remove = new ArrayList<ReceptorKey>();
        for (ReceptorKey key : this.powerReceptors.keySet()) {
            if (key == null || !key.coord.equals((Object)bc)) continue;
            remove.add(key);
        }
        for (ReceptorKey key : remove) {
            this.powerReceptors.remove(key);
        }
        this.powerManager.receptorsChanged();
    }

    public Collection<ReceptorEntry> getPowerReceptors() {
        return this.powerReceptors.values();
    }

    @Override
    public void doNetworkTick() {
        this.powerManager.applyRecievedPower();
    }

    private static class ReceptorKey {
        BlockCoord coord;
        ForgeDirection direction;

        ReceptorKey(BlockCoord coord, ForgeDirection direction) {
            this.coord = coord;
            this.direction = direction;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.coord == null ? 0 : this.coord.hashCode());
            result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReceptorKey other = (ReceptorKey)obj;
            if (this.coord == null ? other.coord != null : !this.coord.equals((Object)other.coord)) {
                return false;
            }
            return this.direction == other.direction;
        }
    }

    public static class ReceptorEntry {
        IPowerConduit emmiter;
        BlockCoord coord;
        ForgeDirection direction;
        IPowerInterface powerInterface;

        public ReceptorEntry(IPowerInterface powerReceptor, BlockCoord coord, IPowerConduit emmiter, ForgeDirection direction) {
            this.powerInterface = powerReceptor;
            this.coord = coord;
            this.emmiter = emmiter;
            this.direction = direction;
        }
    }
}

