/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.natives;

import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArray;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.util.MethodOutput;

public class JavaMethodGenerated
implements IJavaMethod {
    private final boolean isStatic;
    private final boolean isInterface;
    private final boolean isVarargs;
    private final String owner;
    private final String name;
    private final ZenType[] parameterTypes;
    private final boolean[] optional;
    private final ZenType returnType;
    private final String descriptor;

    public JavaMethodGenerated(boolean isStatic, boolean isInterface, boolean isVarargs, String owner, String name, ZenType returnType, ZenType[] arguments, boolean[] optional) {
        this.isStatic = isStatic;
        this.isInterface = isInterface;
        this.isVarargs = isVarargs;
        this.owner = owner;
        this.name = name;
        this.returnType = returnType;
        this.parameterTypes = arguments;
        this.optional = optional;
        StringBuilder descriptorString = new StringBuilder();
        descriptorString.append('(');
        for (ZenType argument : arguments) {
            descriptorString.append(argument.getSignature());
        }
        descriptorString.append(')');
        descriptorString.append(returnType.getSignature());
        this.descriptor = descriptorString.toString();
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isVarargs() {
        return this.isVarargs;
    }

    @Override
    public boolean accepts(int numArguments) {
        if (numArguments > this.parameterTypes.length) {
            return this.isVarargs;
        }
        if (numArguments == this.parameterTypes.length) {
            return true;
        }
        for (int i = numArguments; i < this.parameterTypes.length; ++i) {
            if (this.optional[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accepts(IEnvironmentGlobal environment, Expression ... arguments) {
        return this.getPriority(environment, arguments) > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getPriority(IEnvironmentGlobal environment, Expression ... arguments) {
        ZenType argType;
        int result = 3;
        if (arguments.length > this.parameterTypes.length) {
            if (!this.isVarargs) return -1;
            ZenType arrayType = this.parameterTypes[this.parameterTypes.length - 1];
            ZenType baseType = ((ZenTypeArray)arrayType).getBaseType();
            for (int i = this.parameterTypes.length - 1; i < arguments.length; ++i) {
                argType = arguments[i].getType();
                if (argType.equals(baseType)) continue;
                if (!argType.canCastImplicit(baseType, environment)) return -1;
                result = Math.min(result, 1);
            }
        } else if (arguments.length < this.parameterTypes.length) {
            result = 2;
            int checkUntil = this.parameterTypes.length;
            if (this.isVarargs) {
                --checkUntil;
            }
            for (int i = arguments.length; i < checkUntil; ++i) {
                if (this.optional[i]) continue;
                return -1;
            }
        }
        int checkUntil = arguments.length;
        if (arguments.length == this.parameterTypes.length && this.isVarargs) {
            ZenType arrayType = this.parameterTypes[this.parameterTypes.length - 1];
            ZenType baseType = ((ZenTypeArray)arrayType).getBaseType();
            argType = arguments[arguments.length - 1].getType();
            if (!argType.equals(arrayType) && !argType.equals(baseType)) {
                if (argType.canCastImplicit(arrayType, environment)) {
                    result = Math.min(result, 1);
                } else {
                    if (!argType.canCastImplicit(baseType, environment)) return -1;
                    result = Math.min(result, 1);
                }
            }
            checkUntil = arguments.length - 1;
        }
        for (int i = 0; i < checkUntil; ++i) {
            ZenType paramType;
            ZenType argType2 = arguments[i].getType();
            if (argType2.equals(paramType = this.parameterTypes[i])) continue;
            if (!argType2.canCastImplicit(paramType, environment)) return -1;
            result = Math.min(result, 1);
        }
        return result;
    }

    @Override
    public void invokeVirtual(MethodOutput output) {
        if (this.isStatic) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isInterface) {
            output.invokeInterface(this.owner, this.name, this.descriptor);
        } else {
            output.invokeVirtual(this.owner, this.name, this.descriptor);
        }
    }

    @Override
    public void invokeStatic(MethodOutput output) {
        if (!this.isStatic) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        output.invokeStatic(this.owner, this.name, this.descriptor);
    }

    @Override
    public ZenType getReturnType() {
        return this.returnType;
    }

    @Override
    public ZenType[] getParameterTypes() {
        return this.parameterTypes;
    }
}

