/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.recipes;

import java.util.HashMap;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.player.IPlayer;
import minetweaker.api.recipes.CraftingInfo;
import minetweaker.api.recipes.ICraftingInventory;
import minetweaker.api.recipes.ICraftingRecipe;
import minetweaker.api.recipes.IRecipeFunction;

public class ShapelessRecipe
implements ICraftingRecipe {
    private final IItemStack output;
    private final IRecipeFunction function;
    private final IIngredient[] ingredients;

    public ShapelessRecipe(IItemStack output, IIngredient[] ingredients, IRecipeFunction function) {
        this.output = output;
        this.function = function;
        this.ingredients = ingredients;
    }

    public int getSize() {
        return this.ingredients.length;
    }

    public IIngredient[] getIngredients() {
        return this.ingredients;
    }

    public IItemStack getOutput() {
        return this.output;
    }

    @Override
    public boolean matches(ICraftingInventory inventory) {
        return ShapelessRecipe.matchShapeless(this.ingredients, inventory) != null;
    }

    @Override
    public IItemStack getCraftingResult(ICraftingInventory inventory) {
        RecipeMatching matching = ShapelessRecipe.matchShapeless(this.ingredients, inventory);
        IItemStack actualOutput = this.output;
        if (this.function != null) {
            HashMap<String, IItemStack> map = new HashMap<String, IItemStack>();
            for (int i = 0; i < this.ingredients.length; ++i) {
                if (this.ingredients[i].getMark() == null) continue;
                map.put(this.ingredients[i].getMark(), matching.inputs[i]);
            }
            actualOutput = this.function.process(actualOutput, map, new CraftingInfo(inventory, null));
        }
        if (actualOutput == null) {
            return null;
        }
        return actualOutput;
    }

    @Override
    public void applyTransformers(ICraftingInventory inventory, IPlayer byPlayer) {
        RecipeMatching matching = ShapelessRecipe.matchShapeless(this.ingredients, inventory);
        for (int i = 0; i < this.ingredients.length; ++i) {
            IIngredient ingredient = this.ingredients[i];
            IItemStack transformed = ingredient.applyTransform(matching.inputs[i], byPlayer);
            if (transformed == matching.inputs[i]) continue;
            inventory.setStack(matching.indices[i], transformed);
        }
    }

    @Override
    public String toCommandString() {
        StringBuilder result = new StringBuilder();
        result.append("recipes.addShapeless(");
        result.append(this.output);
        result.append(", [");
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.ingredients[i]);
        }
        result.append("]);");
        return result.toString();
    }

    private static RecipeMatching matchShapeless(IIngredient[] recipe, ICraftingInventory ingredients) {
        int numItems = 0;
        for (int i = 0; i < ingredients.getSize(); ++i) {
            if (ingredients.getStack(i) == null) continue;
            ++numItems;
        }
        if (numItems != recipe.length) {
            return null;
        }
        IItemStack[] matched = new IItemStack[recipe.length];
        int[] indices = new int[recipe.length];
        block1: for (int i = 0; i < ingredients.getSize(); ++i) {
            IItemStack ingredient = ingredients.getStack(i);
            if (ingredient == null) continue;
            for (int j = 0; j < recipe.length; ++j) {
                if (matched[j] != null || !recipe[j].matches(ingredient)) continue;
                matched[j] = ingredient;
                indices[j] = i;
                continue block1;
            }
            return null;
        }
        return new RecipeMatching(matched, indices);
    }

    @Override
    public boolean hasTransformers() {
        for (IIngredient ingredient : this.ingredients) {
            if (!ingredient.hasTransformers()) continue;
            return true;
        }
        return false;
    }

    private static class RecipeMatching {
        public final IItemStack[] inputs;
        public final int[] indices;

        public RecipeMatching(IItemStack[] inputs, int[] indices) {
            this.inputs = inputs;
            this.indices = indices;
        }
    }
}

