/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities;

import com.brandon3055.draconicevolution.client.handler.ParticleHandler;
import com.brandon3055.draconicevolution.client.render.particle.ParticleCustom;
import com.brandon3055.draconicevolution.client.render.particle.Particles;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.integration.computers.IDEPeripheral;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileParticleGenerator
extends TileEntity
implements IDEPeripheral {
    public boolean particles_enabled = true;
    public int red = 0;
    public int green = 0;
    public int blue = 0;
    public int random_red = 0;
    public int random_green = 0;
    public int random_blue = 0;
    public float motion_x = 0.0f;
    public float motion_y = 0.0f;
    public float motion_z = 0.0f;
    public float random_motion_x = 0.0f;
    public float random_motion_y = 0.0f;
    public float random_motion_z = 0.0f;
    public float scale = 1.0f;
    public float random_scale = 0.0f;
    public int life = 100;
    public int random_life = 0;
    public float spawn_x = 0.0f;
    public float spawn_y = 0.0f;
    public float spawn_z = 0.0f;
    public float random_spawn_x = 0.0f;
    public float random_spawn_y = 0.0f;
    public float random_spawn_z = 0.0f;
    public int page = 1;
    public int fade = 0;
    public int spawn_rate = 1;
    public boolean collide = false;
    public int selected_particle = 1;
    public int selected_max = 3;
    public float gravity = 0.0f;
    public boolean active = true;
    public boolean signal = false;
    public boolean inverted = false;
    MultiblockHelper.TileLocation master = new MultiblockHelper.TileLocation();
    public float rotation = 0.0f;
    public boolean stabalizerMode = false;
    public boolean beam_enabled = false;
    public boolean render_core = false;
    public int beam_red = 0;
    public int beam_green = 0;
    public int beam_blue = 0;
    public float beam_scale = 1.0f;
    public float beam_pitch = 0.0f;
    public float beam_yaw = 0.0f;
    public float beam_length = 0.0f;
    public float beam_rotation = 0.0f;
    private int tick = 0;

    @SideOnly(value=Side.SERVER)
    public boolean canUpdate() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        this.rotation += 0.5f;
        if (this.stabalizerMode) {
            this.spawnStabilizerParticle();
        }
        if (this.stabalizerMode) {
            return;
        }
        this.active = this.signal && !this.inverted ? true : !this.signal && this.inverted;
        if (this.tick >= this.spawn_rate && this.active && this.particles_enabled) {
            this.tick = 0;
            Random rand = this.field_145850_b.field_73012_v;
            float MX = this.motion_x + this.random_motion_x * rand.nextFloat();
            float MY = this.motion_y + this.random_motion_y * rand.nextFloat();
            float MZ = this.motion_z + this.random_motion_z * rand.nextFloat();
            float SCALE = this.scale + this.random_scale * rand.nextFloat();
            double spawnX = (float)this.field_145851_c + this.spawn_x + this.random_spawn_x * rand.nextFloat();
            double spawnY = (float)this.field_145848_d + this.spawn_y + this.random_spawn_y * rand.nextFloat();
            double spawnZ = (float)this.field_145849_e + this.spawn_z + this.random_spawn_z * rand.nextFloat();
            ParticleCustom particle = new ParticleCustom(this.field_145850_b, spawnX + 0.5, spawnY + 0.5, spawnZ + 0.5, MX, MY, MZ, SCALE, this.collide, this.selected_particle);
            particle.red = this.red + rand.nextInt(this.random_red + 1);
            particle.green = this.green + rand.nextInt(this.random_green + 1);
            particle.blue = this.blue + rand.nextInt(this.random_blue + 1);
            particle.maxAge = this.life + rand.nextInt(this.random_life + 1);
            particle.fadeTime = this.fade;
            particle.fadeLength = this.fade;
            particle.gravity = this.gravity;
            ParticleHandler.spawnCustomParticle(particle, 256.0);
        } else {
            ++this.tick;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnStabilizerParticle() {
        if (this.getMaster() == null || this.field_145850_b.func_82737_E() % 20L != 1L) {
            return;
        }
        double x = (double)this.field_145851_c + 0.5;
        double y = (double)this.field_145848_d + 0.5;
        double z = (double)this.field_145849_e + 0.5;
        int direction = 0;
        if (this.getMaster().field_145851_c > this.field_145851_c) {
            direction = 0;
        } else if (this.getMaster().field_145851_c < this.field_145851_c) {
            direction = 1;
        } else if (this.getMaster().field_145849_e > this.field_145849_e) {
            direction = 2;
        } else if (this.getMaster().field_145849_e < this.field_145849_e) {
            direction = 3;
        }
        Particles.EnergyBeamParticle particle = new Particles.EnergyBeamParticle(this.field_145850_b, x, y, z, (double)this.getMaster().field_145851_c + 0.5, (double)this.getMaster().field_145849_e + 0.5, direction, false);
        Particles.EnergyBeamParticle particle2 = new Particles.EnergyBeamParticle(this.field_145850_b, x, y, z, (double)this.getMaster().field_145851_c + 0.5, (double)this.getMaster().field_145849_e + 0.5, direction, true);
        ParticleHandler.spawnCustomParticle(particle, 60.0);
        ParticleHandler.spawnCustomParticle(particle2, 60.0);
    }

    public void toggleInverted() {
        this.inverted = !this.inverted;
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145841_b(NBTTagCompound compound) {
        this.master.writeToNBT(compound, "Key");
        compound.func_74757_a("StabalizerMode", this.stabalizerMode);
        this.getBlockNBT(compound);
        super.func_145841_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.master.readFromNBT(compound, "Key");
        this.stabalizerMode = compound.func_74767_n("StabalizerMode");
        this.setBlockNBT(compound);
        super.func_145839_a(compound);
    }

    public TileEnergyStorageCore getMaster() {
        if (this.master == null) {
            return null;
        }
        TileEnergyStorageCore tile = this.field_145850_b.func_147438_o(this.master.getXCoord(), this.master.getYCoord(), this.master.getZCoord()) != null && this.field_145850_b.func_147438_o(this.master.getXCoord(), this.master.getYCoord(), this.master.getZCoord()) instanceof TileEnergyStorageCore ? (TileEnergyStorageCore)this.field_145850_b.func_147438_o(this.master.getXCoord(), this.master.getYCoord(), this.master.getZCoord()) : null;
        return tile;
    }

    public void setMaster(MultiblockHelper.TileLocation master) {
        this.master = master;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void getBlockNBT(NBTTagCompound compound) {
        compound.func_74768_a("Red", this.red);
        compound.func_74768_a("Green", this.green);
        compound.func_74768_a("Blue", this.blue);
        compound.func_74768_a("RandomRed", this.random_red);
        compound.func_74768_a("RandomGreen", this.random_green);
        compound.func_74768_a("RandomBlue", this.random_blue);
        compound.func_74776_a("MotionX", this.motion_x);
        compound.func_74776_a("MotionY", this.motion_y);
        compound.func_74776_a("MotionZ", this.motion_z);
        compound.func_74776_a("RandomMotionX", this.random_motion_x);
        compound.func_74776_a("RandomMotionY", this.random_motion_y);
        compound.func_74776_a("RandomMotionZ", this.random_motion_z);
        compound.func_74776_a("Scale", this.scale);
        compound.func_74776_a("RandomScale", this.random_scale);
        compound.func_74768_a("Life", this.life);
        compound.func_74768_a("RandomLife", this.random_life);
        compound.func_74776_a("SpawnX", this.spawn_x);
        compound.func_74776_a("SpawnY", this.spawn_y);
        compound.func_74776_a("SpawnZ", this.spawn_z);
        compound.func_74776_a("RandomSpawnX", this.random_spawn_x);
        compound.func_74776_a("RandomSpawnY", this.random_spawn_y);
        compound.func_74776_a("RandomSpawnZ", this.random_spawn_z);
        compound.func_74768_a("Page", this.page);
        compound.func_74768_a("SpawnRate", this.spawn_rate);
        compound.func_74757_a("CanCollide", this.collide);
        compound.func_74768_a("Fade", this.fade);
        compound.func_74768_a("SelectedParticle", this.selected_particle);
        compound.func_74776_a("Gravity", this.gravity);
        compound.func_74757_a("Active", this.active);
        compound.func_74757_a("Signal", this.signal);
        compound.func_74757_a("Inverted", this.inverted);
        compound.func_74757_a("particles_enabled", this.particles_enabled);
        compound.func_74757_a("beam_enabled", this.beam_enabled);
        compound.func_74757_a("render_core", this.render_core);
        compound.func_74768_a("beam_red", this.beam_red);
        compound.func_74768_a("beam_green", this.beam_green);
        compound.func_74768_a("beam_blue", this.beam_blue);
        compound.func_74776_a("beam_scale", this.beam_scale);
        compound.func_74776_a("beam_pitch", this.beam_pitch);
        compound.func_74776_a("beam_yaw", this.beam_yaw);
        compound.func_74776_a("beam_length", this.beam_length);
        compound.func_74776_a("beam_rotation", this.beam_rotation);
    }

    public void setBlockNBT(NBTTagCompound compound) {
        this.red = compound.func_74762_e("Red");
        this.green = compound.func_74762_e("Green");
        this.blue = compound.func_74762_e("Blue");
        this.random_red = compound.func_74762_e("RandomRed");
        this.random_green = compound.func_74762_e("RandomGreen");
        this.random_blue = compound.func_74762_e("RandomBlue");
        this.motion_x = compound.func_74760_g("MotionX");
        this.motion_y = compound.func_74760_g("MotionY");
        this.motion_z = compound.func_74760_g("MotionZ");
        this.random_motion_x = compound.func_74760_g("RandomMotionX");
        this.random_motion_y = compound.func_74760_g("RandomMotionY");
        this.random_motion_z = compound.func_74760_g("RandomMotionZ");
        this.scale = compound.func_74760_g("Scale");
        this.random_scale = compound.func_74760_g("RandomScale");
        this.life = compound.func_74762_e("Life");
        this.random_life = compound.func_74762_e("RandomLife");
        this.spawn_x = compound.func_74760_g("SpawnX");
        this.spawn_y = compound.func_74760_g("SpawnY");
        this.spawn_z = compound.func_74760_g("SpawnZ");
        this.random_spawn_x = compound.func_74760_g("RandomSpawnX");
        this.random_spawn_y = compound.func_74760_g("RandomSpawnY");
        this.random_spawn_z = compound.func_74760_g("RandomSpawnZ");
        this.page = compound.func_74762_e("Page");
        this.spawn_rate = compound.func_74762_e("SpawnRate");
        this.collide = compound.func_74767_n("CanCollide");
        this.fade = compound.func_74762_e("Fade");
        this.selected_particle = compound.func_74762_e("SelectedParticle");
        this.gravity = compound.func_74760_g("Gravity");
        this.active = compound.func_74767_n("Active");
        this.signal = compound.func_74767_n("Signal");
        this.inverted = compound.func_74767_n("Inverted");
        this.particles_enabled = compound.func_74767_n("particles_enabled");
        this.beam_enabled = compound.func_74767_n("beam_enabled");
        this.render_core = compound.func_74767_n("render_core");
        this.beam_red = compound.func_74762_e("beam_red");
        this.beam_green = compound.func_74762_e("beam_green");
        this.beam_blue = compound.func_74762_e("beam_blue");
        this.beam_scale = compound.func_74760_g("beam_scale");
        this.beam_pitch = compound.func_74760_g("beam_pitch");
        this.beam_yaw = compound.func_74760_g("beam_yaw");
        this.beam_length = compound.func_74760_g("beam_length");
        this.beam_rotation = compound.func_74760_g("beam_rotation");
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 655360.0;
    }

    public static double limit(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static int limit(int value, int min, int max) {
        return Math.max(min, Math.min(value, max));
    }

    @Override
    public String getName() {
        return "particle_generator";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"setGeneratorProperty", "getGeneratorState", "resetGeneratorState"};
    }

    @Override
    public Object[] callMethod(String method, Object ... args) {
        if (method.startsWith("setGeneratorProperty")) {
            if (args.length != 2) {
                return new Object[]{false};
            }
            if (!(args[0] instanceof String)) {
                return new Object[]{false};
            }
            if (args[0].equals("particles_enabled") && args[1] instanceof Boolean) {
                this.particles_enabled = (Boolean)args[1];
            } else if (args[0].equals("red") && args[1] instanceof Double) {
                this.red = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("green") && args[1] instanceof Double) {
                this.green = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("blue") && args[1] instanceof Double) {
                this.blue = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("random_red") && args[1] instanceof Double) {
                this.random_red = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("random_green") && args[1] instanceof Double) {
                this.random_green = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("random_blue") && args[1] instanceof Double) {
                this.random_blue = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("motion_x") && args[1] instanceof Double) {
                this.motion_x = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("motion_y") && args[1] instanceof Double) {
                this.motion_y = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("motion_z") && args[1] instanceof Double) {
                this.motion_z = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("random_motion_x") && args[1] instanceof Double) {
                this.random_motion_x = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("random_motion_y") && args[1] instanceof Double) {
                this.random_motion_y = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("random_motion_z") && args[1] instanceof Double) {
                this.random_motion_z = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("scale") && args[1] instanceof Double) {
                this.scale = (float)TileParticleGenerator.limit((Double)args[1], 0.01f, 50.0);
            } else if (args[0].equals("random_scale") && args[1] instanceof Double) {
                this.random_scale = (float)TileParticleGenerator.limit((Double)args[1], 0.01f, 50.0);
            } else if (args[0].equals("life") && args[1] instanceof Double) {
                this.life = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 1000);
            } else if (args[0].equals("random_life") && args[1] instanceof Double) {
                this.random_life = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 1000);
            } else if (args[0].equals("spawn_x") && args[1] instanceof Double) {
                this.spawn_x = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("spawn_y") && args[1] instanceof Double) {
                this.spawn_y = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("spawn_z") && args[1] instanceof Double) {
                this.spawn_z = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("random_spawn_x") && args[1] instanceof Double) {
                this.random_spawn_x = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("random_spawn_y") && args[1] instanceof Double) {
                this.random_spawn_y = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("random_spawn_z") && args[1] instanceof Double) {
                this.random_spawn_z = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("fade") && args[1] instanceof Double) {
                this.fade = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 100);
            } else if (args[0].equals("spawn_rate") && args[1] instanceof Double) {
                this.spawn_rate = TileParticleGenerator.limit(((Double)args[1]).intValue(), 1, 200);
            } else if (args[0].equals("collide") && args[1] instanceof Double) {
                this.collide = (Boolean)args[1];
            } else if (args[0].equals("selected_particle") && args[1] instanceof Double) {
                this.selected_particle = TileParticleGenerator.limit(((Double)args[1]).intValue(), 1, this.selected_max);
            } else if (args[0].equals("gravity") && args[1] instanceof Double) {
                this.gravity = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("beam_enabled") && args[1] instanceof Boolean) {
                this.beam_enabled = (Boolean)args[1];
            } else if (args[0].equals("render_core") && args[1] instanceof Boolean) {
                this.render_core = (Boolean)args[1];
            } else if (args[0].equals("beam_red") && args[1] instanceof Double) {
                this.beam_red = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("beam_green") && args[1] instanceof Double) {
                this.beam_green = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("beam_blue") && args[1] instanceof Double) {
                this.beam_blue = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("beam_scale") && args[1] instanceof Double) {
                this.beam_scale = (float)TileParticleGenerator.limit((Double)args[1], -0.0, 5.0);
            } else if (args[0].equals("beam_pitch") && args[1] instanceof Double) {
                this.beam_pitch = (float)TileParticleGenerator.limit((Double)args[1], -180.0, 180.0);
            } else if (args[0].equals("beam_yaw") && args[1] instanceof Double) {
                this.beam_yaw = (float)TileParticleGenerator.limit((Double)args[1], -180.0, 180.0);
            } else if (args[0].equals("beam_length") && args[1] instanceof Double) {
                this.beam_length = (float)TileParticleGenerator.limit((Double)args[1], -0.0, 320.0);
            } else if (args[0].equals("beam_rotation") && args[1] instanceof Double) {
                this.beam_rotation = (float)TileParticleGenerator.limit((Double)args[1], -1.0, 1.0);
            } else {
                return new Object[]{false};
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return new Object[]{true};
        }
        if (method.startsWith("getGeneratorState")) {
            HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
            map.put("particles_enabled", Boolean.valueOf(this.particles_enabled));
            map.put("red", Integer.valueOf(this.red));
            map.put("green", Integer.valueOf(this.green));
            map.put("blue", Integer.valueOf(this.blue));
            map.put("random_red", Integer.valueOf(this.random_red));
            map.put("random_green", Integer.valueOf(this.random_green));
            map.put("random_blue", Integer.valueOf(this.random_blue));
            map.put("motion_x", Float.valueOf(this.motion_x));
            map.put("motion_y", Float.valueOf(this.motion_y));
            map.put("motion_z", Float.valueOf(this.motion_z));
            map.put("random_motion_x", Float.valueOf(this.random_motion_x));
            map.put("random_motion_y", Float.valueOf(this.random_motion_y));
            map.put("random_motion_z", Float.valueOf(this.random_motion_z));
            map.put("scale", Float.valueOf(this.scale));
            map.put("random_scale", Float.valueOf(this.random_scale));
            map.put("life", Integer.valueOf(this.life));
            map.put("random_life", Integer.valueOf(this.random_life));
            map.put("spawn_x", Float.valueOf(this.spawn_x));
            map.put("spawn_y", Float.valueOf(this.spawn_y));
            map.put("spawn_z", Float.valueOf(this.spawn_z));
            map.put("random_spawn_x", Float.valueOf(this.random_spawn_x));
            map.put("random_spawn_y", Float.valueOf(this.random_spawn_y));
            map.put("random_spawn_z", Float.valueOf(this.random_spawn_z));
            map.put("fade", Integer.valueOf(this.fade));
            map.put("spawn_rate", Integer.valueOf(this.spawn_rate));
            map.put("collide", Boolean.valueOf(this.collide));
            map.put("selected_particle", Integer.valueOf(this.selected_particle));
            map.put("gravity", Float.valueOf(this.gravity));
            map.put("beam_enabled", Boolean.valueOf(this.beam_enabled));
            map.put("render_core", Boolean.valueOf(this.render_core));
            map.put("beam_red", Integer.valueOf(this.beam_red));
            map.put("beam_green", Integer.valueOf(this.beam_green));
            map.put("beam_blue", Integer.valueOf(this.beam_blue));
            map.put("beam_scale", Float.valueOf(this.beam_scale));
            map.put("beam_pitch", Float.valueOf(this.beam_pitch));
            map.put("beam_yaw", Float.valueOf(this.beam_yaw));
            map.put("beam_length", Float.valueOf(this.beam_length));
            map.put("beam_rotation", Float.valueOf(this.beam_rotation));
            return new Object[]{map};
        }
        if (method.startsWith("resetGeneratorState")) {
            this.particles_enabled = true;
            this.red = 0;
            this.green = 0;
            this.blue = 0;
            this.random_red = 0;
            this.random_green = 0;
            this.random_blue = 0;
            this.motion_x = 0.0f;
            this.motion_y = 0.0f;
            this.motion_z = 0.0f;
            this.random_motion_x = 0.0f;
            this.random_motion_y = 0.0f;
            this.random_motion_z = 0.0f;
            this.scale = 1.0f;
            this.random_scale = 0.0f;
            this.life = 100;
            this.random_life = 0;
            this.spawn_x = 0.0f;
            this.spawn_y = 0.0f;
            this.spawn_z = 0.0f;
            this.random_spawn_x = 0.0f;
            this.random_spawn_y = 0.0f;
            this.random_spawn_z = 0.0f;
            this.page = 1;
            this.fade = 0;
            this.spawn_rate = 1;
            this.collide = false;
            this.selected_particle = 1;
            this.gravity = 0.0f;
            this.beam_enabled = false;
            this.render_core = false;
            this.beam_red = 0;
            this.beam_green = 0;
            this.beam_blue = 0;
            this.beam_scale = 1.0f;
            this.beam_pitch = 0.0f;
            this.beam_yaw = 0.0f;
            this.beam_length = 0.0f;
            this.beam_rotation = 0.0f;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return new Object[]{true};
        }
        return new Object[]{0};
    }
}

