/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.weapons;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.entity.EntityCustomArrow;
import com.brandon3055.draconicevolution.common.entity.EntityEnderArrow;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.items.weapons.IEnergyContainerWeaponItem;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.IUpgradableItem;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class BowHandler {
    public static ItemStack onBowRightClick(Item bow, ItemStack stack, World world, EntityPlayer player) {
        BowProperties properties = new BowProperties(stack, player);
        if (properties.canFire()) {
            ArrowNockEvent event = new ArrowNockEvent(player, stack);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return event.result;
            }
            player.func_71008_a(stack, bow.func_77626_a(stack));
        }
        return stack;
    }

    public static void onBowUsingTick(ItemStack stack, EntityPlayer player, int count) {
        BowProperties properties = new BowProperties(stack, player);
        int j = 72000 - count;
        if (properties.autoFire && j >= properties.getDrawTicks()) {
            player.func_71034_by();
        }
    }

    public static void onPlayerStoppedUsingBow(ItemStack stack, World world, EntityPlayer player, int count) {
        BowProperties properties = new BowProperties(stack, player);
        if (!properties.canFire() || !(stack.func_77973_b() instanceof IEnergyContainerItem)) {
            return;
        }
        int j = 72000 - count;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, j);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        j = event.charge;
        float drawArrowSpeedModifier = Math.min((float)j / (float)properties.getDrawTicks(), 1.0f);
        if ((double)drawArrowSpeedModifier < 0.1) {
            return;
        }
        float velocity = properties.arrowSpeed * drawArrowSpeedModifier * 2.0f;
        EntityCustomArrow customArrow = new EntityCustomArrow(world, (EntityLivingBase)player, velocity);
        customArrow.bowProperties = properties;
        if (drawArrowSpeedModifier == 1.0f) {
            customArrow.func_70243_d(true);
        }
        customArrow.field_70251_a = properties.consumeArrowAndEnergy() ? 1 : 2;
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)customArrow);
        }
        world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 1.2f) + (drawArrowSpeedModifier + velocity / 40.0f) * 0.5f);
    }

    public static void enderShot(ItemStack stack, World world, EntityPlayer player, int count, Random itemRand, float pullSpeedModifier, float speedModifier, float soundPitchModifier, int minRelease) {
        int j = 72000 - count;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, j);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        j = event.charge;
        if (player.field_71071_by.func_146028_b((Item)ModItems.enderArrow)) {
            float f = (float)j / pullSpeedModifier;
            f = (f * f + f * 2.0f) / 3.0f;
            if (j < minRelease || (double)f < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityEnderArrow entityArrow = new EntityEnderArrow(world, (EntityLivingBase)player, (f *= speedModifier) * 2.0f);
            stack.func_77972_a(1, (EntityLivingBase)player);
            world.func_72956_a((Entity)player, "random.bow", 1.0f, soundPitchModifier * (1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.3f));
            if (player.field_71071_by.func_146028_b((Item)ModItems.enderArrow)) {
                player.field_71071_by.func_146026_a((Item)ModItems.enderArrow);
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityArrow);
                player.func_70078_a((Entity)entityArrow);
            }
        }
    }

    public static class BowProperties {
        public ItemStack bow;
        public EntityPlayer player;
        public float arrowDamage = 0.0f;
        public float arrowSpeed = 0.0f;
        public float explosionPower = 0.0f;
        public float shockWavePower = 0.0f;
        public float zoomModifier = 0.0f;
        private int drawTimeReduction = 0;
        public boolean autoFire = false;
        public boolean energyBolt = false;
        public String cantFireMessage = null;

        public BowProperties() {
            this.bow = new ItemStack(ModItems.wyvernBow);
            this.player = null;
        }

        public BowProperties(ItemStack bow, EntityPlayer player) {
            this.bow = bow;
            this.player = player;
            this.updateValues();
        }

        public int calculateEnergyCost() {
            this.updateValues();
            double rfCost = this.bow.func_77973_b() instanceof IEnergyContainerWeaponItem ? (double)((IEnergyContainerWeaponItem)this.bow.func_77973_b()).getEnergyPerAttack() : 80.0;
            rfCost *= (double)(1.0f + this.arrowDamage);
            rfCost *= (double)((1.0f + this.arrowSpeed) * (1.0f + this.arrowSpeed) * (1.0f + this.arrowSpeed));
            rfCost *= (double)(1.0f + this.explosionPower * 20.0f);
            rfCost *= (double)(1.0f + this.shockWavePower * 10.0f);
            if (this.energyBolt) {
                rfCost *= (double)BalanceConfigHandler.draconicFireEnergyCostMultiptier;
            }
            return (int)rfCost;
        }

        public boolean canFire() {
            this.updateValues();
            if (this.player == null) {
                return false;
            }
            if (!(this.bow.func_77973_b() instanceof IEnergyContainerWeaponItem)) {
                this.cantFireMessage = "[Error] This bow is not a valid energy container (This is a bug, Please report on the Draconic Evolution github)";
                return false;
            }
            if (!this.energyBolt && this.shockWavePower > 0.0f) {
                this.cantFireMessage = "msg.de.shockWaveForEnergyBoltsOnly.txt";
                return false;
            }
            if (this.energyBolt && this.explosionPower > 0.0f) {
                this.cantFireMessage = "msg.de.explosiveNotForEnergyBolts.txt";
                return false;
            }
            if (this.calculateEnergyCost() > ((IEnergyContainerWeaponItem)this.bow.func_77973_b()).getEnergyStored(this.bow) && !this.player.field_71075_bZ.field_75098_d) {
                this.cantFireMessage = "msg.de.insufficientPowerToFire.txt";
                return false;
            }
            if (!(this.energyBolt || this.player.field_71071_by.func_146028_b(Items.field_151032_g) || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)this.bow) != 0 || this.player.field_71075_bZ.field_75098_d)) {
                this.cantFireMessage = "msg.de.outOfArrows.txt";
                return false;
            }
            this.cantFireMessage = null;
            return true;
        }

        private void updateValues() {
            this.arrowDamage = IConfigurableItem.ProfileHelper.getFloat(this.bow, "BowArrowDamage", IUpgradableItem.EnumUpgrade.ARROW_DAMAGE.getUpgradePoints(this.bow));
            this.arrowSpeed = 1.0f + IConfigurableItem.ProfileHelper.getFloat(this.bow, "BowArrowSpeedModifier", 0.0f);
            this.explosionPower = IConfigurableItem.ProfileHelper.getFloat(this.bow, "BowExplosionPower", 0.0f);
            this.shockWavePower = IConfigurableItem.ProfileHelper.getFloat(this.bow, "BowShockWavePower", 0.0f);
            this.drawTimeReduction = IUpgradableItem.EnumUpgrade.DRAW_SPEED.getUpgradePoints(this.bow);
            this.zoomModifier = IConfigurableItem.ProfileHelper.getFloat(this.bow, "BowZoomModifier", 0.0f);
            this.autoFire = IConfigurableItem.ProfileHelper.getBoolean(this.bow, "BowAutoFire", false);
            this.energyBolt = IConfigurableItem.ProfileHelper.getBoolean(this.bow, "BowEnergyBolt", false);
        }

        public int getDrawTicks() {
            return Math.max(62 - this.drawTimeReduction * 10, 1);
        }

        public boolean consumeArrowAndEnergy() {
            if (!this.player.field_71075_bZ.field_75098_d) {
                ((IEnergyContainerWeaponItem)this.bow.func_77973_b()).extractEnergy(this.bow, this.calculateEnergyCost(), false);
            }
            if (!this.energyBolt && EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)this.bow) == 0 && !this.player.field_71075_bZ.field_75098_d) {
                this.player.field_71071_by.func_146026_a(Items.field_151032_g);
                return true;
            }
            return false;
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74776_a("ArrowDamage", this.arrowDamage);
            compound.func_74776_a("ArrowExplosive", this.explosionPower);
            compound.func_74776_a("ArrowShock", this.shockWavePower);
            compound.func_74757_a("ArrowEnergy", this.energyBolt);
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.arrowDamage = compound.func_74760_g("ArrowDamage");
            this.explosionPower = compound.func_74760_g("ArrowExplosive");
            this.shockWavePower = compound.func_74760_g("ArrowShock");
            this.energyBolt = compound.func_74767_n("ArrowEnergy");
        }
    }
}

