/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.entity;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.brandonscore.common.utills.Teleporter;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.handler.ParticleHandler;
import com.brandon3055.draconicevolution.client.render.particle.Particles;
import com.brandon3055.draconicevolution.common.entity.EntityChaosCrystal;
import com.brandon3055.draconicevolution.common.network.GenericParticlePacket;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityDragonProjectile
extends Entity {
    public int type = 0;
    public EntityLivingBase target;
    public Entity shooter;
    public float power;
    public boolean isChaser;
    private double lastTickTargetDistance = 100.0;
    private float heath = 5.0f;
    private DamageSource damageFireball = new DamageSource("de.GuardianFireball").func_76359_i().func_82726_p().func_94540_d();
    private DamageSource damageEnergy = new DamageSource("de.GuardianEnergyBall").func_76359_i().func_76348_h();
    private DamageSource damageChaos = new DamageSource("de.GuardianChaosBall").func_76359_i().func_76348_h().func_151518_m();
    public static final int FIREBOMB = 1;
    public static final int TELEPORT = 2;
    public static final int FIRE_CHASER = 3;
    public static final int ENERGY_CHASER = 4;
    public static final int CHAOS_CHASER = 5;
    public static final int MINI_CHAOS_CHASER = 6;
    public static final int IGNITION_CHARGE = 7;

    public EntityDragonProjectile(World world) {
        this(world, 0, null, 10.0f, null);
    }

    public EntityDragonProjectile(World world, int type, EntityLivingBase target, float power, Entity shooter) {
        super(world);
        this.type = type;
        this.target = target;
        this.shooter = shooter;
        this.power = power;
        this.isChaser = type == 3 || type == 4 || type == 5 || type == 6 || type == 7;
        this.func_70105_a(1.0f, 1.0f);
        if (shooter != null) {
            this.field_70170_p.func_72908_a(shooter.field_70165_t + 0.5, shooter.field_70163_u + 0.5, shooter.field_70161_v + 0.5, "mob.ghast.fireball", 10.0f, this.field_70146_Z.nextFloat() * 0.3f + 0.85f);
            this.field_70177_z = shooter instanceof EntityDragon ? shooter.field_70177_z + 180.0f : shooter.field_70177_z;
            this.field_70125_A = shooter.field_70125_A;
            if (type == 1 || type == 2) {
                this.field_70125_A += (this.field_70146_Z.nextFloat() - 0.5f) * 20.0f;
                this.field_70177_z += (this.field_70146_Z.nextFloat() - 0.5f) * 20.0f;
            }
            this.field_70129_M = 0.0f;
            this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
            this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
            this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
            double speed = 5.0;
            this.field_70159_w *= speed;
            this.field_70181_x *= speed;
            this.field_70179_y *= speed;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d1 = this.field_70121_D.func_72320_b() * 80.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    protected void func_70088_a() {
        if (this.type == 4 || this.type == 5 || this.type == 6 || this.type == 7 || this.field_70170_p.field_72995_K) {
            this.field_70145_X = true;
        }
        this.field_70180_af.func_75682_a(10, (Object)((byte)this.type));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.field_70180_af.func_75692_b(10, (Object)((byte)this.type));
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.type == 0) {
                this.type = this.field_70180_af.func_75683_a(10);
            }
            this.spawnParticle();
        }
        if (this.target == null) {
            if (this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 60.0) != null) {
                this.target = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 60.0);
            } else {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
                return;
            }
        }
        if (this.isChaser && !this.field_70170_p.field_72995_K) {
            double tDist = Utills.getDistanceAtoB((double)this.target.field_70165_t, (double)this.target.field_70163_u, (double)this.target.field_70161_v, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            if (tDist <= 0.0) {
                tDist = 0.1;
            }
            double x = (this.target.field_70165_t - this.field_70165_t) / tDist;
            double y = (this.target.field_70163_u - this.field_70163_u - -1.0) / tDist;
            double z = (this.target.field_70161_v - this.field_70161_v) / tDist;
            double speed = this.type == 5 ? 0.15 : 0.1;
            this.field_70159_w /= 1.1;
            this.field_70181_x /= 1.1;
            this.field_70179_y /= 1.1;
            this.field_70159_w += x * speed;
            this.field_70181_x += y * speed;
            this.field_70179_y += z * speed;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.checkTargetCondition();
    }

    private boolean checkTargetCondition() {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        double targetDistance = Utills.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.target.field_70165_t, (double)this.target.field_70163_u, (double)this.target.field_70161_v);
        Entity entityHit = this.getHitEntity();
        if (entityHit instanceof EntityDragonPart) {
            entityHit = null;
        }
        boolean genericHit = entityHit != null || targetDistance <= 1.0;
        switch (this.type) {
            case 1: {
                if (!(genericHit || targetDistance > this.lastTickTargetDistance && targetDistance < (double)this.power || this.field_70132_H || this.field_70173_aa > 600) && !(this.heath <= 0.0f)) break;
                this.func_70106_y();
                this.field_70170_p.func_72885_a(this.shooter, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, true, true);
                this.damageEntitiesInRadius(this.damageFireball, this.power, this.power * 2.0f);
                break;
            }
            case 2: {
                if (genericHit) {
                    Entity hit;
                    this.func_70106_y();
                    Object object = hit = entityHit != null ? entityHit : this.target;
                    if (!(hit instanceof EntityPlayer)) break;
                    int r = this.field_70146_Z.nextInt();
                    if (this.shooter != null) {
                        new Teleporter.TeleportLocation(this.shooter.field_70165_t + Math.cos(r) * 600.0, (double)this.field_70146_Z.nextInt(255), this.shooter.field_70161_v + Math.sin(r) * 600.0, hit.field_71093_bK).sendEntityToCoords(hit);
                    } else {
                        new Teleporter.TeleportLocation(this.field_70165_t + Math.cos(r) * 600.0, (double)this.field_70146_Z.nextInt(255), this.field_70161_v + Math.sin(r) * 600.0, hit.field_71093_bK).sendEntityToCoords(hit);
                    }
                    hit.func_70097_a(DamageSource.field_76379_h, 10.0f);
                    break;
                }
                if (!this.field_70132_H && this.field_70173_aa <= 400 && !(this.heath <= 0.0f)) break;
                this.func_70106_y();
                break;
            }
            case 3: {
                boolean bl = this.field_70145_X = this.field_70173_aa < 60;
                if (!(genericHit || targetDistance > this.lastTickTargetDistance && targetDistance < (double)(this.power / 2.0f) || this.field_70132_H && this.field_70173_aa > 60 || this.field_70173_aa > 400) && !(this.heath <= 0.0f)) break;
                this.func_70106_y();
                this.field_70170_p.func_72885_a(this.shooter, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, true, true);
                this.damageEntitiesInRadius(this.damageFireball, this.power, this.power * 2.0f);
                break;
            }
            case 4: {
                if (!(genericHit || targetDistance > this.lastTickTargetDistance && targetDistance < (double)this.power || this.field_70173_aa > 800) && !(this.heath <= 0.0f)) break;
                this.func_70106_y();
                DraconicEvolution.network.sendToAllAround((IMessage)new GenericParticlePacket(0, this.field_70165_t, this.field_70163_u, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0));
                this.damageEntitiesInRadius(this.damageEnergy, this.power, this.power * 3.0f);
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                break;
            }
            case 5: {
                if (!(genericHit || targetDistance > this.lastTickTargetDistance && targetDistance < (double)this.power || this.field_70173_aa > 800) && !(this.heath <= 0.0f)) break;
                this.func_70106_y();
                DraconicEvolution.network.sendToAllAround((IMessage)new GenericParticlePacket(1, this.field_70165_t, this.field_70163_u, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0));
                this.damageEntitiesInRadius(this.damageChaos, this.power, this.power * 3.0f);
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                int i = 3 + this.field_70146_Z.nextInt(3);
                List list = this.field_70170_p.func_94576_a(this.shooter, this.field_70121_D.func_72314_b(60.0, 60.0, 60.0), Utills.selectPlayer);
                while (i > 0) {
                    EntityDragonProjectile newProjectile = new EntityDragonProjectile(this.field_70170_p, 6, list.size() > 0 ? (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size())) : null, this.power / 2.0f, this.shooter);
                    newProjectile.field_70181_x = 0.0;
                    int randDir = this.field_70146_Z.nextInt();
                    double speed = 1.0 + this.field_70146_Z.nextDouble() * 5.0;
                    newProjectile.field_70159_w = Math.sin(randDir) * speed;
                    newProjectile.field_70179_y = Math.cos(randDir) * speed;
                    newProjectile.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)newProjectile);
                    --i;
                }
                break;
            }
            case 6: {
                if (!(genericHit || targetDistance > this.lastTickTargetDistance && targetDistance < (double)this.power || this.field_70173_aa > 800) && !(this.heath <= 0.0f) || this.field_70173_aa <= 5) break;
                this.func_70106_y();
                DraconicEvolution.network.sendToAllAround((IMessage)new GenericParticlePacket(1, this.field_70165_t, this.field_70163_u, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0));
                this.damageEntitiesInRadius(this.damageChaos, this.power, this.power * 3.0f);
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                break;
            }
            case 7: {
                if (!(targetDistance < 1.0)) break;
                if (this.target instanceof EntityChaosCrystal) {
                    ((EntityChaosCrystal)this.target).revive();
                }
                this.func_70106_y();
            }
        }
        this.lastTickTargetDistance = targetDistance;
        return false;
    }

    private Entity getHitEntity() {
        Vec3 vec31 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        Entity entityHit = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            float f1;
            AxisAlignedBB axisalignedbb1;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L() || entity1 == this.shooter && this.field_70173_aa < 5 || (movingobjectposition1 = (axisalignedbb1 = entity1.field_70121_D.func_72314_b((double)(f1 = 1.0f), (double)f1, (double)f1)).func_72327_a(vec31, vec3)) == null || !((d1 = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entityHit = entity1;
            d0 = d1;
        }
        return entityHit instanceof EntityDragonProjectile ? null : entityHit;
    }

    private void damageEntitiesInRadius(DamageSource source, double radius, float damage) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72314_b(radius, radius, radius));
        for (EntityLivingBase entityLivingBase : entities) {
            if (entityLivingBase == this.shooter) continue;
            entityLivingBase.field_70172_ad = 0;
            entityLivingBase.func_70097_a(source, damage / (float)(Utills.getDistanceAtoB((double)entityLivingBase.field_70165_t, (double)entityLivingBase.field_70163_u, (double)entityLivingBase.field_70161_v, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v) / radius));
            if (source != this.damageChaos || !(entityLivingBase instanceof EntityPlayer)) continue;
            for (ItemStack stack : ((EntityPlayer)entityLivingBase).field_71071_by.field_70460_b) {
                if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                ((IEnergyContainerItem)stack.func_77973_b()).extractEnergy(stack, 30000 + this.field_70146_Z.nextInt(10000), false);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float dmg) {
        if (this.heath <= 0.0f) {
            return false;
        }
        if ((source.func_76346_g() instanceof EntityPlayer || source.func_76346_g() instanceof EntityArrow) && this.field_70173_aa > 5) {
            this.heath -= dmg;
        }
        if (source.func_76364_f() instanceof EntityArrow) {
            source.func_76364_f().func_70106_y();
        }
        if (this.heath <= 0.0f) {
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false, false);
            this.func_70106_y();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticle() {
        if (this.getParticleColour() == 0) {
            return;
        }
        Particles.DragonProjectileParticle particle = new Particles.DragonProjectileParticle(this.field_70170_p, this.field_70165_t - 0.25 + this.field_70146_Z.nextDouble() * 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() * 0.5, this.field_70161_v - 0.25 + this.field_70146_Z.nextDouble() * 0.5, this);
        double mm = 0.2;
        particle.field_70159_w = (this.field_70146_Z.nextDouble() - 0.5) * mm;
        particle.field_70181_x = (this.field_70146_Z.nextDouble() - 0.5) * mm;
        particle.field_70179_y = (this.field_70146_Z.nextDouble() - 0.5) * mm;
        ParticleHandler.spawnCustomParticle(particle, 64.0);
    }

    public int getParticleColour() {
        switch (this.type) {
            case 1: {
                return 0xFF6600;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0xFF6600;
            }
            case 4: {
                return 65535;
            }
            case 5: {
                return 0x440000;
            }
            case 6: {
                return 0x440000;
            }
            case 7: {
                return 0xFFFFFF;
            }
        }
        return 0;
    }

    public void func_70030_z() {
        super.func_70030_z();
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.type = compound.func_74762_e("Type");
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(10, (Object)((byte)this.type));
        }
        this.field_70145_X = this.type == 4 || this.type == 5 || this.type == 6 || this.type == 7;
        this.isChaser = this.type == 3 || this.type == 4 || this.type == 5 || this.type == 6 || this.type == 7;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Type", this.type);
    }
}

