/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.asm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.classloading.FMLForgePlugin;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import stevesaddons.StevesAddons;

public class StevesAddonsTransformer
implements IClassTransformer,
Opcodes {
    private static Map<String, ClassName> classMap = new HashMap<String, ClassName>();

    public byte[] transform(String className, String className2, byte[] bytes) {
        ClassName clazz = classMap.get(className);
        if (clazz != null) {
            bytes = clazz.transform(bytes);
            classMap.remove(className);
        }
        return bytes;
    }

    static {
        for (ClassName className : ClassName.values()) {
            classMap.put(className.getName(), className);
        }
    }

    private static enum ClassName {
        TE_MANAGER("vswe.stevesfactory.blocks.TileEntityManager", Transformer.ACTIVATE_TRIGGER, Transformer.GET_GUI, Transformer.MANAGER_INIT, Transformer.UPDATE_ENTITY),
        CLUSTER_BLOCK("vswe.stevesfactory.blocks.BlockCableCluster", Transformer.CREATE_TE),
        ITEM_SETTING_LOAD("vswe.stevesfactory.components.ItemSetting", Transformer.ITEM_SETTING_LOAD),
        COMPONENT_MENU_ITEM("vswe.stevesfactory.components.ComponentMenuItem", Transformer.ITEM_SEARCH),
        CONNECTION_BLOCK("vswe.stevesfactory.blocks.ConnectionBlock", Transformer.GET_DESCRIPTION),
        COMPONENT_MENU_CONTAINER("vswe.stevesfactory.components.ComponentMenuContainer$2", Transformer.CONTAINER_SEARCH),
        CLUSTER_TILE("vswe.stevesfactory.blocks.TileEntityCluster", Transformer.PUBLIC_PAIR, Transformer.GET_PUBLIC_REGISTRATIONS),
        RF_CLUSTER_TILE("vswe.stevesfactory.blocks.TileEntityRFCluster", Transformer.GET_REGISTRATIONS, Transformer.GET_RF_NODE),
        CLUSTER_PAIR("vswe.stevesfactory.blocks.TileEntityCluster$Pair", Transformer.PUBLIC_TE),
        SETTINGS("vswe.stevesfactory.settings.Settings", Transformer.LOAD_DEFAULT),
        CONTAINER_TYPES("vswe.stevesfactory.components.ComponentMenuContainerTypes", Transformer.WRITE_TO_NBT, Transformer.READ_FROM_NBT),
        DATA_BIT_HELPER("vswe.stevesfactory.network.DataBitHelper", Transformer.BIT_HELPER_INIT),
        CONNECTION_BLOCK_TYPE("vswe.stevesfactory.blocks.ConnectionBlockType", Transformer.IS_INSTANCE),
        COMPONENT_MENU_INTERVAL("vswe.stevesfactory.components.ComponentMenuInterval", Transformer.IS_VISIBLE);

        private String name;
        private Transformer[] transformers;

        private ClassName(String name, Transformer ... transformers) {
            this.name = name;
            this.transformers = transformers;
        }

        public String getName() {
            return this.name;
        }

        public Transformer[] getTransformers() {
            return this.transformers;
        }

        public byte[] transform(byte[] bytes) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)classNode, 0);
            StevesAddons.log.log(Level.INFO, "Applying Transformer" + (this.transformers.length > 1 ? "s " : " ") + "to " + this.getName());
            for (Transformer transformer : this.getTransformers()) {
                transformer.transform(classNode);
            }
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
    }

    private static enum Transformer {
        ACTIVATE_TRIGGER("activateTrigger", "(Lvswe/stevesfactory/components/FlowComponent;Ljava/util/EnumSet;)V"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                return Transformer.replace(list, "vswe/stevesfactory/components/CommandExecutor", "vswe/stevesfactory/components/CommandExecutorRF");
            }
        }
        ,
        GET_GUI("getGui", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/entity/player/InventoryPlayer;)Lnet/minecraft/client/gui/GuiScreen;"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                return Transformer.replace(list, "vswe/stevesfactory/interfaces/GuiManager", "stevesaddons/interfaces/GuiRFManager");
            }
        }
        ,
        CREATE_TE("func_149915_a", "(Lnet/minecraft/world/World;I)Lnet/minecraft/tileentity/TileEntity;"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                return Transformer.replace(list, "vswe/stevesfactory/blocks/TileEntityCluster", "vswe/stevesfactory/blocks/TileEntityRFCluster");
            }
        }
        ,
        MANAGER_INIT("<init>", "()V"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                AbstractInsnNode node;
                for (node = list.getLast(); !(node instanceof LineNumberNode && ((LineNumberNode)node).line == 85 || node == list.getFirst()); node = node.getPrevious()) {
                }
                list.insertBefore(node, (AbstractInsnNode)new VarInsnNode(25, 0));
                list.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(184, "stevesaddons/asm/StevesHooks", "addCopyButton", "(Lvswe/stevesfactory/blocks/TileEntityManager;)V", false));
                return list;
            }
        }
        ,
        ITEM_SETTING_LOAD("load", "(Lnet/minecraft/nbt/NBTTagCompound;)V"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                AbstractInsnNode node;
                for (node = list.getLast(); node.getOpcode() != 177 && node != list.getFirst(); node = node.getPrevious()) {
                }
                list.insertBefore(node, (AbstractInsnNode)new VarInsnNode(25, 0));
                list.insertBefore(node, (AbstractInsnNode)new VarInsnNode(25, 0));
                list.insertBefore(node, (AbstractInsnNode)new FieldInsnNode(180, "vswe/stevesfactory/components/ItemSetting", "item", "Lnet/minecraft/item/ItemStack;"));
                list.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(184, "stevesaddons/asm/StevesHooks", "fixLoadingStack", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", false));
                list.insertBefore(node, (AbstractInsnNode)new FieldInsnNode(181, "vswe/stevesfactory/components/ItemSetting", "item", "Lnet/minecraft/item/ItemStack;"));
                return list;
            }
        }
        ,
        STRING_NULL_CHECK("updateSearch", "(Ljava/lang/String;Z)Ljava/util/List;"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                LabelNode labelNode = null;
                for (AbstractInsnNode node = list.getLast(); node != list.getFirst(); node = node.getPrevious()) {
                    if (node instanceof JumpInsnNode) {
                        labelNode = ((JumpInsnNode)node).label;
                        continue;
                    }
                    if (!(node instanceof VarInsnNode) || node.getOpcode() != 25 || ((VarInsnNode)node).var != 10) continue;
                    list.insertBefore(node, (AbstractInsnNode)new VarInsnNode(25, 10));
                    list.insertBefore(node, (AbstractInsnNode)new JumpInsnNode(198, labelNode));
                    break;
                }
                return list;
            }
        }
        ,
        GET_DESCRIPTION("getDescription", "(Lvswe/stevesfactory/interfaces/GuiManager;)Ljava/lang/String;"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                for (AbstractInsnNode node = list.getFirst(); node != null; node = node.getNext()) {
                    if (node.getOpcode() != 58) continue;
                    list.insertBefore(node, (AbstractInsnNode)new VarInsnNode(25, 0));
                    list.insertBefore(node, (AbstractInsnNode)new FieldInsnNode(180, "vswe/stevesfactory/blocks/ConnectionBlock", "tileEntity", "Lnet/minecraft/tileentity/TileEntity;"));
                    list.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(184, "stevesaddons/asm/StevesHooks", "fixToolTip", "(Ljava/lang/String;Lnet/minecraft/tileentity/TileEntity;)Ljava/lang/String;", false));
                    break;
                }
                return list;
            }
        }
        ,
        ITEM_SEARCH("updateSearch", "(Ljava/lang/String;Z)Ljava/util/List;"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                AbstractInsnNode first = list.getFirst();
                list.insertBefore(first, (AbstractInsnNode)new VarInsnNode(25, 0));
                list.insertBefore(first, (AbstractInsnNode)new VarInsnNode(25, 1));
                list.insertBefore(first, (AbstractInsnNode)new VarInsnNode(21, 2));
                list.insertBefore(first, (AbstractInsnNode)new MethodInsnNode(184, "stevesaddons/asm/StevesHooks", "updateItemSearch", "(Lvswe/stevesfactory/components/ComponentMenuItem;Ljava/lang/String;Z)Ljava/util/List;", false));
                list.insertBefore(first, (AbstractInsnNode)new InsnNode(176));
                return list;
            }
        }
        ,
        CONTAINER_SEARCH("updateSearch", "(Ljava/lang/String;Z)Ljava/util/List;"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                LabelNode label = null;
                for (AbstractInsnNode node = list.getFirst(); node != null; node = node.getNext()) {
                    if (node instanceof JumpInsnNode) {
                        label = ((JumpInsnNode)node).label;
                    }
                    if (node.getOpcode() != 25 || ((VarInsnNode)node).var != 8) continue;
                    list.insertBefore(node, (AbstractInsnNode)new VarInsnNode(25, 8));
                    list.insertBefore(node, (AbstractInsnNode)new VarInsnNode(25, 1));
                    list.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(184, "stevesaddons/asm/StevesHooks", "containerAdvancedSearch", "(Lvswe/stevesfactory/blocks/ConnectionBlock;Ljava/lang/String;)Z", false));
                    list.insertBefore(node, (AbstractInsnNode)new JumpInsnNode(154, label));
                    break;
                }
                return list;
            }
        }
        ,
        GET_PUBLIC_REGISTRATIONS("getRegistrations", "(Lvswe/stevesfactory/blocks/ClusterMethodRegistration;)Ljava/util/List;", TransformType.METHOD, TransformType.MAKE_PUBLIC),
        GET_REGISTRATIONS("getRegistrations", "(Lvswe/stevesfactory/blocks/ClusterMethodRegistration;)Ljava/util/List;", TransformType.METHOD, TransformType.DELETE),
        GET_RF_NODE("getTileEntity", "(Ljava/lang/Object;)Lstevesaddons/tileentities/TileEntityRFNode;"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                InsnList result = new InsnList();
                result.add((AbstractInsnNode)new VarInsnNode(25, 1));
                result.add((AbstractInsnNode)new TypeInsnNode(192, "vswe/stevesfactory/blocks/TileEntityCluster$Pair"));
                result.add((AbstractInsnNode)new FieldInsnNode(180, "vswe/stevesfactory/blocks/TileEntityCluster$Pair", "te", "Lvswe/stevesfactory/blocks/TileEntityClusterElement;"));
                result.add((AbstractInsnNode)new TypeInsnNode(192, "stevesaddons/tileentities/TileEntityRFNode"));
                result.add((AbstractInsnNode)new InsnNode(176));
                return result;
            }
        }
        ,
        PUBLIC_TE("te", "Lvswe/stevesfactory/blocks/TileEntityClusterElement;", TransformType.FIELD, TransformType.MAKE_PUBLIC),
        PUBLIC_PAIR("Pair"),
        REMOVE_FLOW_COMPONENT("removeFlowComponent", "(ILjava/util/List;)V"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                list.clear();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new VarInsnNode(21, 1));
                list.add((AbstractInsnNode)new VarInsnNode(25, 2));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "stevesaddons/asm/StevesHooks", "removeFlowComponent", "(Lvswe/stevesfactory/blocks/TileEntityManager;ILjava/util/List;)V", false));
                list.add((AbstractInsnNode)new InsnNode(177));
                return list;
            }

            @Override
            protected void methodTransform(ClassNode node) {
                MethodNode methodNode = this.getMethod(node);
                if (methodNode != null) {
                    methodNode.instructions = this.modifyInstructions(methodNode.instructions);
                    methodNode.localVariables = null;
                    this.complete();
                }
            }
        }
        ,
        LOAD_DEFAULT("loadDefault", "()V"){
            private Set<String> change = new HashSet<String>(Arrays.asList("largeOpenHitBox", "largeOpenHitBoxMenu", "autoBlacklist", "autoSide"));

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                for (AbstractInsnNode node = list.getFirst(); node != null; node = node.getNext()) {
                    if (!(node instanceof FieldInsnNode) || !this.change.contains(((FieldInsnNode)node).name)) continue;
                    list.remove(node.getPrevious());
                    list.insertBefore(node, (AbstractInsnNode)new InsnNode(4));
                }
                return list;
            }
        }
        ,
        READ_FROM_NBT("readFromNBT", "(Lnet/minecraft/nbt/NBTTagCompound;IZ)V"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                for (AbstractInsnNode node = list.getFirst(); node != null; node = node.getNext()) {
                    if (node.getOpcode() != 182 || !((MethodInsnNode)node).name.equals(FMLForgePlugin.RUNTIME_DEOBF ? "func_74771_c" : "getByte")) continue;
                    node = node.getPrevious();
                    list.remove(node.getNext());
                    list.insert(node, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/nbt/NBTTagCompound", FMLForgePlugin.RUNTIME_DEOBF ? "func_74765_d" : "getShort", "(Ljava/lang/String;)S", false));
                    break;
                }
                return list;
            }
        }
        ,
        WRITE_TO_NBT("writeToNBT", "(Lnet/minecraft/nbt/NBTTagCompound;Z)V"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                for (AbstractInsnNode node = list.getFirst(); node != null; node = node.getNext()) {
                    if (node.getOpcode() == 145) {
                        node = node.getPrevious();
                        list.remove(node.getNext());
                        list.insert(node, (AbstractInsnNode)new InsnNode(147));
                        continue;
                    }
                    if (node.getOpcode() != 182 || !((MethodInsnNode)node).name.equals(FMLForgePlugin.RUNTIME_DEOBF ? "func_74774_a" : "setByte")) continue;
                    node = node.getPrevious();
                    list.remove(node.getNext());
                    list.insert(node, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/nbt/NBTTagCompound", FMLForgePlugin.RUNTIME_DEOBF ? "func_74777_a" : "setShort", "(Ljava/lang/String;S)V", false));
                }
                return list;
            }
        }
        ,
        BIT_HELPER_INIT("<clinit>", "()V"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                for (AbstractInsnNode node = list.getFirst(); node != null; node = node.getNext()) {
                    if (node.getOpcode() != 16 || ((IntInsnNode)node).operand != 39) continue;
                    list.remove(node.getNext());
                    list.insert(node, (AbstractInsnNode)new InsnNode(7));
                    break;
                }
                return list;
            }
        }
        ,
        IS_INSTANCE("isInstance", "(Lnet/minecraft/tileentity/TileEntity;)Z"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                list.clear();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new FieldInsnNode(180, "vswe/stevesfactory/blocks/ConnectionBlockType", "clazz", "Ljava/lang/Class;"));
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "stevesaddons/asm/StevesHooks", "instanceOf", "(Ljava/lang/Class;Lnet/minecraft/tileentity/TileEntity;)Z", false));
                list.add((AbstractInsnNode)new InsnNode(172));
                return list;
            }
        }
        ,
        IS_VISIBLE("isVisible", "()Z"){

            @Override
            public void transform(ClassNode node) {
                MethodNode isVisible = new MethodNode(1, this.name, this.args, null, new String[0]);
                isVisible.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                isVisible.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "vswe/stevesfactory/components/ComponentMenuInterval", "getParent", "()Lvswe/stevesfactory/components/FlowComponent;", false));
                isVisible.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "vswe/stevesfactory/components/FlowComponent", "getConnectionSet", "()Lvswe/stevesfactory/components/ConnectionSet;", false));
                isVisible.instructions.add((AbstractInsnNode)new FieldInsnNode(178, "stevesaddons/helpers/StevesEnum", "DELAYED", "Lvswe/stevesfactory/components/ConnectionSet;"));
                LabelNode l1 = new LabelNode(new Label());
                isVisible.instructions.add((AbstractInsnNode)new JumpInsnNode(165, l1));
                isVisible.instructions.add((AbstractInsnNode)new InsnNode(4));
                isVisible.instructions.add((AbstractInsnNode)new InsnNode(172));
                isVisible.instructions.add((AbstractInsnNode)l1);
                isVisible.instructions.add((AbstractInsnNode)new InsnNode(3));
                isVisible.instructions.add((AbstractInsnNode)new InsnNode(172));
                node.methods.add(isVisible);
            }
        }
        ,
        UPDATE_ENTITY(FMLForgePlugin.RUNTIME_DEOBF ? "func_145845_h" : "updateEntity", "()V"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                for (AbstractInsnNode node = list.getFirst(); node != null; node = node.getNext()) {
                    if (!(node instanceof FieldInsnNode) || !((FieldInsnNode)node).name.equals("timer")) continue;
                    list.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(184, "stevesaddons/asm/StevesHooks", "tickTriggers", "(Lvswe/stevesfactory/blocks/TileEntityManager;)Lvswe/stevesfactory/blocks/TileEntityManager;", false));
                    break;
                }
                return list;
            }
        }
        ,
        REMOVE_COMPONENT("removeFlowComponent", "(I)V"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                JumpInsnNode jump = null;
                for (AbstractInsnNode node = list.getLast(); node != null; node = node.getPrevious()) {
                    if (node.getOpcode() == 167) {
                        jump = (JumpInsnNode)node;
                        continue;
                    }
                    if (node.getOpcode() != 154) continue;
                    ((JumpInsnNode)node).label = jump.label;
                    break;
                }
                return list;
            }
        };

        protected String name;
        protected String args;
        protected TransformType type;
        protected TransformType action;

        private Transformer(String name) {
            this(name, "", TransformType.INNER_CLASS, TransformType.MAKE_PUBLIC);
        }

        private Transformer(String name, String args) {
            this(name, args, TransformType.METHOD, TransformType.MODIFY);
        }

        private Transformer(String name, String args, TransformType type, TransformType action) {
            this.name = name;
            this.args = args;
            this.type = type;
            this.action = action;
        }

        protected InsnList modifyInstructions(InsnList list) {
            return list;
        }

        private static InsnList replace(InsnList list, String toReplace, String replace) {
            InsnList result = new InsnList();
            for (AbstractInsnNode node = list.getFirst(); node != null; node = node.getNext()) {
                result.add(Transformer.checkReplace(node, toReplace, replace));
            }
            return result;
        }

        public String getName() {
            return this.name;
        }

        public String getArgs() {
            return this.args;
        }

        protected void methodTransform(ClassNode node) {
            MethodNode methodNode = this.getMethod(node);
            if (methodNode != null) {
                switch (this.action) {
                    case MODIFY: {
                        methodNode.instructions = this.modifyInstructions(methodNode.instructions);
                        break;
                    }
                    case DELETE: {
                        node.methods.remove(methodNode);
                        break;
                    }
                    case MAKE_PUBLIC: {
                        methodNode.access = methodNode.access & 0xFFFFFFF8 ^ 1;
                    }
                }
                this.complete();
            }
        }

        private void fieldTransform(ClassNode node) {
            FieldNode fieldNode = this.getField(node);
            if (fieldNode != null) {
                switch (this.action) {
                    case MODIFY: {
                        this.modifyField(fieldNode);
                        break;
                    }
                    case DELETE: {
                        node.fields.remove(fieldNode);
                        break;
                    }
                    case MAKE_PUBLIC: {
                        fieldNode.access = fieldNode.access & 0xFFFFFFF8 ^ 1;
                    }
                }
                this.complete();
            }
        }

        private void modifyField(FieldNode fieldNode) {
        }

        private void innerClassTransform(ClassNode node) {
            InnerClassNode innerClassNode = this.getInnerClass(node);
            if (innerClassNode != null) {
                switch (this.action) {
                    case MODIFY: {
                        this.modifyInnerClass(innerClassNode);
                        break;
                    }
                    case DELETE: {
                        node.innerClasses.remove(innerClassNode);
                        break;
                    }
                    case MAKE_PUBLIC: {
                        innerClassNode.access = innerClassNode.access & 0xFFFFFFF8 ^ 1;
                    }
                }
                this.complete();
            }
        }

        private void modifyInnerClass(InnerClassNode innerClassNode) {
        }

        public void transform(ClassNode node) {
            switch (this.type) {
                case METHOD: {
                    this.methodTransform(node);
                    return;
                }
                case FIELD: {
                    this.fieldTransform(node);
                    return;
                }
                case INNER_CLASS: {
                    this.innerClassTransform(node);
                }
            }
        }

        private static AbstractInsnNode checkReplace(AbstractInsnNode node, String toReplace, String replace) {
            if (node instanceof TypeInsnNode && ((TypeInsnNode)node).desc.equals(toReplace)) {
                return new TypeInsnNode(187, replace);
            }
            if (node instanceof MethodInsnNode && ((MethodInsnNode)node).owner.contains(toReplace)) {
                return new MethodInsnNode(node.getOpcode(), replace, ((MethodInsnNode)node).name, ((MethodInsnNode)node).desc, false);
            }
            return node;
        }

        public void complete() {
            StevesAddons.log.info("Applied " + (Object)((Object)this) + " transformer");
        }

        public MethodNode getMethod(ClassNode classNode) {
            for (MethodNode method : classNode.methods) {
                if (!method.name.equals(this.getName()) || !method.desc.equals(this.getArgs())) continue;
                return method;
            }
            for (MethodNode method : classNode.methods) {
                if (!method.desc.equals(this.getArgs())) continue;
                return method;
            }
            return null;
        }

        public FieldNode getField(ClassNode classNode) {
            for (FieldNode field : classNode.fields) {
                if (!field.name.equals(this.getName()) || !field.desc.equals(this.getArgs())) continue;
                return field;
            }
            return null;
        }

        public InnerClassNode getInnerClass(ClassNode classNode) {
            String name = classNode.name + "$" + this.getName();
            for (InnerClassNode inner : classNode.innerClasses) {
                if (!name.equals(inner.name)) continue;
                return inner;
            }
            return null;
        }
    }

    private static enum TransformType {
        METHOD,
        FIELD,
        INNER_CLASS,
        MODIFY,
        MAKE_PUBLIC,
        DELETE;

    }
}

