/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.utils.helpers;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import ganymedes01.headcrumbs.ModBlocks;
import ganymedes01.headcrumbs.ModItems;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.utils.helpers.HeadDropHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.entities.monster.EntityThaumicSlime;

public class ThaumcraftHelper
extends HeadDropHelper {
    public ThaumcraftHelper() {
        super("Thaumcraft");
        this.typesMap.put("Thaumcraft.BrainyZombie", SkullTypes.angryZombie);
        this.typesMap.put("Thaumcraft.GiantBrainyZombie", SkullTypes.angryZombie);
        this.typesMap.put("Thaumcraft.Firebat", SkullTypes.fireBat);
        this.typesMap.put("Thaumcraft.TaintedChicken", SkullTypes.taintedChicken);
        this.typesMap.put("Thaumcraft.TaintedCow", SkullTypes.taintedCow);
        this.typesMap.put("Thaumcraft.TaintedPig", SkullTypes.taintedPig);
        this.typesMap.put("Thaumcraft.TaintedCreeper", SkullTypes.taintedCreeper);
        this.typesMap.put("Thaumcraft.TaintedVillager", SkullTypes.taintedVillager);
        this.typesMap.put("Thaumcraft.TaintedSheep", SkullTypes.taintedSheep);
        this.typesMap.put("Thaumcraft.Pech", SkullTypes.pech);
        this.typesMap.put("Thaumcraft.EldritchGuardian", SkullTypes.eldritchGuardian);
        this.typesMap.put("Thaumcraft.CultistKnight", SkullTypes.cultist);
        this.typesMap.put("Thaumcraft.CultistCleric", SkullTypes.cultist);
        this.typesMap.put("Thaumcraft.EldritchCrab", SkullTypes.eldritchCrab);
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            this.addAspects();
        }
    }

    @Optional.Method(modid="Thaumcraft")
    private void addAspects() {
        AspectList aspects = new AspectList().add(Aspect.MAN, 4).add(Aspect.DEATH, 4).add(Aspect.SOUL, 4);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(ModBlocks.blockPlayer, 1, Short.MAX_VALUE), (AspectList)aspects);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(ModBlocks.blockSkull, 1, Short.MAX_VALUE), (AspectList)aspects);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(ModItems.skull, 1, Short.MAX_VALUE), (AspectList)aspects);
    }

    @Override
    protected ItemStack getHeadForEntity(Entity entity) {
        ItemStack head = super.getHeadForEntity(entity);
        if (head != null) {
            return head;
        }
        if (ThaumcraftHelper.getThaumicSlimeSize(entity) == 1) {
            return SkullTypes.thaumicSlime.getStack();
        }
        return null;
    }

    private static int getThaumicSlimeSize(Entity entity) {
        if (entity instanceof EntityThaumicSlime) {
            return ((EntityThaumicSlime)entity).getSlimeSize();
        }
        return -1;
    }
}

