/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.renderers;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.renderers.ModelHead;
import ganymedes01.headcrumbs.renderers.OpenGLHelper;
import ganymedes01.headcrumbs.tileentities.TileEntityBlockSkull;
import ganymedes01.headcrumbs.utils.helpers.LycanitesHelperClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityBlockSkullRenderer
extends TileEntitySpecialRenderer {
    private ModelHead model;
    public static TileEntityBlockSkullRenderer instance;
    private static EntityLiving entity;

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        TileEntityBlockSkull tileSkull = (TileEntityBlockSkull)tile;
        this.renderHead((float)x, (float)y, (float)z, tileSkull.func_145832_p() & 7, (float)(tileSkull.func_145906_b() * 360) / 16.0f, tileSkull.func_145904_a(), tileSkull.func_152108_a());
    }

    public void func_147497_a(TileEntityRendererDispatcher renderer) {
        super.func_147497_a(renderer);
        instance = this;
    }

    private EntityLiving getEntity() {
        if (entity == null) {
            entity = new EntityLiving((World)Minecraft.func_71410_x().field_71441_e){};
        }
        return entity;
    }

    public void renderHead(float x, float y, float z, ItemStack head) {
        float offset = SkullTypes.values()[head.func_77960_j()].model().playerRenderOffset();
        GameProfile profile = null;
        if (head.func_77942_o()) {
            if (head.func_77978_p().func_150297_b("SkullOwner", 10)) {
                profile = NBTUtil.func_152459_a((NBTTagCompound)head.func_77978_p().func_74775_l("SkullOwner"));
            } else if (head.func_77978_p().func_150297_b("SkullOwner", 8)) {
                profile = new GameProfile(null, head.func_77978_p().func_74779_i("SkullOwner"));
            }
        }
        this.renderHead(x, y, z + offset * 0.0625f, 1, 180.0f, head.func_77960_j(), profile);
    }

    public void renderHead(float x, float y, float z, int meta, float skullRotation, int skullType, GameProfile profile) {
        if (skullType < 0 || skullType >= SkullTypes.values().length) {
            return;
        }
        SkullTypes type = SkullTypes.values()[skullType];
        if (type == SkullTypes.lycanites) {
            this.renderLycanites(x, y, z, meta, skullRotation, type, profile);
        } else {
            this.renderNormal(x, y, z, meta, skullRotation, type, profile);
        }
    }

    private void renderLycanites(float x, float y, float z, int meta, float skullRotation, SkullTypes type, GameProfile profile) {
        if (profile == null || !SkullTypes.lycanites.canShow()) {
            this.renderNormal(x, y, z, meta, skullRotation, SkullTypes.blaze, profile);
            return;
        }
        ModelBase model = LycanitesHelperClient.getModel(profile.getName());
        ResourceLocation tex = type.getTexture(profile);
        if (model != null && tex != null) {
            OpenGLHelper.pushMatrix();
            OpenGLHelper.disableCull();
            OpenGLHelper.enableAlpha();
            this.translateHead(x, y + 1.75f, z, meta);
            skullRotation = this.adjustRotation(meta, skullRotation);
            OpenGLHelper.scale(-1.0f, -1.0f, 1.0f);
            OpenGLHelper.rotate(skullRotation, 0.0f, 1.0f, 0.0f);
            this.func_147499_a(tex);
            model.func_78088_a((Entity)this.getEntity(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f);
            OpenGLHelper.popMatrix();
        }
    }

    private void renderNormal(float x, float y, float z, int meta, float skullRotation, SkullTypes type, GameProfile profile) {
        this.func_147499_a(type.getTexture(profile));
        OpenGLHelper.pushMatrix();
        OpenGLHelper.disableCull();
        OpenGLHelper.enableRescaleNormal();
        OpenGLHelper.enableAlpha();
        this.translateHead(x, y, z, meta);
        skullRotation = this.adjustRotation(meta, skullRotation);
        OpenGLHelper.scale(-1.0f, -1.0f, 1.0f);
        this.model = type.model();
        this.model.preRender(profile);
        this.model.render(skullRotation);
        this.renderSpecial(profile, skullRotation);
        if (GL11.glIsEnabled((int)3042)) {
            OpenGLHelper.enableBlend();
        }
        OpenGLHelper.popMatrix();
    }

    private void renderSpecial(GameProfile profile, float skullRotation) {
        ResourceLocation secondTex = this.model.getSecondTexture();
        if (secondTex != null) {
            this.func_147499_a(secondTex);
        }
        this.model.renderSpecial(profile, skullRotation);
    }

    private void translateHead(float x, float y, float z, int meta) {
        switch (meta) {
            case 1: {
                OpenGLHelper.translate(x + 0.5f, y, z + 0.5f);
                break;
            }
            case 2: {
                OpenGLHelper.translate(x + 0.5f, y + 0.25f, z + 0.74f);
                break;
            }
            case 3: {
                OpenGLHelper.translate(x + 0.5f, y + 0.25f, z + 0.26f);
                break;
            }
            case 4: {
                OpenGLHelper.translate(x + 0.74f, y + 0.25f, z + 0.5f);
                break;
            }
            default: {
                OpenGLHelper.translate(x + 0.26f, y + 0.25f, z + 0.5f);
            }
        }
    }

    protected float adjustRotation(int meta, float rotation) {
        switch (meta) {
            case 1: 
            case 2: {
                return rotation;
            }
            case 3: {
                return 180.0f;
            }
            case 4: {
                return 270.0f;
            }
        }
        return 90.0f;
    }
}

