/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util;

import cofh.thermalexpansion.api.crafting.CraftingHandlers;
import cofh.thermalexpansion.api.crafting.IChargerHandler;
import cofh.thermalexpansion.api.crafting.ICrucibleHandler;
import cofh.thermalexpansion.api.crafting.IFurnaceHandler;
import cofh.thermalexpansion.api.crafting.IInsolatorHandler;
import cofh.thermalexpansion.api.crafting.IPulverizerHandler;
import cofh.thermalexpansion.api.crafting.ISawmillHandler;
import cofh.thermalexpansion.api.crafting.ISmelterHandler;
import cofh.thermalexpansion.api.crafting.ITransposerHandler;
import cofh.thermalexpansion.api.fuels.ICompressionHandler;
import cofh.thermalexpansion.api.fuels.IEnervationHandler;
import cofh.thermalexpansion.api.fuels.IMagmaticHandler;
import cofh.thermalexpansion.api.fuels.IReactantHandler;
import cofh.thermalexpansion.api.fuels.ISteamHandler;
import cofh.thermalexpansion.util.FuelManager;
import cofh.thermalexpansion.util.crafting.ChargerManager;
import cofh.thermalexpansion.util.crafting.CrucibleManager;
import cofh.thermalexpansion.util.crafting.FurnaceManager;
import cofh.thermalexpansion.util.crafting.InsolatorManager;
import cofh.thermalexpansion.util.crafting.PulverizerManager;
import cofh.thermalexpansion.util.crafting.SawmillManager;
import cofh.thermalexpansion.util.crafting.SmelterManager;
import cofh.thermalexpansion.util.crafting.TransposerManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class APIWarden {
    private APIWarden() {
    }

    static {
        CraftingHandlers.furnace = new FurnaceHandler();
        CraftingHandlers.pulverizer = new PulverizerHandler();
        CraftingHandlers.sawmill = new SawmillHandler();
        CraftingHandlers.smelter = new SmelterHandler();
        CraftingHandlers.crucible = new CrucibleHandler();
        CraftingHandlers.transposer = new TransposerHandler();
        CraftingHandlers.charger = new ChargerHandler();
        CraftingHandlers.insolator = new InsolatorHandler();
    }

    public static class EnervationHandler
    implements IEnervationHandler {
        @Override
        public boolean addFuel(ItemStack itemStack, int n) {
            return false;
        }

        @Override
        public boolean removeFuel(ItemStack itemStack) {
            return false;
        }
    }

    public static class ReactantHandler
    implements IReactantHandler {
        @Override
        public boolean addFuel(String string, int n) {
            return FuelManager.addReactantFuel(string, n);
        }

        @Override
        public boolean addReactant(ItemStack itemStack, int n) {
            return false;
        }

        @Override
        public boolean removeFuel(String string) {
            return false;
        }

        @Override
        public boolean removeReactant(ItemStack itemStack) {
            return false;
        }
    }

    public static class CompressionHandler
    implements ICompressionHandler {
        @Override
        public boolean addFuel(String string, int n) {
            return FuelManager.addCompressionFuel(string, n);
        }

        @Override
        public boolean addCoolant(String string, int n) {
            return FuelManager.addCoolant(string, n);
        }

        @Override
        public boolean removeFuel(String string) {
            return false;
        }

        @Override
        public boolean removeCoolant(String string) {
            return false;
        }
    }

    public static class MagmaticHandler
    implements IMagmaticHandler {
        @Override
        public boolean addFuel(String string, int n) {
            return FuelManager.addMagmaticFuel(string, n);
        }

        @Override
        public boolean removeFuel(String string) {
            return false;
        }
    }

    public static class SteamHandler
    implements ISteamHandler {
        @Override
        public boolean addFuel(ItemStack itemStack, int n) {
            return false;
        }

        @Override
        public boolean removeFuel(ItemStack itemStack) {
            return false;
        }
    }

    public static class InsolatorHandler
    implements IInsolatorHandler {
        @Override
        public boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n2, boolean bl) {
            return InsolatorManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, n2, bl);
        }

        @Override
        public boolean removeRecipe(ItemStack itemStack, ItemStack itemStack2) {
            return InsolatorManager.removeRecipe(itemStack, itemStack2);
        }
    }

    public static class ChargerHandler
    implements IChargerHandler {
        @Override
        public boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, boolean bl) {
            return ChargerManager.addRecipe(n, itemStack, itemStack2, bl);
        }

        @Override
        public boolean removeRecipe(ItemStack itemStack) {
            return ChargerManager.removeRecipe(itemStack);
        }
    }

    public static class TransposerHandler
    implements ITransposerHandler {
        @Override
        public boolean addFillRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, boolean bl, boolean bl2) {
            return TransposerManager.addFillRecipe(n, itemStack, itemStack2, fluidStack, bl, bl2);
        }

        @Override
        public boolean addExtractionRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n2, boolean bl, boolean bl2) {
            return TransposerManager.addExtractionRecipe(n, itemStack, itemStack2, fluidStack, n2, bl, bl2);
        }

        @Override
        public boolean removeFillRecipe(ItemStack itemStack, FluidStack fluidStack) {
            return TransposerManager.removeFillRecipe(itemStack, fluidStack);
        }

        @Override
        public boolean removeExtractionRecipe(ItemStack itemStack) {
            return TransposerManager.removeExtractionRecipe(itemStack);
        }
    }

    public static class CrucibleHandler
    implements ICrucibleHandler {
        @Override
        public boolean addRecipe(int n, ItemStack itemStack, FluidStack fluidStack, boolean bl) {
            return CrucibleManager.addRecipe(n, itemStack, fluidStack, bl);
        }

        @Override
        public boolean removeRecipe(ItemStack itemStack) {
            return CrucibleManager.removeRecipe(itemStack);
        }
    }

    public static class SmelterHandler
    implements ISmelterHandler {
        @Override
        public boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n2, boolean bl) {
            return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, n2, bl);
        }

        @Override
        public boolean removeRecipe(ItemStack itemStack, ItemStack itemStack2) {
            return SmelterManager.removeRecipe(itemStack, itemStack2);
        }
    }

    public static class SawmillHandler
    implements ISawmillHandler {
        @Override
        public boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2, boolean bl) {
            return SawmillManager.addRecipe(n, itemStack, itemStack2, itemStack3, n2, bl);
        }

        @Override
        public boolean removeRecipe(ItemStack itemStack) {
            return SawmillManager.removeRecipe(itemStack);
        }
    }

    public static class PulverizerHandler
    implements IPulverizerHandler {
        @Override
        public boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2, boolean bl) {
            return PulverizerManager.addRecipe(n, itemStack, itemStack2, itemStack3, n2, bl);
        }

        @Override
        public boolean removeRecipe(ItemStack itemStack) {
            return PulverizerManager.removeRecipe(itemStack);
        }
    }

    public static class FurnaceHandler
    implements IFurnaceHandler {
        @Override
        public boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, boolean bl) {
            return FurnaceManager.addRecipe(n, itemStack, itemStack2, bl);
        }

        @Override
        public boolean removeRecipe(ItemStack itemStack) {
            return FurnaceManager.removeRecipe(itemStack);
        }
    }
}

