/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.plate;

import cofh.api.tileentity.IRedstoneControl;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.block.TEBlocks;
import cofh.thermalexpansion.block.plate.BlockPlate;
import cofh.thermalexpansion.block.plate.TilePlatePoweredBase;
import cofh.thermalexpansion.block.simple.BlockAirForce;
import cofh.thermalexpansion.gui.client.plate.GuiPlateExcursion;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cofh.thermalexpansion.network.PacketTEBase;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePlateExcursion
extends TilePlatePoweredBase
implements IRedstoneControl {
    public static final byte MIN_DISTANCE = 0;
    public static final byte MAX_DISTANCE = 25;
    public byte distance = (byte)24;
    public byte realDist = (byte)-1;
    protected boolean isPowered;
    protected IRedstoneControl.ControlMode rsMode = IRedstoneControl.ControlMode.DISABLED;

    public static void initialize() {
        GameRegistry.registerTileEntity(TilePlateExcursion.class, (String)"cofh.thermalexpansion.PlateExcursion");
    }

    public static boolean canFunnelReplaceBlock(Block block, World world, int n, int n2, int n3) {
        return block == null || block.func_149712_f(world, n, n2, n3) == 0.0f || block.isAir((IBlockAccess)world, n, n2, n3);
    }

    public TilePlateExcursion() {
        super(BlockPlate.Types.EXCURSION, 200000);
    }

    @Override
    public void onEntityCollidedWithBlock(Entity entity) {
        if (this.realDist == -1 || (((TileEntity)this).field_145850_b.field_72995_K ? entity instanceof EntityFX : entity instanceof EntityPlayer)) {
            return;
        }
        int n = this.alignment ^ (this.redstoneControlOrDisable() ? (byte)0 : 1);
        ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)(n ^ 1));
        BlockAirForce.repositionEntity(((TileEntity)this).field_145850_b, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, entity, forgeDirection, 0.1);
    }

    public void blockBroken() {
        this.removeBeam();
        super.blockBroken();
    }

    @Override
    public void rotated() {
        this.removeBeam();
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.shouldCheckBeam()) {
            this.updateBeam();
        }
        if (this.realDist > -1) {
            this.storage.extractEnergy((int)this.realDist, false);
        }
    }

    private boolean shouldCheckBeam() {
        return this.realDist < 0 || (((TileEntity)this).field_145850_b.func_82737_E() & 0x1FL) == 0L;
    }

    private void updateBeam() {
        int n;
        int n2;
        int n3;
        int n4 = Math.min(this.storage.getEnergyStored() - 1, this.distance);
        int n5 = this.alignment ^ (this.redstoneControlOrDisable() ? (byte)0 : 1);
        for (n3 = 0; n3 <= n4; n3 = (int)((byte)(n3 + 1))) {
            int[] nArray = this.getVector(n3);
            int n6 = ((TileEntity)this).field_145851_c + nArray[0];
            n2 = ((TileEntity)this).field_145848_d + nArray[1];
            n = ((TileEntity)this).field_145849_e + nArray[2];
            if (n3 == 0) continue;
            if (!((TileEntity)this).field_145850_b.func_72899_e(n6, n2, n)) {
                return;
            }
            Block block = ((TileEntity)this).field_145850_b.func_147439_a(n6, n2, n);
            if (!block.equals(TEBlocks.blockAirForce)) {
                if (!block.isAir((IBlockAccess)((TileEntity)this).field_145850_b, n6, n2, n) && TilePlateExcursion.canFunnelReplaceBlock(block, ((TileEntity)this).field_145850_b, n6, n2, n) && !((TileEntity)this).field_145850_b.func_147480_a(n6, n2, n, true) || !((TileEntity)this).field_145850_b.func_147437_c(n6, n2, n)) break;
                ((TileEntity)this).field_145850_b.func_147465_d(n6, n2, n, TEBlocks.blockAirForce, n5, 6);
                continue;
            }
            if (((TileEntity)this).field_145850_b.func_72805_g(n6, n2, n) != n5) break;
        }
        int n7 = this.realDist + 1;
        n3 = (byte)(n3 - 1);
        this.realDist = (byte)n3;
        n3 = (byte)(n3 + 1);
        while (n3 < n7) {
            int n8;
            int[] nArray = this.getVector(n3 = (int)((byte)(n3 + 1)));
            n2 = ((TileEntity)this).field_145851_c + nArray[0];
            if (!((TileEntity)this).field_145850_b.func_147439_a(n2, n = ((TileEntity)this).field_145848_d + nArray[1], n8 = ((TileEntity)this).field_145849_e + nArray[2]).equals(TEBlocks.blockAirForce)) continue;
            ((TileEntity)this).field_145850_b.func_147465_d(n2, n, n8, Blocks.field_150350_a, 0, 3);
        }
        if (this.realDist != n7) {
            ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        }
    }

    private void removeBeam() {
        for (int i = 1; i <= this.realDist; ++i) {
            int n;
            int n2;
            int[] nArray = this.getVector(i);
            int n3 = ((TileEntity)this).field_145851_c + nArray[0];
            if (!((TileEntity)this).field_145850_b.func_147439_a(n3, n2 = ((TileEntity)this).field_145848_d + nArray[1], n = ((TileEntity)this).field_145849_e + nArray[2]).equals(TEBlocks.blockAirForce)) continue;
            ((TileEntity)this).field_145850_b.func_147465_d(n3, n2, n, Blocks.field_150350_a, 0, 3);
        }
        this.realDist = (byte)-1;
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.distance);
        packetCoFHBase.addByte(this.realDist);
        packetCoFHBase.addBool(this.isPowered);
        packetCoFHBase.addByte(this.rsMode.ordinal());
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.distance = packetCoFHBase.getByte();
            this.realDist = packetCoFHBase.getByte();
            this.isPowered = packetCoFHBase.getBool();
            this.rsMode = IRedstoneControl.ControlMode.values()[packetCoFHBase.getByte()];
        }
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addByte(MathHelper.clamp((int)this.distance, (int)0, (int)25));
        return packetCoFHBase;
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        byte by = packetCoFHBase.getByte();
        if (by != this.distance) {
            this.removeBeam();
            this.distance = (byte)MathHelper.clamp((int)by, (int)0, (int)25);
        }
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.distance = nBTTagCompound.func_74771_c("Dist");
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("RS");
        this.rsMode = IRedstoneControl.ControlMode.values()[nBTTagCompound2.func_74771_c("Mode")];
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74774_a("Dist", this.distance);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74774_a("Mode", (byte)this.rsMode.ordinal());
        nBTTagCompound.func_74782_a("RS", (NBTBase)nBTTagCompound2);
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.distance = nBTTagCompound.func_74771_c("Dist");
        this.realDist = nBTTagCompound.func_74771_c("rDist");
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("RS");
        this.isPowered = nBTTagCompound2.func_74767_n("Power");
        this.rsMode = IRedstoneControl.ControlMode.values()[nBTTagCompound2.func_74771_c("Mode")];
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Dist", this.distance);
        nBTTagCompound.func_74774_a("rDist", this.realDist);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74757_a("Power", this.isPowered);
        nBTTagCompound2.func_74774_a("Mode", (byte)this.rsMode.ordinal());
        nBTTagCompound.func_74782_a("RS", (NBTBase)nBTTagCompound2);
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiPlateExcursion(inventoryPlayer, this);
    }

    public ContainerTEBase getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this, false, false);
    }

    public void onNeighborBlockChange() {
        this.setPowered(((TileEntity)this).field_145850_b.func_72864_z(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e));
    }

    public final boolean redstoneControlOrDisable() {
        return this.rsMode.isDisabled() || this.isPowered == this.rsMode.getState();
    }

    public final void setPowered(boolean bl) {
        boolean bl2 = this.isPowered;
        this.isPowered = bl;
        if (bl2 != this.isPowered) {
            if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
                ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            } else {
                this.removeBeam();
                this.updateBeam();
            }
        }
    }

    public final boolean isPowered() {
        return this.isPowered;
    }

    public final void setControl(IRedstoneControl.ControlMode controlMode) {
        this.rsMode = controlMode;
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            PacketTEBase.sendRSConfigUpdatePacketToServer(this, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        } else {
            this.sendUpdatePacket(Side.CLIENT);
            boolean bl = this.isPowered;
            this.isPowered = !bl;
            this.setPowered(bl);
        }
    }

    public final IRedstoneControl.ControlMode getControl() {
        return this.rsMode;
    }
}

