/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.plant;

import blusunrize.immersiveengineering.common.IEContent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class BlockIECrop
extends BlockBush
implements IGrowable {
    public String name;
    public String[] subNames;
    public final IIcon[] icons;

    public BlockIECrop(String name, String ... subNames) {
        this.subNames = subNames;
        this.name = name;
        this.icons = new IIcon[subNames.length];
        this.func_149663_c("ImmersiveEngineering." + name);
        this.func_149675_a(true);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
        this.func_149647_a(null);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149649_H();
        GameRegistry.registerBlock((Block)this, (String)name);
    }

    public int func_149645_b() {
        return 6;
    }

    public int getMinMeta(int meta) {
        return meta <= 4 ? 0 : 5;
    }

    public int getMaxMeta(int meta) {
        return meta <= 4 ? 4 : 5;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.getMinMeta(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < this.subNames.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("immersiveengineering:" + this.name + "_" + this.subNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < this.icons.length) {
            return this.icons[meta];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < this.icons.length) {
            return this.icons[meta];
        }
        return null;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        boolean b = super.func_149718_j(world, x, y, z);
        if (world.func_72805_g(x, y, z) == 5) {
            b = world.func_147439_a(x, y - 1, z).equals((Object)this) && world.func_72805_g(x, y - 1, z) == this.getMaxMeta(0);
        }
        return b;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, meta == 0 ? 0.375f : (meta == 1 ? 0.625f : (meta == 2 ? 0.875f : 1.0f)), 1.0f);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (metadata >= 4) {
            for (int i = 0; i < 3 + fortune; ++i) {
                if (world.field_73012_v.nextInt(8) > metadata) continue;
                ret.add(new ItemStack((Item)IEContent.itemMaterial, 1, 3));
            }
            ret.add(new ItemStack((Item)IEContent.itemSeeds, 1, 0));
        }
        return ret;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        if (world.func_72805_g(x, y, z) < this.getMaxMeta(0)) {
            world.func_147460_e(x, y + 1, z, (Block)this);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        this.func_149855_e(world, x, y, z);
        int light = world.func_72957_l(x, y, z);
        if (light >= 12) {
            int meta = world.func_72805_g(x, y, z);
            if (meta > 4) {
                return;
            }
            float growth = this.getGrowthSpeed(world, x, y, z, meta, light);
            if (random.nextInt((int)(50.0f / growth) + 1) == 0) {
                if (this.getMaxMeta(meta) != meta) {
                    world.func_72921_c(x, y, z, ++meta, 3);
                }
                if (meta > 3 && world.func_147437_c(x, y + 1, z)) {
                    world.func_147465_d(x, y + 1, z, (Block)this, meta + 1, 3);
                }
            }
        }
    }

    float getGrowthSpeed(World world, int x, int y, int z, int meta, int light) {
        float growth = 0.125f * (float)(light - 11);
        if (world.func_72937_j(x, y, z)) {
            growth += 2.0f;
        }
        if (world.func_147439_a(x, y - 1, z) != null && world.func_147439_a(x, y - 1, z).isFertile(world, x, y - 1, z)) {
            growth *= 1.5f;
        }
        return 1.0f + growth;
    }

    protected boolean func_149854_a(Block block) {
        return block != null && (block == this || block.equals(Blocks.field_150458_ak) || block instanceof BlockFarmland);
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean client) {
        if (world.func_72805_g(x, y, z) < this.getMaxMeta(world.func_72805_g(x, y, z))) {
            return true;
        }
        return world.func_72805_g(x, y, z) == 4 && !world.func_147439_a(x, y + 1, z).equals((Object)this);
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) < this.getMaxMeta(world.func_72805_g(x, y, z))) {
            return true;
        }
        return world.func_72805_g(x, y, z) == 4 && !world.func_147439_a(x, y + 1, z).equals((Object)this);
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < this.getMaxMeta(meta)) {
            int span = this.getMaxMeta(meta) - meta;
            int newMeta = meta + rand.nextInt(span) + 1;
            if (newMeta != meta) {
                world.func_72921_c(x, y, z, newMeta, 3);
            }
            meta = newMeta;
        }
        if (meta == 4 && world.func_147437_c(x, y + 1, z)) {
            world.func_147465_d(x, y + 1, z, (Block)this, meta + 1, 3);
        }
    }
}

