/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockMetalPress;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMetalPress
extends TileEntityMultiblockPart
implements ISidedInventory,
IEnergyReceiver {
    public int facing = 2;
    public EnergyStorage energyStorage = new EnergyStorage(16000);
    public ItemStack[] inventory = new ItemStack[3];
    public MetalPressRecipe[] curRecipes = new MetalPressRecipe[3];
    public int[] process = new int[3];
    public ItemStack mold = null;
    public boolean active;
    public static final int MAX_PROCESS = 120;
    public int stopped = -1;
    private int stoppedReqSize = -1;
    public static HashMap<ComparableItemStack, Integer> minSizePerMold;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public TileEntityMetalPress master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.offset[0], this.field_145848_d - this.offset[1], this.field_145849_e - this.offset[2]);
        return te instanceof TileEntityMetalPress ? (TileEntityMetalPress)te : null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = null;
        try {
            s = MultiblockMetalPress.instance.getStructureManual()[this.pos / 3][this.pos % 3][0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s != null ? s.func_77946_l() : null;
    }

    public void func_145845_h() {
        if (!this.formed || this.pos != 4) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (!this.active) {
                return;
            }
            for (int i = 0; i < this.process.length; ++i) {
                if (this.process[i] < 0 || this.stopped == i) continue;
                int n = i;
                this.process[n] = this.process[n] + 1;
                if (this.process[i] <= 120) continue;
                this.inventory[i] = null;
                this.process[i] = -1;
            }
            return;
        }
        boolean update = false;
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.stopped != i && this.inventory[i] != null) {
                int perTick;
                if (this.process[i] >= 120) {
                    ItemStack output = this.inventory[i].func_77946_l();
                    TileEntity inventoryTile = this.field_145850_b.func_147438_o(this.field_145851_c + (this.facing == 4 ? -2 : (this.facing == 5 ? 2 : 0)), this.field_145848_d, this.field_145849_e + (this.facing == 2 ? -2 : (this.facing == 3 ? 2 : 0)));
                    if (inventoryTile instanceof IInventory) {
                        output = Utils.insertStackIntoInventory((IInventory)inventoryTile, output, ForgeDirection.OPPOSITES[this.facing]);
                    }
                    if (output != null) {
                        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
                        EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)(this.facing == 4 ? -2 : (this.facing == 5 ? 2 : 0)), (double)this.field_145848_d, (double)this.field_145849_e + 0.5 + (double)(this.facing == 2 ? -2 : (this.facing == 3 ? 2 : 0)), output.func_77946_l());
                        ei.field_70159_w = 0.075f * (float)fd.offsetX;
                        ei.field_70181_x = 0.025000000372529;
                        ei.field_70179_y = 0.075f * (float)fd.offsetZ;
                        this.field_145850_b.func_72838_d((Entity)ei);
                    }
                    this.curRecipes[i] = null;
                    this.process[i] = -1;
                    this.inventory[i] = null;
                    update = true;
                }
                if (this.curRecipes[i] == null) {
                    this.curRecipes[i] = MetalPressRecipe.findRecipe(this.mold, this.inventory[i], true);
                }
                int n = perTick = this.curRecipes[i] != null ? this.curRecipes[i].energy / 120 : 0;
                if ((perTick == 0 || this.energyStorage.extractEnergy(perTick, true) == perTick) && this.process[i] >= 0) {
                    this.energyStorage.extractEnergy(perTick, false);
                    int n2 = i;
                    int n3 = this.process[n2];
                    this.process[n2] = n3 + 1;
                    if (n3 == 60 && this.curRecipes[i] != null) {
                        this.inventory[i] = this.curRecipes[i].output.func_77946_l();
                        update = true;
                    } else if (this.process[i] == 61 && this.mold != null && this.inventory[i].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W)) {
                        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 5.0f, false);
                        this.inventory[i] = null;
                        this.process[i] = -1;
                        update = true;
                    }
                    if (this.active) continue;
                    this.active = true;
                    update = true;
                    continue;
                }
                if (!this.active) continue;
                this.active = false;
                update = true;
                continue;
            }
            if (this.stopped != i) continue;
            if (this.stoppedReqSize < 0) {
                MetalPressRecipe recipe = MetalPressRecipe.findRecipe(this.mold, this.inventory[i], false);
                if (recipe != null) {
                    this.stoppedReqSize = recipe.inputSize;
                } else {
                    this.stopped = -1;
                    update = true;
                    continue;
                }
            }
            if (this.stoppedReqSize > this.inventory[i].field_77994_a) continue;
            this.stopped = -1;
        }
        if (update) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getNextProcessID() {
        if (this.master() != null) {
            return this.master().getNextProcessID();
        }
        int lowestProcess = Integer.MAX_VALUE;
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] != null) continue;
            if (lowestProcess == Integer.MAX_VALUE) {
                lowestProcess = 200;
                for (int j = 0; j < this.inventory.length; ++j) {
                    if (this.inventory[j] == null || this.process[j] >= lowestProcess || this.process[j] < 0) continue;
                    lowestProcess = this.process[j];
                }
            }
            if (lowestProcess > 40) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        int[] processTmp = nbt.func_74759_k("process");
        this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 3);
        for (int i = 0; i < processTmp.length; ++i) {
            if (!(this.process[i] < 0 ^ processTmp[i] < 0) && descPacket) continue;
            this.process[i] = processTmp[i];
        }
        this.energyStorage.readFromNBT(nbt);
        this.mold = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("mold"));
        if (descPacket) {
            this.active = nbt.func_74767_n("active");
        }
        if (nbt.func_74764_b("stoppedSlot")) {
            this.stopped = nbt.func_74762_e("stoppedSlot");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74783_a("process", this.process);
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        if (this.mold != null) {
            nbt.func_74782_a("mold", (NBTBase)this.mold.func_77955_b(new NBTTagCompound()));
        }
        if (descPacket) {
            nbt.func_74757_a("active", this.active);
        }
        nbt.func_74768_a("stoppedSlot", this.stopped);
    }

    public boolean func_145842_c(int id, int arg) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.formed) {
            return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        }
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 4 ? AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2)) : AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos < 3) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.pos % 3 == 0 || this.pos % 3 == 2) {
            yMax = 0.125f;
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.pos == 4 && this.mold != null) {
            EntityItem moldDrop = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.mold);
            this.field_145850_b.func_72838_d((Entity)moldDrop);
        }
        if (this.formed && !this.field_145850_b.field_72995_K) {
            int f = this.facing;
            TileEntityMetalPress master = this.master();
            if (master == null) {
                master = this;
            }
            int startX = master.field_145851_c;
            int startY = master.field_145848_d;
            int startZ = master.field_145849_e;
            for (int yy = -1; yy <= 1; ++yy) {
                for (int l = -1; l <= 1; ++l) {
                    int xx = f > 3 ? l : 0;
                    int zz = f < 4 ? l : 0;
                    ItemStack s = null;
                    TileEntity te = this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz);
                    if (te instanceof TileEntityMetalPress) {
                        s = ((TileEntityMetalPress)te).getOriginalBlock();
                        ((TileEntityMetalPress)te).formed = false;
                    }
                    if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                        s = this.getOriginalBlock();
                    }
                    if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                    if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, s));
                    } else {
                        if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblocks) {
                            this.field_145850_b.func_147468_f(startX + xx, startY + yy, startZ + zz);
                        }
                        int meta = s.func_77960_j();
                        this.field_145850_b.func_147465_d(startX + xx, startY + yy, startZ + zz, Block.func_149634_a((Item)s.func_77973_b()), meta, 3);
                    }
                    TileEntity tile = this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz);
                    if (!(tile instanceof TileEntityConveyorBelt)) continue;
                    ((TileEntityConveyorBelt)tile).facing = ForgeDirection.OPPOSITES[f];
                }
            }
        }
    }

    public int func_70302_i_() {
        if (!this.formed) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.func_70301_a(slot);
        }
        if (slot < this.inventory.length) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (!this.formed) {
            return null;
        }
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.func_70298_a(slot, amount);
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.func_70304_b(slot);
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        MetalPressRecipe recipe;
        if (!this.formed) {
            return;
        }
        TileEntityMetalPress master = this.master();
        if (master != null) {
            master.func_70299_a(slot, stack);
            return;
        }
        int stackLimit = this.func_70297_j_();
        this.inventory[slot] = stack;
        int n = this.process[slot] = stack != null ? 0 : -1;
        if (stack != null && stack.field_77994_a > stackLimit) {
            stack.field_77994_a = stackLimit;
        }
        if ((recipe = MetalPressRecipe.findRecipe(this.mold, stack, false)) != null && recipe.inputSize > this.inventory[slot].field_77994_a) {
            this.stopped = slot;
            this.stoppedReqSize = recipe.inputSize;
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String func_145825_b() {
        return "IEMetalPress";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.func_70297_j_();
        }
        if (this.stopped >= 0) {
            ItemStack input = this.inventory[this.stopped];
            MetalPressRecipe metalPressRecipe = MetalPressRecipe.findRecipe(this.mold, input, false);
            if (metalPressRecipe != null) {
                return metalPressRecipe.inputSize;
            }
            this.stopped = -1;
            this.stoppedReqSize = -1;
        }
        if (minSizePerMold == null || minSizePerMold.isEmpty()) {
            minSizePerMold = new HashMap(MetalPressRecipe.recipeList.size());
            for (Map.Entry entry : MetalPressRecipe.recipeList.asMap().entrySet()) {
                int min = Integer.MAX_VALUE;
                for (MetalPressRecipe p : (Collection)entry.getValue()) {
                    if (p.inputSize >= min) continue;
                    min = p.inputSize;
                }
                minSizePerMold.put((ComparableItemStack)entry.getKey(), min);
            }
        }
        if (this.mold == null) {
            return 1;
        }
        ComparableItemStack compStack = new ComparableItemStack(this.mold);
        return minSizePerMold.containsKey(compStack) ? minSizePerMold.get(compStack) : 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : this.formed && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!this.formed || stack == null) {
            return false;
        }
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.func_94041_b(slot, stack);
        }
        if (this.mold != null) {
            return this.inventory[slot] == null || OreDictionary.itemMatches((ItemStack)stack, (ItemStack)this.inventory[slot], (boolean)true);
        }
        return true;
    }

    public int[] func_94128_d(int side) {
        if (!this.formed) {
            return new int[0];
        }
        if (this.pos == 3) {
            TileEntityMetalPress master = this.master();
            if (master.stopped >= 0) {
                return new int[]{master.stopped};
            }
            int next = this.getNextProcessID();
            if (next == -1) {
                return new int[0];
            }
            return new int[]{next};
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        if (this.pos == 3 && side == ForgeDirection.OPPOSITES[this.facing]) {
            if (!this.func_94041_b(slot, stack)) {
                return false;
            }
            TileEntityMetalPress master = this.master();
            if (master.inventory[slot] == null) {
                return stack.field_77994_a <= master.func_70297_j_();
            }
            return master.inventory[slot].field_77994_a + stack.field_77994_a <= master.func_70297_j_();
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && this.pos == 7 && from == ForgeDirection.UP;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntityMetalPress master = this.master();
        if (this.formed && this.pos == 7 && from == ForgeDirection.UP && master != null) {
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.func_70296_d();
            if (rec > 0) {
                this.field_145850_b.func_147471_g(master.field_145851_c, master.field_145848_d, master.field_145849_e);
            }
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }
}

