/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.Utils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class NEICokeOvenHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(48, 21, 21, 28), "ieCokeOven", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        boolean b = false;
        if (outputId == "liquid" && results != null && results.length > 0 && results[0] instanceof FluidStack) {
            b = ((FluidStack)results[0]).getFluid().equals(IEContent.fluidCreosote);
        }
        if (outputId == "item" && results != null && results.length > 0 && results[0] instanceof ItemStack && FluidContainerRegistry.isFilledContainer((ItemStack)((ItemStack)results[0]))) {
            b = FluidContainerRegistry.getFluidForFilledItem((ItemStack)((ItemStack)results[0])).getFluid().equals(IEContent.fluidCreosote);
        }
        if (b || outputId == this.getOverlayIdentifier()) {
            for (CokeOvenRecipe r : CokeOvenRecipe.recipeList) {
                if (r == null) continue;
                this.arecipes.add(new CachedCokeOvenRecipe(r));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.ImmersiveEngineering.stoneDevice.cokeOven.name");
    }

    public String getGuiTexture() {
        return "immersiveengineering:textures/gui/cokeOven.png";
    }

    public String getOverlayIdentifier() {
        return "ieCokeOven";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null) {
            for (CokeOvenRecipe r : CokeOvenRecipe.recipeList) {
                if (r == null || !Utils.stackMatchesObject(result, r.output)) continue;
                this.arecipes.add(new CachedCokeOvenRecipe(r));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        CokeOvenRecipe r;
        if (ingredient != null && (r = CokeOvenRecipe.findRecipe(ingredient)) != null) {
            this.arecipes.add(new CachedCokeOvenRecipe(r));
        }
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        CachedCokeOvenRecipe r = (CachedCokeOvenRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            Point localPoint = GuiDraw.getMousePosition();
            int gl = (gui.field_146294_l - 176) / 2;
            int gt = (gui.field_146295_m - 176) / 2;
            if (localPoint.x > gl + 124 && localPoint.x <= gl + 124 + 16 && localPoint.y > gt + 12 && localPoint.y <= gt + 12 + 47) {
                FluidStack fs = new FluidStack(IEContent.fluidCreosote, r.creosote);
                if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fs}) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fs})) {
                    return true;
                }
            }
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        CachedCokeOvenRecipe r = (CachedCokeOvenRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            Point localPoint = GuiDraw.getMousePosition();
            int gl = (gui.field_146294_l - 176) / 2;
            int gt = (gui.field_146295_m - 176) / 2;
            if (localPoint.x > gl + 124 && localPoint.x <= gl + 124 + 16 && localPoint.y > gt + 12 && localPoint.y <= gt + 12 + 47) {
                FluidStack fs = new FluidStack(IEContent.fluidCreosote, r.creosote);
                if (button == 0 ? GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fs}) : button == 1 && GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fs})) {
                    return true;
                }
            }
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> list, int recipe) {
        CachedCokeOvenRecipe r = (CachedCokeOvenRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            Point localPoint = GuiDraw.getMousePosition();
            int gl = (gui.field_146294_l - 176) / 2;
            int gt = (gui.field_146295_m - 134) / 2;
            if (localPoint.x > gl + 124 && localPoint.x <= gl + 124 + 16 && localPoint.y > gt + 64 * (recipe % 2) + 12 && localPoint.y <= gt + 64 * (recipe % 2) + 12 + 47) {
                list.add(IEContent.fluidCreosote.getLocalizedName(new FluidStack(IEContent.fluidCreosote, r.creosote)));
                list.add(r.creosote + " mB");
            }
        }
        return super.handleTooltip(gui, list, recipe);
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-5, (int)0, (int)0, (int)8, (int)176, (int)68);
        CachedCokeOvenRecipe r = (CachedCokeOvenRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            String s = r.time + " Ticks";
            ClientUtils.font().func_85187_a(s, 50 - ClientUtils.font().func_78256_a(s) / 2, 53, 0xAAAAAA, true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int h = (int)Math.max(1.0f, 47.0f * ((float)r.creosote / 12000.0f));
            ClientUtils.drawRepeatedFluidIcon(IEContent.fluidCreosote, 124.0f, 59 - h, 16.0f, h);
            ClientUtils.bindTexture("immersiveengineering:textures/gui/cokeOven.png");
        }
        GuiDraw.drawTexturedModalRect((int)122, (int)10, (int)175, (int)31, (int)20, (int)51);
    }

    public class CachedCokeOvenRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;
        public int creosote;
        public int time;

        public CachedCokeOvenRecipe(CokeOvenRecipe recipe) {
            super((TemplateRecipeHandler)NEICokeOvenHandler.this);
            Object in = recipe.input;
            if (in instanceof String) {
                in = OreDictionary.getOres((String)((String)in));
            }
            this.input = new PositionedStack(in, 25, 27);
            this.output = new PositionedStack((Object)recipe.output, 80, 27);
            this.creosote = recipe.creosoteOutput;
            this.time = recipe.time;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEICokeOvenHandler.this.cycleticks / 20, Arrays.asList(this.input));
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

