/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class NEIBlastFurnaceHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(66, 21, 32, 28), "ieBlastFurnace", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId == this.getOverlayIdentifier()) {
            for (BlastFurnaceRecipe r : BlastFurnaceRecipe.recipeList) {
                if (r == null) continue;
                this.arecipes.add(new CachedBlastFurnaceRecipe(r));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.name.blastFurnace");
    }

    public String getGuiTexture() {
        return "immersiveengineering:textures/gui/blastFurnace.png";
    }

    public String getOverlayIdentifier() {
        return "ieBlastFurnace";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null) {
            for (BlastFurnaceRecipe r : BlastFurnaceRecipe.recipeList) {
                if (r == null || !Utils.stackMatchesObject(result, r.output)) continue;
                this.arecipes.add(new CachedBlastFurnaceRecipe(r));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient != null) {
            BlastFurnaceRecipe r = BlastFurnaceRecipe.findRecipe(ingredient);
            if (r != null) {
                this.arecipes.add(new CachedBlastFurnaceRecipe(r));
            } else if (BlastFurnaceRecipe.isValidBlastFuel(ingredient)) {
                for (BlastFurnaceRecipe r1 : BlastFurnaceRecipe.recipeList) {
                    if (r1 == null) continue;
                    this.arecipes.add(new CachedBlastFurnaceRecipe(r1));
                }
            }
        }
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        if (recipe % 2 == 0 && BlastFurnaceRecipe.isValidBlastFuel(stack)) {
            currenttip.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.blastFuelTime", (Object[])new Object[]{BlastFurnaceRecipe.getBlastFuelTime(stack)}));
        }
        return currenttip;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-5, (int)0, (int)0, (int)8, (int)176, (int)68);
        CachedBlastFurnaceRecipe r = (CachedBlastFurnaceRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            String s = r.time + " Ticks";
            ClientUtils.font().func_85187_a(s, 120 - ClientUtils.font().func_78256_a(s) / 2, 32, 0xAAAAAA, true);
        }
    }

    public class CachedBlastFurnaceRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;
        PositionedStack slag;
        public int time;
        List<PositionedStack> fuels;

        public CachedBlastFurnaceRecipe(BlastFurnaceRecipe recipe) {
            super((TemplateRecipeHandler)NEIBlastFurnaceHandler.this);
            this.fuels = new ArrayList<PositionedStack>();
            Object in = recipe.input;
            if (in instanceof String) {
                in = OreDictionary.getOres((String)((String)in));
            }
            this.input = new PositionedStack(in, 47, 9);
            this.output = new PositionedStack((Object)recipe.output, 107, 9);
            if (recipe.slag != null) {
                this.slag = new PositionedStack((Object)recipe.slag, 107, 45);
            }
            this.time = recipe.time;
            for (Object fuel : BlastFurnaceRecipe.blastFuels.keySet()) {
                this.fuels.add(new PositionedStack(fuel, 47, 45));
            }
        }

        public List<PositionedStack> getOtherStacks() {
            if (this.slag != null) {
                return Arrays.asList(this.fuels.get(NEIBlastFurnaceHandler.this.cycleticks / 20 % this.fuels.size()), this.slag);
            }
            return Arrays.asList(this.fuels.get(NEIBlastFurnaceHandler.this.cycleticks / 20 % this.fuels.size()));
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

