/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.utils;

import java.util.List;
import openperipheral.addons.glasses.utils.ColorPoint2d;
import openperipheral.addons.glasses.utils.IRenderCommand;
import openperipheral.addons.glasses.utils.PointData;
import openperipheral.addons.glasses.utils.PolygonBuilderBase;
import openperipheral.addons.glasses.utils.RenderState;
import org.lwjgl.opengl.GL11;

public class GradientPolygonBuilder
extends PolygonBuilderBase<ColorPoint2d, PointData> {
    private static IRenderCommand createVertexCommand(final double x, final double y, final int rgb, final float opacity) {
        return new IRenderCommand(){

            @Override
            public void execute(RenderState renderState) {
                renderState.setColor(rgb, opacity);
                GL11.glVertex2d((double)x, (double)y);
            }
        };
    }

    @Override
    protected IRenderCommand createVertexCommand(PointData v) {
        return GradientPolygonBuilder.createVertexCommand(v.coords[0], v.coords[1], v.rgb, v.opacity);
    }

    @Override
    protected PointData onCombine(double[] coords, List<PolygonBuilderBase.CombineData<PointData>> data) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float opacity = 0.0f;
        for (PolygonBuilderBase.CombineData<PointData> d : data) {
            PointData p = (PointData)d.object;
            int pR = p.rgb >> 16 & 0xFF;
            int pG = p.rgb >> 8 & 0xFF;
            int pB = p.rgb >> 0 & 0xFF;
            r += (float)pR * d.weight;
            g += (float)pG * d.weight;
            b += (float)pB * d.weight;
            opacity += p.opacity * d.weight;
        }
        int rgb = (((int)r & 0xFF) << 16) + (((int)g & 0xFF) << 8) + (((int)b & 0xFF) << 0);
        return new PointData(coords, rgb, opacity);
    }

    @Override
    protected double[] createCoords(ColorPoint2d point) {
        return new double[]{point.x, point.y, 0.0};
    }

    @Override
    protected PointData convertToData(ColorPoint2d point) {
        return new PointData(new double[]{point.x, point.y, 0.0}, point.rgb, point.opacity);
    }
}

