/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.api.friends.ILMPlayer;
import ftb.utils.world.LMPlayerClient;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorld;
import ftb.utils.world.PersonalSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import latmod.lib.IntList;
import latmod.lib.LMUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class LMPlayer
implements ILMPlayer,
Comparable<ILMPlayer> {
    private final int playerID;
    private GameProfile gameProfile;
    public final IntList friends;
    public final ItemStack[] lastArmor;
    protected NBTTagCompound commonPublicData = null;
    protected NBTTagCompound commonPrivateData = null;
    public boolean renderBadge;

    public LMPlayer(int i, GameProfile gp) {
        this.playerID = i;
        this.gameProfile = gp;
        this.friends = new IntList();
        this.lastArmor = new ItemStack[5];
        this.renderBadge = true;
    }

    public abstract LMWorld getWorld();

    public final String getStringUUID() {
        return LMUtils.fromUUID((UUID)this.gameProfile.getId());
    }

    public abstract LMPlayerServer toPlayerMP();

    @SideOnly(value=Side.CLIENT)
    public abstract LMPlayerClient toPlayerSP();

    public void setProfile(GameProfile p) {
        if (p != null) {
            this.gameProfile = p;
        }
    }

    public final int getPlayerID() {
        return this.playerID;
    }

    public final GameProfile getProfile() {
        return this.gameProfile;
    }

    public boolean isFriendRaw(ILMPlayer p) {
        return p != null && (this.playerID == p.getPlayerID() || this.friends.contains(p.getPlayerID()));
    }

    public boolean isFriend(ILMPlayer p) {
        return p != null && this.isFriendRaw(p) && p.isFriendRaw((ILMPlayer)this);
    }

    @Override
    public final int compareTo(ILMPlayer o) {
        return Integer.compare(this.playerID, o.getPlayerID());
    }

    public String toString() {
        return this.gameProfile.getName();
    }

    public final int hashCode() {
        return this.playerID;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Integer || o instanceof LMPlayer) {
            int h = o.hashCode();
            return h <= 0 ? false : h == this.playerID;
        }
        return o != null && (o == this || this.equalsPlayer(this.getWorld().getPlayer(o)));
    }

    public boolean equalsPlayer(LMPlayer p) {
        return p != null && (p == this || p.playerID == this.playerID);
    }

    public List<LMPlayer> getFriends() {
        ArrayList<LMPlayer> list = new ArrayList<LMPlayer>();
        for (int i = 0; i < this.friends.size(); ++i) {
            LMPlayer p = this.getWorld().getPlayer(this.friends.get(i));
            if (p == null) continue;
            list.add(p);
        }
        return list;
    }

    public final NBTTagCompound getPublicData() {
        if (this.commonPublicData == null) {
            this.commonPublicData = new NBTTagCompound();
        }
        return this.commonPublicData;
    }

    public final NBTTagCompound getPrivateData() {
        if (this.commonPrivateData == null) {
            this.commonPrivateData = new NBTTagCompound();
        }
        return this.commonPrivateData;
    }

    public PersonalSettings getSettings() {
        return null;
    }

    public boolean allowInteractSecure() {
        return false;
    }
}

