/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.config;

import cpw.mods.fml.relauncher.Side;
import ftb.lib.api.config.ConfigEntryBool;
import ftb.lib.api.config.ConfigEntryDouble;
import ftb.lib.api.config.ConfigEntryStringArray;
import java.util.ArrayList;
import java.util.List;
import latmod.lib.annotations.Info;
import latmod.lib.annotations.NumberBounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;

public class FTBUConfigGeneral {
    @NumberBounds(min=0.0, max=720.0)
    @Info(value={"Server will automatically shut down after X hours", "0 - Disabled", "0.5 - 30 minutes", "1 - 1 Hour", "24 - 1 Day", "168 - 1 Week", "720 - 1 Month"})
    public static final ConfigEntryDouble restart_timer = new ConfigEntryDouble("restart_timer", 0.0);
    @Info(value={"If set to true, explosions and hostile mobs in spawn area will be disabled"})
    public static final ConfigEntryBool safe_spawn = new ConfigEntryBool("safe_spawn", false);
    @Info(value={"If set to false, players won't be able to attack each other in spawn area"})
    public static final ConfigEntryBool spawn_pvp = new ConfigEntryBool("spawn_pvp", true);
    @Info(value={"Entity IDs that are banned from world. They will not spawn and existing ones will be destroyed"})
    private static final ConfigEntryStringArray blocked_entities = new ConfigEntryStringArray("blocked_entities", new String[0]);
    @Info(value={"Enable spawn area in singleplayer"})
    public static final ConfigEntryBool spawn_area_in_sp = new ConfigEntryBool("spawn_area_in_sp", false);
    public static final ConfigEntryBool server_info_difficulty = new ConfigEntryBool("server_info_difficulty", true);
    public static final ConfigEntryBool server_info_mode = new ConfigEntryBool("server_info_mode", true);
    private static final List<Class<?>> blockedEntitiesL = new ArrayList();

    public static void onReloaded(Side side) {
        if (side.isServer()) {
            blockedEntitiesL.clear();
            for (String s : blocked_entities.get()) {
                try {
                    Class c = (Class)EntityList.field_75625_b.get(s);
                    if (c == null || !Entity.class.isAssignableFrom(c)) continue;
                    blockedEntitiesL.add(c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isEntityBanned(Class<?> c) {
        for (int i = 0; i < blockedEntitiesL.size(); ++i) {
            Class<?> c1 = blockedEntitiesL.get(i);
            if (!c1.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }
}

