/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.cmd.admin;

import com.mojang.authlib.GameProfile;
import ftb.lib.BaublesHelper;
import ftb.lib.FTBLib;
import ftb.lib.LMNBTUtils;
import ftb.lib.api.cmd.CommandLM;
import ftb.lib.api.cmd.CommandLevel;
import ftb.lib.api.cmd.CommandSubLM;
import ftb.lib.api.item.StringIDInvLoader;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorldServer;
import java.io.File;
import java.util.UUID;
import latmod.lib.LMFileUtils;
import latmod.lib.LMUtils;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CmdPlayerLM
extends CommandSubLM {
    public CmdPlayerLM() {
        super("player_lm", CommandLevel.OP);
        if (FTBLib.DEV_ENV) {
            this.add(new CmdAddFake("add_fake"));
        }
        this.add(new CmdDelete("delete"));
        this.add(new CmdLoadInv("load_inv"));
        this.add(new CmdSaveInv("save_inv"));
    }

    public static class CmdSaveInv
    extends CommandLM {
        public CmdSaveInv(String s) {
            super(s, CommandLevel.OP);
        }

        public String func_71518_a(ICommandSender ics) {
            return '/' + this.commandName + " <player>";
        }

        public Boolean getUsername(String[] args, int i) {
            return i == 0 ? Boolean.FALSE : null;
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            CmdSaveInv.checkArgs((String[])args, (int)1);
            LMPlayerServer p = LMPlayerServer.get(args[0]);
            if (!p.isOnline()) {
                CmdSaveInv.error((IChatComponent)new ChatComponentText("The player must be online!"));
            }
            try {
                EntityPlayerMP ep = p.getPlayer();
                NBTTagCompound tag = new NBTTagCompound();
                StringIDInvLoader.writeInvToNBT((IInventory)ep.field_71071_by, (NBTTagCompound)tag, (String)"Inventory");
                if (FTBLib.isModInstalled((String)"Baubles")) {
                    StringIDInvLoader.writeInvToNBT((IInventory)BaublesHelper.getBaubles((EntityPlayer)ep), (NBTTagCompound)tag, (String)"Baubles");
                }
                String filename = ep.func_70005_c_();
                if (args.length == 2) {
                    filename = "custom/" + args[1];
                }
                LMNBTUtils.writeMap((File)LMFileUtils.newFile((File)new File(FTBLib.folderLocal, "ftbu/playerinvs/" + filename + ".dat")), (NBTTagCompound)tag);
            }
            catch (Exception e) {
                if (FTBLib.DEV_ENV) {
                    e.printStackTrace();
                }
                return CmdSaveInv.error((IChatComponent)new ChatComponentText("Failed to save inventory!"));
            }
            return new ChatComponentText("Inventory saved!");
        }
    }

    public static class CmdLoadInv
    extends CommandLM {
        public CmdLoadInv(String s) {
            super(s, CommandLevel.OP);
        }

        public String func_71518_a(ICommandSender ics) {
            return '/' + this.commandName + " <player>";
        }

        public Boolean getUsername(String[] args, int i) {
            return i == 0 ? Boolean.FALSE : null;
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            CmdLoadInv.checkArgs((String[])args, (int)1);
            LMPlayerServer p = LMPlayerServer.get(args[0]);
            if (!p.isOnline()) {
                CmdLoadInv.error((IChatComponent)new ChatComponentText("The player must be online!"));
            }
            try {
                EntityPlayerMP ep = p.getPlayer();
                String filename = ep.func_70005_c_();
                if (args.length == 2) {
                    filename = "custom/" + args[1];
                }
                NBTTagCompound tag = LMNBTUtils.readMap((File)new File(FTBLib.folderLocal, "ftbu/playerinvs/" + filename + ".dat"));
                StringIDInvLoader.readInvFromNBT((IInventory)ep.field_71071_by, (NBTTagCompound)tag, (String)"Inventory");
                if (FTBLib.isModInstalled((String)"Baubles")) {
                    StringIDInvLoader.readInvFromNBT((IInventory)BaublesHelper.getBaubles((EntityPlayer)ep), (NBTTagCompound)tag, (String)"Baubles");
                }
            }
            catch (Exception e) {
                if (FTBLib.DEV_ENV) {
                    e.printStackTrace();
                }
                return CmdLoadInv.error((IChatComponent)new ChatComponentText("Failed to load inventory!"));
            }
            return new ChatComponentText("Inventory loaded!");
        }
    }

    public static class CmdDelete
    extends CommandLM {
        public CmdDelete(String s) {
            super(s, CommandLevel.OP);
        }

        public String func_71518_a(ICommandSender ics) {
            return '/' + this.commandName + " <player>";
        }

        public Boolean getUsername(String[] args, int i) {
            return i == 0 ? Boolean.FALSE : null;
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            CmdDelete.checkArgs((String[])args, (int)1);
            LMPlayerServer p = LMPlayerServer.get(args[0]);
            if (p.isOnline()) {
                return CmdDelete.error((IChatComponent)new ChatComponentText("The player must be offline!"));
            }
            LMWorldServer.inst.playerMap.remove(p.getPlayerID());
            return new ChatComponentText("Player removed!");
        }
    }

    public static class CmdAddFake
    extends CommandLM {
        public CmdAddFake(String s) {
            super(s, CommandLevel.OP);
        }

        public String func_71518_a(ICommandSender ics) {
            return '/' + this.commandName + " <player>";
        }

        public Boolean getUsername(String[] args, int i) {
            return i == 0 ? Boolean.FALSE : null;
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            CmdAddFake.checkArgs((String[])args, (int)2);
            UUID id = LMUtils.fromString((String)args[0]);
            if (id == null) {
                return CmdAddFake.error((IChatComponent)new ChatComponentText("Invalid UUID!"));
            }
            if (LMWorldServer.inst.getPlayer(id) != null || LMWorldServer.inst.getPlayer(args[1]) != null) {
                return CmdAddFake.error((IChatComponent)new ChatComponentText("Player already exists!"));
            }
            LMPlayerServer p = new LMPlayerServer(LMWorldServer.inst, LMPlayerServer.nextPlayerID(), new GameProfile(id, args[1]));
            LMWorldServer.inst.playerMap.put(p.getPlayerID(), p);
            p.refreshStats();
            return new ChatComponentText("Fake player " + args[1] + " added!");
        }
    }
}

