/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.client.gui.guide;

import ftb.lib.TextureCoords;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.gui.GuiLM;
import ftb.lib.api.gui.IClientActionGui;
import ftb.lib.api.gui.IGuiLM;
import ftb.lib.api.gui.widgets.ButtonLM;
import ftb.lib.api.gui.widgets.PanelLM;
import ftb.lib.api.gui.widgets.SliderLM;
import ftb.lib.api.gui.widgets.WidgetLM;
import ftb.utils.api.guide.ClientGuideFile;
import ftb.utils.api.guide.GuidePage;
import ftb.utils.api.guide.lines.GuideTextLine;
import ftb.utils.mod.client.gui.guide.ButtonGuidePage;
import ftb.utils.mod.client.gui.guide.ButtonGuideTextLine;
import ftb.utils.mod.client.gui.guide.ClientSettings;
import latmod.lib.LMColor;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

public class GuiGuide
extends GuiLM
implements IClientActionGui {
    public static final ResourceLocation tex = new ResourceLocation("ftbu", "textures/gui/guide.png");
    public static final TextureCoords tex_slider = new TextureCoords(tex, 0.0, 30.0, 12.0, 18.0, 64.0, 64.0);
    public static final TextureCoords tex_back = new TextureCoords(tex, 13.0, 30.0, 14.0, 11.0, 64.0, 64.0);
    public static final TextureCoords tex_close = new TextureCoords(tex, 13.0, 41.0, 14.0, 11.0, 64.0, 64.0);
    public static final TextureCoords tex_bullet = new TextureCoords(tex, 0.0, 49.0, 6.0, 6.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_MU = new TextureCoords(tex, 14.0, 0.0, 1.0, 13.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_MD = new TextureCoords(tex, 14.0, 16.0, 1.0, 13.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_ML = new TextureCoords(tex, 0.0, 14.0, 13.0, 1.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_MR = new TextureCoords(tex, 16.0, 14.0, 13.0, 1.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_NN = new TextureCoords(tex, 0.0, 0.0, 13.0, 13.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_PN = new TextureCoords(tex, 16.0, 0.0, 13.0, 13.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_NP = new TextureCoords(tex, 0.0, 16.0, 13.0, 13.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_PP = new TextureCoords(tex, 16.0, 16.0, 13.0, 13.0, 64.0, 64.0);
    public int panelWidth;
    public final GuiGuide parentGui;
    public final GuidePage page;
    public final String pageTitle;
    public GuidePage selectedPage;
    public final SliderLM sliderPages;
    public final SliderLM sliderText;
    public final ButtonLM buttonBack;
    public final PanelLM panelPages;
    public final PanelLM panelText;
    public int colorText;
    public int colorBackground;
    public boolean useUnicodeFont;
    public static GuiGuide clientGuideGui = null;

    public static GuiGuide openClientGui(boolean open) {
        if (clientGuideGui == null) {
            clientGuideGui = new GuiGuide(null, ClientGuideFile.instance);
        }
        if (open) {
            FTBLibClient.openGui((GuiScreen)clientGuideGui);
        }
        return clientGuideGui;
    }

    public GuiGuide(GuiGuide g, GuidePage c) {
        super(null, null);
        this.parentGui = g;
        this.page = c;
        this.pageTitle = this.page.getTitleComponent().func_150254_d();
        this.selectedPage = this.page;
        this.sliderPages = new SliderLM((IGuiLM)this, 0, 0, tex_slider.widthI(), 0, tex_slider.heightI()){

            public boolean canMouseScroll() {
                return this.gui.mouse().x < GuiGuide.this.panelWidth;
            }

            public boolean isEnabled() {
                return true;
            }
        };
        this.sliderPages.isVertical = true;
        this.sliderText = new SliderLM((IGuiLM)this, 0, 0, tex_slider.widthI(), 0, tex_slider.heightI()){

            public boolean canMouseScroll() {
                return this.gui.mouse().x > GuiGuide.this.panelWidth;
            }

            public boolean isEnabled() {
                return true;
            }
        };
        this.sliderText.isVertical = true;
        this.buttonBack = new ButtonLM((IGuiLM)this, 0, 0, tex_back.widthI(), tex_back.heightI()){

            public void onButtonPressed(int b) {
                FTBLibClient.playClickSound();
                if (GuiGuide.this.selectedPage == GuiGuide.this.page || GuiGuide.this.page.getUnformattedText().isEmpty()) {
                    if (GuiGuide.this.parentGui == null) {
                        GuiGuide.this.field_146297_k.field_71439_g.func_71053_j();
                    } else {
                        GuiGuide.this.parentGui.selectedPage = GuiGuide.this.parentGui.page;
                        GuiGuide.this.parentGui.sliderText.value = 0.0f;
                        GuiGuide.this.parentGui.panelText.posY = 10;
                        FTBLibClient.openGui((GuiScreen)GuiGuide.this.parentGui);
                    }
                } else {
                    GuiGuide.this.selectedPage = GuiGuide.this.page;
                    GuiGuide.this.sliderText.value = 0.0f;
                    GuiGuide.this.panelText.posY = 10;
                    GuiGuide.this.initLMGui();
                    GuiGuide.this.refreshWidgets();
                }
            }
        };
        this.panelPages = new PanelLM((IGuiLM)this, 0, 0, 0, 0){

            public void addWidgets() {
                this.height = 0;
                for (GuidePage c : GuiGuide.this.page.childPages.values()) {
                    ButtonGuidePage b = c.createButton(GuiGuide.this);
                    if (b == null || b.height <= 0) continue;
                    this.add((WidgetLM)b);
                    this.height += b.height;
                }
            }
        };
        this.panelText = new PanelLM((IGuiLM)this, 0, 0, 0, 0){

            public void addWidgets() {
                for (WidgetLM w : GuiGuide.this.panelPages.widgets) {
                    ((ButtonGuidePage)w).updateTitle();
                }
                this.height = 0;
                boolean uni = GuiGuide.this.field_146289_q.func_82883_a();
                GuiGuide.this.field_146289_q.func_78264_a(GuiGuide.this.useUnicodeFont);
                for (GuideTextLine line : GuiGuide.this.selectedPage.text) {
                    ButtonGuideTextLine l = line == null ? new ButtonGuideTextLine(GuiGuide.this, null) : line.createWidget(GuiGuide.this);
                    if (l == null || l.height <= 0) continue;
                    this.height += l.height;
                    this.add((WidgetLM)l);
                }
                GuiGuide.this.field_146289_q.func_78264_a(uni);
                GuiGuide.this.sliderText.scrollStep = 30.0f / (float)this.height;
            }
        };
    }

    public void addWidgets() {
        this.mainPanel.add((WidgetLM)this.sliderPages);
        this.mainPanel.add((WidgetLM)this.sliderText);
        this.mainPanel.add((WidgetLM)this.buttonBack);
        this.mainPanel.add((WidgetLM)this.panelPages);
        this.mainPanel.add((WidgetLM)this.panelText);
    }

    public void initLMGui() {
        this.mainPanel.width = this.field_146294_l;
        this.mainPanel.height = this.field_146295_m;
        this.panelWidth = this.mainPanel.width / 7 * 2;
        this.panelPages.posX = 10;
        this.panelPages.posY = 46;
        this.panelPages.width = this.panelWidth - 20;
        this.panelPages.height = this.mainPanel.height - 56;
        this.panelText.posX = this.panelWidth + 10;
        this.panelText.posY = 10;
        this.panelText.width = this.field_146294_l - this.panelWidth - 20 - this.sliderText.width;
        this.panelText.height = this.mainPanel.height - 20;
        this.sliderPages.posX = this.panelWidth - this.sliderPages.width - 10;
        this.sliderPages.posY = 46;
        this.sliderPages.height = this.mainPanel.height - 56;
        this.sliderText.posY = 10;
        this.sliderText.height = this.mainPanel.height - 20;
        this.sliderText.posX = this.panelText.getAX() + this.panelText.width + 1;
        this.buttonBack.posX = 12;
        this.buttonBack.posY = 12;
        LMColor c = this.page.getTextColor();
        if (c == null) {
            c = ClientSettings.text_color.value;
        }
        this.colorText = 0xFF000000 | c.color();
        c = this.page.getBackgroundColor();
        if (c == null) {
            c = ClientSettings.bg_color.value;
        }
        this.colorBackground = 0xFF000000 | c.color();
        Boolean b = this.page.useUnicodeFont();
        boolean bl = this.useUnicodeFont = b == null ? ClientSettings.unicode.get() : b.booleanValue();
        if (this.page.getParentTop() == ClientGuideFile.instance) {
            clientGuideGui = this;
        }
    }

    public void drawTexturedModalRectD(double x, double y, double u, double v, double w, double h) {
        GuiGuide.drawTexturedModalRectD((double)x, (double)y, (double)this.field_73735_i, (double)u, (double)v, (double)w, (double)h, (int)64, (int)64);
    }

    public void drawBackground() {
        this.sliderPages.update();
        if (this.sliderPages.value == 0.0f || (float)this.panelPages.height - ((float)this.mainPanel.height - 56.0f) <= 0.0f) {
            this.panelPages.posY = 46;
            this.sliderPages.value = 0.0f;
        } else {
            this.panelPages.posY = (int)(46.0f - this.sliderPages.value * ((float)this.panelPages.height - ((float)this.mainPanel.height - 56.0f)));
        }
        this.sliderText.update();
        if (this.sliderText.value == 0.0f || (float)this.panelText.height - ((float)this.mainPanel.height - 20.0f) <= 0.0f) {
            this.panelText.posY = 10;
            this.sliderText.value = 0.0f;
        } else {
            this.panelText.posY = (int)(10.0f - this.sliderText.value * ((float)this.panelText.height - ((float)this.mainPanel.height - 20.0f)));
        }
        super.drawBackground();
        FTBLibClient.setTexture((ResourceLocation)this.texture);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderFilling(this.panelWidth, 0, this.mainPanel.width - this.panelWidth, this.mainPanel.height, ClientSettings.transparency.getAsInt());
        this.renderFilling(0, 36, this.panelWidth, this.mainPanel.height - 32, 255);
        boolean uni = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(this.useUnicodeFont);
        this.panelText.renderWidget();
        this.field_146289_q.func_78264_a(uni);
        this.panelPages.renderWidget();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBorders(this.panelWidth, 0, this.mainPanel.width - this.panelWidth, this.mainPanel.height);
        this.renderBorders(0, 36, this.panelWidth, this.mainPanel.height - 36);
        this.renderFilling(0, 0, this.panelWidth, 36, 255);
        this.renderBorders(0, 0, this.panelWidth, 36);
        this.sliderPages.renderSlider(tex_slider);
        this.sliderText.renderSlider(tex_slider);
        FTBLibClient.setGLColor((int)this.colorText, (int)255);
        this.buttonBack.render(this.parentGui == null ? tex_close : tex_back);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(this.pageTitle, this.buttonBack.getAX() + this.buttonBack.width + 5, this.mainPanel.posY + 14, this.colorText);
    }

    public void func_146276_q_() {
    }

    private void renderBorders(int px, int py, int w, int h) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiGuide.render((TextureCoords)tex_bg_NN, (double)px, (double)py, (double)this.field_73735_i, (double)13.0, (double)13.0);
        GuiGuide.render((TextureCoords)tex_bg_NP, (double)px, (double)(py + h - 13), (double)this.field_73735_i, (double)13.0, (double)13.0);
        GuiGuide.render((TextureCoords)tex_bg_PN, (double)(px + w - 13), (double)py, (double)this.field_73735_i, (double)13.0, (double)13.0);
        GuiGuide.render((TextureCoords)tex_bg_PP, (double)(px + w - 13), (double)(py + h - 13), (double)this.field_73735_i, (double)13.0, (double)13.0);
        GuiGuide.render((TextureCoords)tex_bg_MU, (double)(px + 13), (double)py, (double)this.field_73735_i, (double)(w - 24), (double)13.0);
        GuiGuide.render((TextureCoords)tex_bg_MR, (double)(px + w - 13), (double)(py + 13), (double)this.field_73735_i, (double)13.0, (double)(h - 25));
        GuiGuide.render((TextureCoords)tex_bg_MD, (double)(px + 13), (double)(py + h - 13), (double)this.field_73735_i, (double)(w - 24), (double)13.0);
        GuiGuide.render((TextureCoords)tex_bg_ML, (double)px, (double)(py + 13), (double)this.field_73735_i, (double)13.0, (double)(h - 25));
    }

    private void renderFilling(int px, int py, int w, int h, int a) {
        FTBLibClient.setGLColor((int)this.colorBackground, (int)a);
        GuiGuide.drawBlankRect((double)(px + 4), (double)(py + 4), (double)this.field_73735_i, (double)(w - 8), (double)(h - 8));
    }

    public void onClientDataChanged() {
        if (this.selectedPage instanceof IClientActionGui) {
            this.selectedPage.onClientDataChanged();
            this.refreshWidgets();
        }
    }
}

