/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.badges;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.gui.GuiLM;
import latmod.lib.util.FinalIDObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class Badge
extends FinalIDObject {
    public static final ResourceLocation defTex = new ResourceLocation("ftbu", "textures/failed_badge.png");
    public static final Badge emptyBadge = new Badge("-", null);
    public final String imageURL;
    private ResourceLocation textureURL = null;

    public Badge(String id, String url) {
        super(id);
        this.imageURL = url;
    }

    public String toString() {
        return this.getID() + " : " + this.imageURL;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture() {
        if (this.imageURL == null) {
            return null;
        }
        if (this.textureURL == null) {
            this.textureURL = new ResourceLocation("ftbu", "textures/badges/" + this.getID());
            FTBLibClient.getDownloadImage((ResourceLocation)this.textureURL, (String)this.imageURL, (ResourceLocation)defTex, null);
        }
        return this.textureURL;
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerRender(EntityPlayer ep) {
        ResourceLocation texture = this.getTexture();
        if (texture == null) {
            return;
        }
        GlStateManager.disableLighting();
        GlStateManager.disableCull();
        GlStateManager.enableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        FTBLibClient.setTexture((ResourceLocation)texture);
        FTBLibClient.pushMaxBrightness();
        GlStateManager.pushMatrix();
        if (ep.func_70093_af()) {
            GlStateManager.rotate((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.translate((float)0.04f, (float)0.01f, (float)0.86f);
        ItemStack armor = ep.func_71124_b(3);
        if (armor != null && armor.func_77973_b().isValidArmor(armor, 1, (Entity)ep)) {
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)-0.0625f);
        }
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiLM.drawTexturedRectD((double)0.0, (double)0.0, (double)0.0, (double)0.2, (double)0.2, (double)0.0, (double)0.0, (double)1.0, (double)1.0);
        FTBLibClient.popMaxBrightness();
        GlStateManager.popMatrix();
    }
}

