/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.playerprops;

import mcjty.rftools.playerprops.BuffProperties;
import mcjty.rftools.playerprops.FavoriteDestinationsProperties;
import mcjty.rftools.playerprops.PorterProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerExtendedProperties
implements IExtendedEntityProperties {
    public static final String ID = "RFToolsPlayerProperties";
    private BuffProperties buffProperties = new BuffProperties();
    private PorterProperties porterProperties = new PorterProperties();
    private FavoriteDestinationsProperties favoriteDestinationsProperties = new FavoriteDestinationsProperties();

    public static PlayerExtendedProperties getProperties(EntityPlayer player) {
        IExtendedEntityProperties properties = player.getExtendedProperties(ID);
        return (PlayerExtendedProperties)properties;
    }

    public void tick() {
        this.porterProperties.tickTeleport();
        this.buffProperties.tickBuffs();
    }

    public void saveNBTData(NBTTagCompound compound) {
        this.porterProperties.saveNBTData(compound);
        this.buffProperties.saveNBTData(compound);
        this.favoriteDestinationsProperties.saveNBTData(compound);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.porterProperties.loadNBTData(compound);
        this.buffProperties.loadNBTData(compound);
        this.favoriteDestinationsProperties.loadNBTData(compound);
    }

    public void init(Entity entity, World world) {
        this.buffProperties.setEntity(entity);
        this.porterProperties.setEntity(entity);
    }

    public BuffProperties getBuffProperties() {
        return this.buffProperties;
    }

    public PorterProperties getPorterProperties() {
        return this.porterProperties;
    }

    public FavoriteDestinationsProperties getFavoriteDestinationsProperties() {
        return this.favoriteDestinationsProperties;
    }
}

